/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.smg.join;

import com.google.common.truth.Truth;
import org.junit.Before;
import org.junit.Test;
import org.sosy_lab.cpachecker.cpa.smg.join.SMGJoinStatus;
import org.sosy_lab.cpachecker.util.smg.SMG;
import org.sosy_lab.cpachecker.util.smg.graph.SMGObject;
import org.sosy_lab.cpachecker.util.smg.graph.SMGPointsToEdge;
import org.sosy_lab.cpachecker.util.smg.graph.SMGValue;
import org.sosy_lab.cpachecker.util.smg.join.NodeMapping;
import org.sosy_lab.cpachecker.util.smg.join.SMGJoinTest0;
import org.sosy_lab.cpachecker.util.smg.join.SMGJoinValues;

public class SMGJoinValuesTest
extends SMGJoinTest0 {
    private SMG smg1;
    private SMG smg2;
    private SMG smgDest;
    private NodeMapping mapping1;
    private NodeMapping mapping2;
    private final SMGValue value1 = this.createValue();
    private final SMGValue value2 = this.createValue();
    private final SMGValue value3 = this.createValue();

    @Before
    public void setUp() {
        this.smg1 = new SMG(mockType8bSize);
        this.smg2 = new SMG(mockType8bSize);
        this.smgDest = new SMG(mockType8bSize);
        this.mapping1 = new NodeMapping();
        this.mapping2 = new NodeMapping();
    }

    @Test
    public void joinValuesIdenticalTest() {
        this.smg1 = this.smg1.copyAndAddValue(this.value1);
        this.smg2 = this.smg2.copyAndAddValue(this.value1);
        SMGJoinValues jv = new SMGJoinValues(SMGJoinStatus.EQUAL, this.smg1, this.smg2, this.smgDest, this.mapping1, this.mapping2, this.value1, this.value1, 0);
        Truth.assertThat((Boolean)jv.isDefined()).isTrue();
        Truth.assertThat((Comparable)((Object)SMGJoinStatus.EQUAL)).isEqualTo((Object)jv.getStatus());
        Truth.assertThat((Object)jv.getMapping1()).isEqualTo((Object)new NodeMapping());
        Truth.assertThat((Object)jv.getMapping2()).isEqualTo((Object)new NodeMapping());
        Truth.assertThat((Comparable)this.value1).isEqualTo((Object)jv.getValue());
    }

    @Test
    public void joinValuesAlreadyJoinedTest() {
        this.smg1 = this.smg1.copyAndAddValue(this.value1);
        this.smg2 = this.smg2.copyAndAddValue(this.value2);
        this.smgDest = this.smgDest.copyAndAddValue(this.value3);
        this.mapping1.addMapping(this.value1, this.value3);
        this.mapping2.addMapping(this.value2, this.value3);
        SMGJoinValues jv = new SMGJoinValues(SMGJoinStatus.EQUAL, this.smg1, this.smg2, this.smgDest, this.mapping1, this.mapping2, this.value1, this.value2, 0);
        Truth.assertThat((Boolean)jv.isDefined()).isTrue();
        Truth.assertThat((Comparable)((Object)jv.getStatus())).isEqualTo((Object)SMGJoinStatus.EQUAL);
        Truth.assertThat((Object)jv.getInputSMG1()).isSameInstanceAs((Object)this.smg1);
        Truth.assertThat((Object)jv.getInputSMG2()).isSameInstanceAs((Object)this.smg2);
        Truth.assertThat((Object)jv.getDestinationSMG()).isSameInstanceAs((Object)this.smgDest);
        Truth.assertThat((Object)jv.mapping1).isSameInstanceAs((Object)this.mapping1);
        Truth.assertThat((Object)jv.mapping2).isSameInstanceAs((Object)this.mapping2);
        Truth.assertThat((Comparable)jv.getValue()).isEqualTo((Object)this.value3);
    }

    @Test
    public void joinValuesNonPointers() {
        this.smg1 = this.smg1.copyAndAddValue(this.value1);
        this.smg2 = this.smg2.copyAndAddValue(this.value2);
        this.smgDest = this.smgDest.copyAndAddValue(this.value3);
        this.mapping1.addMapping(this.value1, this.value3);
        SMGJoinValues jv = new SMGJoinValues(SMGJoinStatus.EQUAL, this.smg1, this.smg2, this.smgDest, this.mapping1, this.mapping2, this.value1, this.value2, 0);
        Truth.assertThat((Boolean)jv.isDefined()).isFalse();
        this.mapping1 = new NodeMapping();
        this.mapping2.addMapping(this.value2, this.value3);
        jv = new SMGJoinValues(SMGJoinStatus.EQUAL, this.smg1, this.smg2, this.smgDest, this.mapping1, this.mapping2, this.value1, this.value2, 0);
        Truth.assertThat((Boolean)jv.isDefined()).isFalse();
        this.mapping2 = new NodeMapping();
        jv = new SMGJoinValues(SMGJoinStatus.EQUAL, this.smg1, this.smg2, this.smgDest, this.mapping1, this.mapping2, this.value1, this.value2, 0);
        Truth.assertThat((Boolean)jv.isDefined()).isTrue();
        Truth.assertThat((Comparable)((Object)jv.getStatus())).isEqualTo((Object)SMGJoinStatus.EQUAL);
        Truth.assertThat((Object)jv.getInputSMG1()).isSameInstanceAs((Object)this.smg1);
        Truth.assertThat((Object)jv.getInputSMG2()).isSameInstanceAs((Object)this.smg2);
        Truth.assertThat((Object)jv.mapping1).isSameInstanceAs((Object)this.mapping1);
        Truth.assertThat((Object)jv.mapping2).isSameInstanceAs((Object)this.mapping2);
        Truth.assertThat((Comparable)jv.getValue()).isNotEqualTo((Object)this.value1);
        Truth.assertThat((Comparable)jv.getValue()).isNotEqualTo((Object)this.value2);
        Truth.assertThat((Comparable)jv.getValue()).isNotEqualTo((Object)this.value3);
        Truth.assertThat((Comparable)this.mapping1.getMappedValue(this.value1)).isEqualTo((Object)jv.getValue());
        Truth.assertThat((Comparable)this.mapping2.getMappedValue(this.value2)).isEqualTo((Object)jv.getValue());
    }

    @Test
    public void joinValuesSinglePointer() {
        this.smg1 = this.smg1.copyAndAddValue(this.value1);
        this.smg2 = this.smg2.copyAndAddValue(this.value2);
        this.smgDest = this.smgDest.copyAndAddValue(this.value3);
        SMGObject obj1 = this.createRegion(64);
        SMGPointsToEdge pt = this.createPTRegionEdge(0, obj1);
        this.smg1 = this.smg1.copyAndAddPTEdge(pt, this.value1);
        SMGJoinValues jv = new SMGJoinValues(SMGJoinStatus.EQUAL, this.smg1, this.smg2, this.smgDest, this.mapping1, this.mapping2, this.value1, this.value2, 0);
        Truth.assertThat((Boolean)jv.isDefined()).isFalse();
    }
}

