/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.smg.join;

import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.Optional;
import org.sosy_lab.cpachecker.cpa.smg.join.SMGJoinStatus;
import org.sosy_lab.cpachecker.util.smg.SMG;
import org.sosy_lab.cpachecker.util.smg.graph.SMGObject;
import org.sosy_lab.cpachecker.util.smg.graph.SMGPointsToEdge;
import org.sosy_lab.cpachecker.util.smg.graph.SMGTargetSpecifier;
import org.sosy_lab.cpachecker.util.smg.graph.SMGValue;
import org.sosy_lab.cpachecker.util.smg.join.NodeMapping;
import org.sosy_lab.cpachecker.util.smg.join.SMGAbstractJoin;

public class SMGMapTargetAddress
extends SMGAbstractJoin {
    public SMGMapTargetAddress(SMGJoinStatus pStatus, SMG pInputSMG1, SMG pInputSMG2, SMG pDestSMG, NodeMapping pMapping1, NodeMapping pMapping2, SMGValue pValue1, SMGValue pValue2) {
        super(pStatus, pInputSMG1, pInputSMG2, pDestSMG, pMapping1, pMapping2);
        this.mapTargetAddress(pValue1, pValue2);
    }

    private void mapTargetAddress(SMGValue v1, SMGValue v2) {
        Optional<SMGPointsToEdge> ptoEdgeOptional1 = this.inputSMG1.getPTEdge(v1);
        Optional<SMGPointsToEdge> pToEdgeOptional2 = this.inputSMG2.getPTEdge(v2);
        Preconditions.checkArgument((boolean)ptoEdgeOptional1.isPresent());
        SMGPointsToEdge ptoEdge1 = ptoEdgeOptional1.orElseThrow();
        SMGObject resSmgObject = ptoEdge1.pointsTo().isZero() ? SMGObject.nullInstance() : this.mapping1.getMappedObject(ptoEdge1.pointsTo());
        SMGTargetSpecifier tg = this.isDLLS(ptoEdge1.pointsTo()) || pToEdgeOptional2.isEmpty() ? ptoEdge1.targetSpecifier() : pToEdgeOptional2.orElseThrow().targetSpecifier();
        Optional<Map.Entry> matchingAddressOptional = this.destSMG.getPTEdgeMapping().entrySet().stream().filter(entry -> ((SMGPointsToEdge)entry.getValue()).getOffset().equals(ptoEdge1.getOffset()) && ((SMGPointsToEdge)entry.getValue()).targetSpecifier().equals((Object)tg) && ((SMGPointsToEdge)entry.getValue()).pointsTo().equals(resSmgObject)).findAny();
        if (matchingAddressOptional.isPresent()) {
            this.value = (SMGValue)matchingAddressOptional.orElseThrow().getKey();
        } else {
            this.value = SMGValue.of(0);
            this.destSMG = this.destSMG.copyAndAddValue(this.value);
            SMGPointsToEdge newEdge = new SMGPointsToEdge(resSmgObject, ptoEdge1.getOffset(), tg);
            this.destSMG = this.destSMG.copyAndAddPTEdge(newEdge, this.value);
            this.mapping1.addMapping(v1, this.value);
            this.mapping2.addMapping(v2, this.value);
        }
    }
}

