/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.smg.join;

import com.google.common.truth.Truth;
import java.math.BigInteger;
import org.junit.Before;
import org.junit.Test;
import org.sosy_lab.cpachecker.cpa.smg.join.SMGJoinStatus;
import org.sosy_lab.cpachecker.util.smg.SMG;
import org.sosy_lab.cpachecker.util.smg.graph.SMGObject;
import org.sosy_lab.cpachecker.util.smg.graph.SMGPointsToEdge;
import org.sosy_lab.cpachecker.util.smg.graph.SMGValue;
import org.sosy_lab.cpachecker.util.smg.join.NodeMapping;
import org.sosy_lab.cpachecker.util.smg.join.SMGJoinTest0;
import org.sosy_lab.cpachecker.util.smg.join.SMGMapTargetAddress;

public class SMGMapTargetAddressTest
extends SMGJoinTest0 {
    private SMG smg1;
    private SMG destSMG;
    private NodeMapping mapping1;
    private NodeMapping mapping2;
    final SMGObject obj1 = this.createRegion(64);
    final SMGValue value1 = this.createValue();
    final SMGPointsToEdge edge1 = this.createPTRegionEdge(0, this.obj1);
    final SMGValue value2 = this.createValue();
    final SMGObject destObj = this.createRegion(64);
    final SMGValue destValue = this.createValue();

    @Before
    public void setUp() {
        this.smg1 = new SMG(mockType8bSize);
        this.destSMG = new SMG(mockType8bSize);
        this.mapping1 = new NodeMapping();
        this.mapping2 = new NodeMapping();
    }

    @Test
    public void mapTargetAddressExistingNull() {
        SMG origDestSMG = this.destSMG;
        NodeMapping origMapping1 = this.cloneMapping(this.mapping1);
        SMGMapTargetAddress mta = new SMGMapTargetAddress(SMGJoinStatus.EQUAL, this.smg1, this.smg1, this.destSMG, this.mapping1, this.mapping1, SMGValue.zeroValue(), SMGValue.zeroValue());
        Truth.assertThat((Object)mta.getDestinationSMG()).isEqualTo((Object)origDestSMG);
        Truth.assertThat((Object)mta.mapping1).isEqualTo((Object)origMapping1);
        Truth.assertThat((Comparable)mta.getValue()).isSameInstanceAs((Object)SMGValue.zeroValue());
    }

    @Test
    public void mapTargetAddressExisting() {
        SMGPointsToEdge destEdge = this.createPTRegionEdge(0, this.destObj);
        this.smg1 = this.smg1.copyAndAddValue(this.value1);
        this.smg1 = this.smg1.copyAndAddObject(this.obj1);
        this.smg1 = this.smg1.copyAndAddPTEdge(this.edge1, this.value1);
        this.destSMG = this.destSMG.copyAndAddValue(this.destValue);
        this.destSMG = this.destSMG.copyAndAddObject(this.destObj);
        this.destSMG = this.destSMG.copyAndAddPTEdge(destEdge, this.destValue);
        this.mapping1.addMapping(this.obj1, this.destObj);
        NodeMapping origMapping1 = this.cloneMapping(this.mapping1);
        SMGMapTargetAddress mta = new SMGMapTargetAddress(SMGJoinStatus.EQUAL, this.smg1, this.smg1, this.destSMG, this.mapping1, this.mapping1, this.value1, this.value1);
        Truth.assertThat((Object)mta.getDestinationSMG()).isEqualTo((Object)this.destSMG);
        Truth.assertThat((Object)mta.mapping1).isEqualTo((Object)origMapping1);
        Truth.assertThat((Comparable)mta.getValue()).isSameInstanceAs((Object)this.destValue);
    }

    @Test
    public void mapTargetAddressNew() {
        this.smg1 = this.smg1.copyAndAddValue(this.value1);
        this.smg1 = this.smg1.copyAndAddObject(this.obj1);
        this.smg1 = this.smg1.copyAndAddPTEdge(this.edge1, this.value1);
        this.destSMG = this.destSMG.copyAndAddObject(this.destObj);
        this.mapping1.addMapping(this.obj1, this.destObj);
        NodeMapping origMapping1 = this.cloneMapping(this.mapping1);
        NodeMapping origMapping2 = this.cloneMapping(this.mapping2);
        SMGMapTargetAddress mta = new SMGMapTargetAddress(SMGJoinStatus.EQUAL, this.smg1, this.smg1, this.destSMG, this.mapping1, this.mapping2, this.value1, this.value2);
        Truth.assertThat((Object)mta.getDestinationSMG()).isNotEqualTo((Object)this.destSMG);
        Truth.assertThat((Object)mta.mapping1).isNotEqualTo((Object)origMapping1);
        Truth.assertThat((Object)mta.mapping2).isNotEqualTo((Object)origMapping2);
        Truth.assertThat((Boolean)this.destSMG.getValues().contains(mta.getValue())).isFalse();
        SMG newDestSmg = mta.getDestinationSMG();
        SMGPointsToEdge newEdge = newDestSmg.getPTEdge(mta.getValue()).orElseThrow();
        Truth.assertThat((Comparable)mta.mapping1.getMappedValue(this.value1)).isSameInstanceAs((Object)mta.getValue());
        Truth.assertThat((Comparable)mta.mapping2.getMappedValue(this.value2)).isSameInstanceAs((Object)mta.getValue());
        Truth.assertThat((Comparable)newEdge.pointsTo()).isSameInstanceAs((Object)this.destObj);
        Truth.assertThat((Comparable)newEdge.getOffset()).isEqualTo((Object)BigInteger.ZERO);
    }
}

