/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.smg.join;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Map;
import org.sosy_lab.cpachecker.cpa.smg.join.SMGJoinStatus;
import org.sosy_lab.cpachecker.util.smg.SMG;
import org.sosy_lab.cpachecker.util.smg.graph.SMGDoublyLinkedListSegment;
import org.sosy_lab.cpachecker.util.smg.graph.SMGHasValueEdge;
import org.sosy_lab.cpachecker.util.smg.graph.SMGObject;
import org.sosy_lab.cpachecker.util.smg.graph.SMGValue;
import org.sosy_lab.cpachecker.util.smg.join.NodeMapping;
import org.sosy_lab.cpachecker.util.smg.join.SMGAbstractJoin;
import org.sosy_lab.cpachecker.util.smg.util.OffsetAndSize;

public class SMGMatchObjects
extends SMGAbstractJoin {
    public SMGMatchObjects(SMGJoinStatus pStatus, SMG pInputSMG1, SMG pInputSMG2, SMG pDestSMG, NodeMapping pMapping1, NodeMapping pMapping2, SMGObject pTargetObject1, SMGObject pTargetObject2) {
        super(pStatus, pInputSMG1, pInputSMG2, pDestSMG, pMapping1, pMapping2);
        Preconditions.checkArgument((this.inputSMG1.getObjects().contains(pTargetObject1) && this.inputSMG2.getObjects().contains(pTargetObject2) ? 1 : 0) != 0, (Object)"Only objects of givens SMGs can be joined.");
        if (!this.checkIfObjectsCanBeJoined(pTargetObject1, pTargetObject2)) {
            this.setBottomState();
            return;
        }
        this.updateJoinStatus(pTargetObject1, pTargetObject2);
    }

    private void updateJoinStatus(SMGObject pObj1, SMGObject pObj2) {
        int length2;
        int length1 = this.isDLLS(pObj1) ? ((SMGDoublyLinkedListSegment)pObj1).getMinLength() : Integer.MAX_VALUE;
        int n = length2 = this.isDLLS(pObj2) ? ((SMGDoublyLinkedListSegment)pObj2).getMinLength() : Integer.MAX_VALUE;
        if (length1 < length2) {
            this.status = this.status.updateWith(SMGJoinStatus.RIGHT_ENTAIL);
        } else if (length1 > length2) {
            this.status = this.status.updateWith(SMGJoinStatus.LEFT_ENTAIL);
        }
    }

    private boolean checkIfMappingsForHVEdgesMatches(SMGObject pObj1, SMGObject pObj2) {
        Map<OffsetAndSize, SMGValue> offsetAndSizeToValue1 = this.mapOffsetAndSizeToValue(this.inputSMG1.getEdges(pObj1));
        Map<OffsetAndSize, SMGValue> offsetAndSizeToValue2 = this.mapOffsetAndSizeToValue(this.inputSMG2.getEdges(pObj2));
        for (Map.Entry<OffsetAndSize, SMGValue> entry : offsetAndSizeToValue1.entrySet()) {
            if (!offsetAndSizeToValue2.containsKey(entry.getKey())) continue;
            SMGValue v1 = entry.getValue();
            SMGValue v2 = offsetAndSizeToValue2.get(entry.getKey());
            if (v1.isZero() || !this.mapping1.hasMapping(v1) || !this.mapping2.hasMapping(v2) || this.mapping1.getMappedValue(v1).equals(this.mapping2.getMappedValue(v2))) continue;
            return false;
        }
        return true;
    }

    private Map<OffsetAndSize, SMGValue> mapOffsetAndSizeToValue(Collection<SMGHasValueEdge> edges) {
        return (Map)edges.stream().collect(ImmutableMap.toImmutableMap(hvEdge -> new OffsetAndSize(hvEdge.getOffset(), hvEdge.getSizeInBits()), hvEdge -> hvEdge.hasValue()));
    }

    private boolean checkIfObjectsCanBeJoined(SMGObject pObj1, SMGObject pObj2) {
        if (pObj1.isZero() || pObj2.isZero()) {
            return false;
        }
        if (this.mapping1.hasMapping(pObj1) && this.mapping2.hasMapping(pObj2) && !this.mapping1.getMappedObject(pObj1).equals(this.mapping2.getMappedObject(pObj2))) {
            return false;
        }
        if (this.mapping1.hasMapping(pObj1) && this.mapping2.mappingExists(this.mapping1.getMappedObject(pObj1))) {
            return false;
        }
        if (this.mapping2.hasMapping(pObj2) && this.mapping1.mappingExists(this.mapping2.getMappedObject(pObj2))) {
            return false;
        }
        if (!pObj1.getSize().equals(pObj2.getSize()) || this.inputSMG1.isValid(pObj1) != this.inputSMG2.isValid(pObj2)) {
            return false;
        }
        if (this.isDLLS(pObj1) && this.isDLLS(pObj2) && !this.checkIfLabelMatches((SMGDoublyLinkedListSegment)pObj1, (SMGDoublyLinkedListSegment)pObj2)) {
            return false;
        }
        return this.checkIfMappingsForHVEdgesMatches(pObj1, pObj2);
    }

    private boolean checkIfLabelMatches(SMGDoublyLinkedListSegment dlls1, SMGDoublyLinkedListSegment dlls2) {
        return dlls1.getHeadOffset().equals(dlls2.getHeadOffset()) && dlls1.getPrevOffset().equals(dlls2.getPrevOffset()) && dlls1.getNextOffset().equals(dlls2.getNextOffset());
    }
}

