/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.smg.join;

import com.google.common.truth.Truth;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.sosy_lab.cpachecker.cpa.smg.join.SMGJoinStatus;
import org.sosy_lab.cpachecker.util.smg.SMG;
import org.sosy_lab.cpachecker.util.smg.graph.SMGHasValueEdge;
import org.sosy_lab.cpachecker.util.smg.graph.SMGObject;
import org.sosy_lab.cpachecker.util.smg.join.NodeMapping;
import org.sosy_lab.cpachecker.util.smg.join.SMGJoinTest0;
import org.sosy_lab.cpachecker.util.smg.join.SMGMatchObjects;

public class SMGMatchObjectsTest
extends SMGJoinTest0 {
    private SMG smg1;
    private SMG smg2;
    private final SMGObject srcObj1 = this.createRegion(mockType4bSize);
    private final SMGObject destObj1 = this.createRegion(mockType4bSize);
    private final SMGObject srcObj2 = this.createRegion(mockType4bSize);
    private final SMGObject destObj2 = this.createRegion(mockType4bSize);
    private NodeMapping mapping1;
    private NodeMapping mapping2;

    @Before
    public void setUp() {
        this.smg1 = new SMG(mockType8bSize);
        this.smg2 = new SMG(mockType8bSize);
        this.mapping1 = new NodeMapping();
        this.mapping2 = new NodeMapping();
    }

    @Test
    public void nullObjectTest() {
        SMGMatchObjects mo = new SMGMatchObjects(SMGJoinStatus.EQUAL, this.smg1, this.smg2, new SMG(this.smg1.getSizeOfPointer()), this.mapping1, this.mapping2, SMGObject.nullInstance(), SMGObject.nullInstance());
        Truth.assertThat((Boolean)mo.isDefined()).isFalse();
        this.smg1 = this.smg1.copyAndAddObject(this.srcObj1);
        mo = new SMGMatchObjects(SMGJoinStatus.EQUAL, this.smg1, this.smg2, new SMG(this.smg1.getSizeOfPointer()), this.mapping1, this.mapping2, this.srcObj1, SMGObject.nullInstance());
        Truth.assertThat((Boolean)mo.isDefined()).isFalse();
    }

    @Test
    public void nonMemberObjectsTestObj1() {
        this.smg2 = this.smg2.copyAndAddObject(this.srcObj2);
        Assert.assertThrows(IllegalArgumentException.class, () -> new SMGMatchObjects(SMGJoinStatus.EQUAL, this.smg1, this.smg2, new SMG(this.smg1.getSizeOfPointer()), this.mapping1, this.mapping2, this.srcObj1, this.srcObj2));
    }

    @Test
    public void nonMemberObjectsTestObj2() {
        this.smg1 = this.smg1.copyAndAddObject(this.srcObj1);
        Assert.assertThrows(IllegalArgumentException.class, () -> new SMGMatchObjects(SMGJoinStatus.EQUAL, this.smg1, this.smg2, new SMG(this.smg1.getSizeOfPointer()), this.mapping1, this.mapping2, this.srcObj1, this.srcObj2));
    }

    @Test
    public void inconsistentMappingTest() {
        this.mapping1.addMapping(this.srcObj1, this.destObj1);
        this.smg1 = this.smg1.copyAndAddObject(this.srcObj1);
        this.smg2 = this.smg2.copyAndAddObject(this.srcObj2);
        this.mapping2.addMapping(this.srcObj2, this.destObj1);
        SMGMatchObjects mo = new SMGMatchObjects(SMGJoinStatus.EQUAL, this.smg1, this.smg2, new SMG(this.smg1.getSizeOfPointer()), this.mapping1, this.mapping2, this.srcObj1, this.srcObj2);
        Truth.assertThat((Boolean)mo.isDefined()).isFalse();
    }

    @Test
    public void inconsistentMappingViceVersaTest() {
        this.mapping2.addMapping(this.srcObj2, this.destObj2);
        this.smg2 = this.smg2.copyAndAddObject(this.srcObj2);
        this.smg1 = this.smg1.copyAndAddObject(this.srcObj1);
        this.mapping1.addMapping(this.srcObj1, this.destObj2);
        SMGMatchObjects mo = new SMGMatchObjects(SMGJoinStatus.EQUAL, this.smg1, this.smg2, new SMG(this.smg1.getSizeOfPointer()), this.mapping1, this.mapping2, this.srcObj1, this.srcObj2);
        Truth.assertThat((Boolean)mo.isDefined()).isFalse();
    }

    @Test
    public void inconsistentObjectsTest() {
        SMGObject diffSizeObject = this.createRegion(128);
        this.smg1 = this.smg1.copyAndAddObject(this.srcObj1);
        this.smg2 = this.smg2.copyAndAddObject(diffSizeObject);
        SMGMatchObjects mo = new SMGMatchObjects(SMGJoinStatus.EQUAL, this.smg1, this.smg2, new SMG(this.smg1.getSizeOfPointer()), this.mapping1, this.mapping2, this.srcObj1, diffSizeObject);
        Truth.assertThat((Boolean)mo.isDefined()).isFalse();
        this.smg2 = this.smg2.copyAndAddObject(this.srcObj2);
        this.smg2 = this.smg2.copyAndInvalidateObject(this.srcObj2);
        mo = new SMGMatchObjects(SMGJoinStatus.EQUAL, this.smg1, this.smg2, new SMG(this.smg1.getSizeOfPointer()), this.mapping1, this.mapping2, this.srcObj1, this.srcObj2);
        Truth.assertThat((Boolean)mo.isDefined()).isFalse();
    }

    @Test
    public void nonMatchingMappingTest() {
        this.smg1 = this.smg1.copyAndAddObject(this.srcObj1);
        this.smg1 = this.smg1.copyAndAddObject(this.destObj1);
        this.mapping1.addMapping(this.srcObj1, this.destObj1);
        this.smg2 = this.smg2.copyAndAddObject(this.srcObj2);
        this.smg2 = this.smg2.copyAndAddObject(this.destObj2);
        this.mapping2.addMapping(this.srcObj2, this.destObj2);
        SMGMatchObjects mo = new SMGMatchObjects(SMGJoinStatus.EQUAL, this.smg1, this.smg2, new SMG(this.smg1.getSizeOfPointer()), this.mapping1, this.mapping2, this.srcObj1, this.srcObj2);
        Truth.assertThat((Boolean)mo.isDefined()).isFalse();
    }

    @Test
    public void fieldInconsistencyTest() {
        this.smg1 = this.smg1.copyAndAddObject(this.srcObj1);
        this.smg2 = this.smg2.copyAndAddObject(this.srcObj2);
        SMGHasValueEdge hv1 = this.createHasValueEdge(2, 0, this.createValue());
        SMGHasValueEdge hv2 = this.createHasValueEdge(2, 2, this.createValue());
        SMGHasValueEdge hvMatching1 = this.createHasValueEdge(2, 4, this.createValue());
        SMGHasValueEdge hvMatching2 = this.createHasValueEdge(2, 4, this.createValue());
        this.smg1 = this.smg1.copyAndAddValue(hv1.hasValue());
        this.smg1 = this.smg1.copyAndAddHVEdge(hv1, this.srcObj1);
        this.smg2 = this.smg2.copyAndAddValue(hv2.hasValue());
        this.smg2 = this.smg2.copyAndAddHVEdge(hv2, this.srcObj2);
        this.smg1 = this.smg1.copyAndAddValue(hvMatching1.hasValue());
        this.smg1 = this.smg1.copyAndAddHVEdge(hvMatching1, this.srcObj1);
        this.smg2 = this.smg2.copyAndAddValue(hvMatching2.hasValue());
        this.smg2 = this.smg2.copyAndAddHVEdge(hvMatching2, this.srcObj2);
        SMGMatchObjects mo = new SMGMatchObjects(SMGJoinStatus.EQUAL, this.smg1, this.smg2, new SMG(this.smg1.getSizeOfPointer()), this.mapping1, this.mapping2, this.srcObj1, this.srcObj2);
        Truth.assertThat((Boolean)mo.isDefined()).isTrue();
        this.mapping1.addMapping(hvMatching1.hasValue(), this.createValue());
        mo = new SMGMatchObjects(SMGJoinStatus.EQUAL, this.smg1, this.smg2, new SMG(this.smg1.getSizeOfPointer()), this.mapping1, this.mapping2, this.srcObj1, this.srcObj2);
        Truth.assertThat((Boolean)mo.isDefined()).isTrue();
        this.mapping2.addMapping(hvMatching2.hasValue(), this.mapping1.getMappedValue(hvMatching1.hasValue()));
        mo = new SMGMatchObjects(SMGJoinStatus.EQUAL, this.smg1, this.smg2, new SMG(this.smg1.getSizeOfPointer()), this.mapping1, this.mapping2, this.srcObj1, this.srcObj2);
        Truth.assertThat((Boolean)mo.isDefined()).isTrue();
        this.mapping2.addMapping(hvMatching2.hasValue(), this.createValue());
        mo = new SMGMatchObjects(SMGJoinStatus.EQUAL, this.smg1, this.smg2, new SMG(this.smg1.getSizeOfPointer()), this.mapping1, this.mapping2, this.srcObj1, this.srcObj2);
        Truth.assertThat((Boolean)mo.isDefined()).isFalse();
    }

    @Test
    public void noAbstractionTest() {
        SMGObject object = this.createRegion(128);
        this.smg1 = this.smg1.copyAndAddObject(object);
        this.smg2 = this.smg2.copyAndAddObject(object);
        SMGMatchObjects mo = new SMGMatchObjects(SMGJoinStatus.EQUAL, this.smg1, this.smg2, new SMG(this.smg1.getSizeOfPointer()), this.mapping1, this.mapping2, object, object);
        Truth.assertThat((Boolean)mo.isDefined()).isTrue();
        Truth.assertThat((Comparable)((Object)mo.getStatus())).isEqualTo((Object)SMGJoinStatus.EQUAL);
    }
}

