/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.smg.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.ForwardingNavigableMap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.cpachecker.util.smg.util.MapValues;
import org.sosy_lab.cpachecker.util.smg.util.OurSortedMap;
import org.sosy_lab.cpachecker.util.smg.util.SortedMapEntrySet;
import org.sosy_lab.cpachecker.util.smg.util.SortedMapKeySet;

@SuppressFBWarnings(value={"NP_PARAMETER_MUST_BE_NONNULL_BUT_MARKED_AS_NULLABLE"}, justification="nullability depends on underlying map")
final class DescendingSortedMap<K, V>
extends ForwardingNavigableMap<K, V>
implements OurSortedMap<K, V>,
Serializable {
    private static final long serialVersionUID = -3499934696704295393L;
    private final OurSortedMap<K, V> map;

    DescendingSortedMap(OurSortedMap<K, V> pMap) {
        this.map = (OurSortedMap)Preconditions.checkNotNull(pMap);
    }

    protected NavigableMap<K, V> delegate() {
        return this.map;
    }

    @Override
    public Iterator<Map.Entry<K, V>> entryIterator() {
        return this.map.descendingEntryIterator();
    }

    @Override
    public Iterator<Map.Entry<K, V>> descendingEntryIterator() {
        return this.map.entryIterator();
    }

    @Override
    public  @Nullable Map.Entry<K, V> getEntry(@Nullable Object pKey) {
        return this.map.getEntry(pKey);
    }

    @Override
    public Comparator<? super K> comparator() {
        return Collections.reverseOrder(this.map.comparator());
    }

    @Override
    public boolean equals(@Nullable Object pObject) {
        if (pObject instanceof DescendingSortedMap) {
            return this.map.equals(((DescendingSortedMap)pObject).map);
        }
        return this.map.equals(pObject);
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    @Override
    public K firstKey() {
        return this.map.lastKey();
    }

    @Override
    public K lastKey() {
        return this.map.firstKey();
    }

    @Override
    public NavigableSet<Map.Entry<K, V>> entrySet() {
        return new SortedMapEntrySet(this);
    }

    @Override
    public NavigableSet<K> keySet() {
        return this.navigableKeySet();
    }

    @Override
    public NavigableSet<K> navigableKeySet() {
        return new SortedMapKeySet(this);
    }

    @Override
    public NavigableSet<K> descendingKeySet() {
        return this.map.navigableKeySet();
    }

    @Override
    public OurSortedMap<K, V> descendingMap() {
        return this.map;
    }

    @Override
    public Collection<V> values() {
        return new MapValues(this);
    }

    @Override
    public Map.Entry<K, V> lowerEntry(@Nullable K pKey) {
        return this.map.higherEntry(pKey);
    }

    @Override
    public K lowerKey(@Nullable K pKey) {
        return this.map.higherKey(pKey);
    }

    @Override
    public Map.Entry<K, V> floorEntry(@Nullable K pKey) {
        return this.map.ceilingEntry(pKey);
    }

    @Override
    public K floorKey(@Nullable K pKey) {
        return this.map.ceilingKey(pKey);
    }

    @Override
    public Map.Entry<K, V> ceilingEntry(@Nullable K pKey) {
        return this.map.floorEntry(pKey);
    }

    @Override
    public K ceilingKey(@Nullable K pKey) {
        return this.map.floorKey(pKey);
    }

    @Override
    public Map.Entry<K, V> higherEntry(@Nullable K pKey) {
        return this.map.lowerEntry(pKey);
    }

    @Override
    public K higherKey(@Nullable K pKey) {
        return this.map.lowerKey(pKey);
    }

    @Override
    public Map.Entry<K, V> firstEntry() {
        return this.map.lastEntry();
    }

    @Override
    public Map.Entry<K, V> lastEntry() {
        return this.map.firstEntry();
    }

    @Override
    public Map.Entry<K, V> pollFirstEntry() {
        return this.map.pollLastEntry();
    }

    @Override
    public Map.Entry<K, V> pollLastEntry() {
        return this.map.pollFirstEntry();
    }

    @Override
    public OurSortedMap<K, V> subMap(@Nullable K pFromKey, boolean pFromInclusive, @Nullable K pToKey, boolean pToInclusive) {
        return this.map.subMap((Object)pToKey, pToInclusive, (Object)pFromKey, pFromInclusive).descendingMap();
    }

    @Override
    public OurSortedMap<K, V> headMap(@Nullable K pToKey, boolean pInclusive) {
        return this.map.tailMap((Object)pToKey, pInclusive).descendingMap();
    }

    @Override
    public OurSortedMap<K, V> tailMap(@Nullable K pFromKey, boolean pInclusive) {
        return this.map.headMap((Object)pFromKey, pInclusive).descendingMap();
    }

    @Override
    public OurSortedMap<K, V> headMap(@Nullable K pToKey) {
        return this.headMap((Object)pToKey, false);
    }

    @Override
    public OurSortedMap<K, V> tailMap(@Nullable K pFromKey) {
        return this.tailMap((Object)pFromKey, true);
    }

    @Override
    public OurSortedMap<K, V> subMap(@Nullable K pFromKey, @Nullable K pToKey) {
        return this.subMap((Object)pFromKey, true, (Object)pToKey, false);
    }

    public String toString() {
        return this.standardToString();
    }
}

