/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.smg.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.Streams;
import com.google.common.collect.UnmodifiableIterator;
import com.google.errorprone.annotations.Immutable;
import com.google.errorprone.annotations.Var;
import com.google.errorprone.annotations.concurrent.LazyInit;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.collect.PathCopyingPersistentTreeMap;
import org.sosy_lab.common.collect.PersistentSortedMap;
import org.sosy_lab.cpachecker.util.smg.graph.SMGHasValueEdge;
import org.sosy_lab.cpachecker.util.smg.graph.SMGValue;
import org.sosy_lab.cpachecker.util.smg.util.AbstractImmutableSortedMap;
import org.sosy_lab.cpachecker.util.smg.util.DescendingSortedMap;
import org.sosy_lab.cpachecker.util.smg.util.OurSortedMap;
import org.sosy_lab.cpachecker.util.smg.util.SortedMapEntrySet;

@Immutable(containerOf={"K", "V"})
public final class PathCopyingPersistentMaxTreeMap<K extends Comparable<K>, V>
implements Serializable {
    private static final long serialVersionUID = 1041711151457528188L;
    private static final PathCopyingPersistentMaxTreeMap<?, ?> EMPTY_MAP = new PathCopyingPersistentMaxTreeMap(null);
    private final @Nullable Node<K, V> root;
    @LazyInit
    private transient int size;

    public static <K extends Comparable<K>, V> PathCopyingPersistentMaxTreeMap<K, V> of() {
        return EMPTY_MAP;
    }

    public static PathCopyingPersistentMaxTreeMap<?, ?> copyOf(PathCopyingPersistentMaxTreeMap<?, ?> map) {
        Preconditions.checkNotNull(map);
        return map;
    }

    private PathCopyingPersistentMaxTreeMap(@Nullable Node<K, V> pRoot) {
        this.root = pRoot;
    }

    private static <K extends Comparable<K>, V> @Nullable Node<K, V> findNode(K key, Node<K, V> root) {
        Preconditions.checkNotNull(key);
        return PathCopyingPersistentMaxTreeMap.findNode1(key, root);
    }

    private static <K extends Comparable<K>, V> @Nullable Node<K, V> findNode1(K key, Node<K, V> root) {
        Preconditions.checkNotNull(key);
        Node<K, V> current = root;
        while (current != null) {
            int comp = key.compareTo((Comparable)((Comparable)current.getKey()));
            if (comp < 0) {
                current = current.left;
                continue;
            }
            if (comp > 0) {
                current = current.right;
                continue;
            }
            return current;
        }
        return null;
    }

    private static <K extends Comparable<K>, V> Node<K, V> findSmallestNode(Node<K, V> root) {
        Node<K, V> current = root;
        while (current.left != null) {
            current = current.left;
        }
        return current;
    }

    private static <K extends Comparable<K>, V> Node<K, V> findLargestNode(Node<K, V> root) {
        Node<K, V> current = root;
        while (current.right != null) {
            current = current.right;
        }
        return current;
    }

    private static <K extends Comparable<K>, V> @Nullable Node<K, V> findNextGreaterNode(K key, Node<K, V> root, boolean inclusive) {
        Preconditions.checkNotNull(key);
        Node<K, V> result = null;
        Node<K, V> current = root;
        while (current != null) {
            int comp = key.compareTo((Comparable)((Comparable)current.getKey()));
            if (comp < 0) {
                result = current;
                current = current.left;
            } else if (comp > 0) {
                current = current.right;
            } else {
                if (inclusive) {
                    return current;
                }
                if (current.right == null) {
                    return result;
                }
                return PathCopyingPersistentMaxTreeMap.findSmallestNode(current.right);
            }
            if (current != null) continue;
            return result;
        }
        return null;
    }

    private static <K extends Comparable<K>, V> @Nullable Node<K, V> findNextSmallerNode(K key, Node<K, V> root, boolean inclusive) {
        Preconditions.checkNotNull(key);
        Node<K, V> result = null;
        Node<K, V> current = root;
        while (current != null) {
            int comp = key.compareTo((Comparable)((Comparable)current.getKey()));
            if (comp < 0) {
                current = current.left;
            } else if (comp > 0) {
                result = current;
                current = current.right;
            } else {
                if (inclusive) {
                    return current;
                }
                if (current.left == null) {
                    return result;
                }
                return PathCopyingPersistentMaxTreeMap.findLargestNode(current.left);
            }
            if (current != null) continue;
            return result;
        }
        return null;
    }

    private static <K extends Comparable<? super K>> boolean exceedsLowerBound(K pKey, K pLowerBound, boolean pLowerInclusive) {
        if (pLowerInclusive) {
            return pKey.compareTo(pLowerBound) < 0;
        }
        return pKey.compareTo(pLowerBound) <= 0;
    }

    private static <K extends Comparable<? super K>> boolean exceedsUpperBound(K pKey, K pUpperBound, boolean pUpperInclusive) {
        if (pUpperInclusive) {
            return pKey.compareTo(pUpperBound) > 0;
        }
        return pKey.compareTo(pUpperBound) >= 0;
    }

    private static <K extends Comparable<K>, V> int checkAssertions(Node<K, V> current) {
        if (current == null) {
            return 0;
        }
        if (current.left != null) {
            Preconditions.checkState((((Comparable)current.getKey()).compareTo((Comparable)current.left.getKey()) > 0 ? 1 : 0) != 0, (Object)"Tree has left child that is not smaller.");
        }
        if (current.right != null) {
            Preconditions.checkState((((Comparable)current.getKey()).compareTo((Comparable)current.right.getKey()) < 0 ? 1 : 0) != 0, (Object)"Tree has right child that is not bigger.");
        }
        Preconditions.checkState((!Node.isRed(current.right) ? 1 : 0) != 0, (Object)"LLRB has red right child");
        Preconditions.checkState((!Node.isRed(current) || !Node.isRed(current.left) || !Node.isRed(current.left.left) ? 1 : 0) != 0, (Object)"LLRB has three red nodes in a row.");
        int leftBlackHeight = PathCopyingPersistentMaxTreeMap.checkAssertions(current.left);
        int rightBlackHeight = PathCopyingPersistentMaxTreeMap.checkAssertions(current.right);
        Preconditions.checkState((leftBlackHeight == rightBlackHeight ? 1 : 0) != 0, (String)"Black path length on left is %s and on right is %s", (int)leftBlackHeight, (int)rightBlackHeight);
        int blackHeight = leftBlackHeight;
        if (!current.isRed) {
            ++blackHeight;
        }
        return blackHeight;
    }

    @VisibleForTesting
    void checkAssertions() {
        PathCopyingPersistentMaxTreeMap.checkAssertions(this.root);
    }

    private PathCopyingPersistentMaxTreeMap<K, V> mapFromTree(@Var Node<K, V> newRoot) {
        if (newRoot == this.root) {
            return this;
        }
        if (newRoot == null) {
            return PathCopyingPersistentMaxTreeMap.of();
        }
        newRoot = newRoot.withColor(false);
        return new PathCopyingPersistentMaxTreeMap<K, V>(newRoot);
    }

    public PathCopyingPersistentMaxTreeMap<K, V> putAndCopy(K key, K pMax, V value) {
        return this.mapFromTree(PathCopyingPersistentMaxTreeMap.putAndCopy0((Comparable)Preconditions.checkNotNull(key), (Comparable)Preconditions.checkNotNull(pMax), value, this.root));
    }

    private static <K extends Comparable<K>, V> Node<K, V> putAndCopy0(K key, K pSecondaryKey, V value, @Var Node<K, V> current) {
        if (current == null) {
            return new Node<K, V>(key, pSecondaryKey, value);
        }
        int comp = key.compareTo((Comparable)((Comparable)current.getKey()));
        if (comp < 0) {
            Node<K, V> newLeft = PathCopyingPersistentMaxTreeMap.putAndCopy0(key, pSecondaryKey, value, current.left);
            current = current.withLeftChild(newLeft);
        } else if (comp > 0) {
            Node<K, V> newRight = PathCopyingPersistentMaxTreeMap.putAndCopy0(key, pSecondaryKey, value, current.right);
            current = current.withRightChild(newRight);
        } else {
            Object max = PathCopyingPersistentMaxTreeMap.getMaxSecondaryKey(current.left, current.right, pSecondaryKey);
            current = new Node<K, V>(key, pSecondaryKey, max, value, current.left, current.right, current.getColor());
        }
        return PathCopyingPersistentMaxTreeMap.restoreInvariants(current);
    }

    private static <K extends Comparable<K>, V> K getMaxSecondaryKey(Node<K, V> node1, Node<K, V> node2, Node<K, V> node3) {
        Optional<K> temp = PathCopyingPersistentMaxTreeMap.getMaxSecondaryKey(node1, node2);
        if (temp.isPresent() && ((Comparable)temp.orElseThrow()).compareTo(node3.getMax()) >= 0) {
            return (K)((Comparable)temp.orElseThrow());
        }
        return node3.getMax();
    }

    private static <K extends Comparable<K>, V> K getMaxSecondaryKey(Node<K, V> node1, Node<K, V> node2, K max3) {
        Optional<K> temp = PathCopyingPersistentMaxTreeMap.getMaxSecondaryKey(node1, node2);
        if (temp.isPresent() && ((Comparable)temp.orElseThrow()).compareTo(max3) >= 0) {
            return (K)((Comparable)temp.orElseThrow());
        }
        return max3;
    }

    private static <K extends Comparable<K>, V> Optional<K> getMaxSecondaryKey(Node<K, V> node1, Node<K, V> node2) {
        if (node1 == null && node2 == null) {
            return Optional.empty();
        }
        if (node1 == null) {
            return Optional.of(node2.getMax());
        }
        if (node1.getMax().compareTo(node2.getMax()) >= 0) {
            return Optional.of(node1.getMax());
        }
        return Optional.of(node2.getMax());
    }

    public PathCopyingPersistentMaxTreeMap<K, V> removeAndCopy(K key) {
        if (this.isEmpty()) {
            return this;
        }
        return this.mapFromTree(PathCopyingPersistentMaxTreeMap.removeAndCopy0((Comparable)Preconditions.checkNotNull(key), this.root));
    }

    private static <K extends Comparable<K>, V> @Nullable Node<K, V> removeAndCopy0(K key, @Var Node<K, V> current) {
        int comp = key.compareTo((Comparable)((Comparable)current.getKey()));
        if (comp < 0) {
            if (current.left == null) {
                return current;
            }
            if (!Node.isRed(current.left) && !Node.isRed(current.left.left)) {
                current = PathCopyingPersistentMaxTreeMap.makeLeftRed(current);
            }
            Node newLeft = PathCopyingPersistentMaxTreeMap.removeAndCopy0(key, current.left);
            current = current.withLeftChild(newLeft);
        } else {
            if (comp > 0 && current.right == null) {
                return current;
            }
            if (Node.isRed(current.left)) {
                current = PathCopyingPersistentMaxTreeMap.rotateClockwise(current);
                comp = key.compareTo((Comparable)((Comparable)current.getKey()));
                assert (comp >= 0);
            }
            if (comp == 0 && current.right == null) {
                assert (current.left == null);
                return null;
            }
            if (!Node.isRed(current.right) && !Node.isRed(current.right.left)) {
                current = PathCopyingPersistentMaxTreeMap.makeRightRed(current);
                comp = key.compareTo((Comparable)((Comparable)current.getKey()));
                assert (comp >= 0);
            }
            if (comp == 0) {
                Node successor = current.right;
                while (successor.left != null) {
                    successor = successor.left;
                }
                Node newRight = PathCopyingPersistentMaxTreeMap.removeMininumNodeInTree(current.right);
                Object newMax = successor.getMax();
                if (successor.getMax().compareTo(current.left.getMax()) < 0) {
                    newMax = current.left.getMax();
                }
                current = new Node((Comparable)successor.getKey(), (Comparable)successor.getSecondaryKey(), (Comparable)newMax, successor.getValue(), current.left, newRight, current.getColor());
            } else {
                Node newRight = PathCopyingPersistentMaxTreeMap.removeAndCopy0(key, current.right);
                current = current.withRightChild(newRight);
            }
        }
        return PathCopyingPersistentMaxTreeMap.restoreInvariants(current);
    }

    private static <K extends Comparable<K>, V> @Nullable Node<K, V> removeMininumNodeInTree(@Var Node<K, V> current) {
        if (current.left == null) {
            return null;
        }
        if (!Node.isRed(current.left) && !Node.isRed(current.left.left)) {
            current = PathCopyingPersistentMaxTreeMap.makeLeftRed(current);
        }
        Node newLeft = PathCopyingPersistentMaxTreeMap.removeMininumNodeInTree(current.left);
        current = current.withLeftChild(newLeft);
        return PathCopyingPersistentMaxTreeMap.restoreInvariants(current);
    }

    private static <K extends Comparable<K>, V> Node<K, V> restoreInvariants(@Var Node<K, V> current) {
        if (Node.isRed(current.right)) {
            current = PathCopyingPersistentMaxTreeMap.rotateCounterclockwise(current);
        }
        if (Node.isRed(current.left) && Node.isRed(current.left.left)) {
            current = PathCopyingPersistentMaxTreeMap.rotateClockwise(current);
        }
        if (Node.isRed(current.left) && Node.isRed(current.right)) {
            current = PathCopyingPersistentMaxTreeMap.colorFlip(current);
        }
        return current;
    }

    private static <K extends Comparable<K>, V> Node<K, V> colorFlip(Node<K, V> current) {
        Node newLeft = current.left.withColor(!current.left.getColor());
        Node newRight = current.right.withColor(!current.right.getColor());
        return new Node((Comparable)current.getKey(), (Comparable)current.getSecondaryKey(), (Comparable)current.getMax(), current.getValue(), newLeft, newRight, !current.getColor());
    }

    private static <K extends Comparable<K>, V> Node<K, V> rotateCounterclockwise(Node<K, V> current) {
        Node crossoverNode = current.right.left;
        K oldMaxTop = current.getMax();
        K newMaxnewLeft = current.getMax();
        if (current.left != null && newMaxnewLeft.compareTo(current.left.getMax()) < 0) {
            newMaxnewLeft = current.left.getMax();
        }
        if (crossoverNode != null && newMaxnewLeft.compareTo(crossoverNode.getMax()) < 0) {
            newMaxnewLeft = crossoverNode.getMax();
        }
        Node newLeft = new Node((Comparable)current.getKey(), (Comparable)current.getSecondaryKey(), (Comparable)newMaxnewLeft, current.getValue(), current.left, crossoverNode, true);
        return new Node((Comparable)current.right.getKey(), (Comparable)current.right.getSecondaryKey(), (Comparable)oldMaxTop, current.right.getValue(), newLeft, current.right.right, current.getColor());
    }

    private static <K extends Comparable<K>, V> Node<K, V> rotateClockwise(Node<K, V> current) {
        Node crossOverNode = current.left.right;
        K oldMaxTop = current.getMax();
        K newMaxnewRight = current.getMax();
        if (current.right != null && newMaxnewRight.compareTo(current.right.getMax()) < 0) {
            newMaxnewRight = current.left.getMax();
        }
        if (crossOverNode != null && newMaxnewRight.compareTo(crossOverNode.getMax()) < 0) {
            newMaxnewRight = crossOverNode.getMax();
        }
        Node newRight = new Node((Comparable)current.getKey(), (Comparable)current.getSecondaryKey(), (Comparable)newMaxnewRight, current.getValue(), crossOverNode, current.right, true);
        return new Node((Comparable)current.left.getKey(), (Comparable)current.left.getSecondaryKey(), (Comparable)oldMaxTop, current.left.getValue(), current.left.left, newRight, current.getColor());
    }

    private static <K extends Comparable<K>, V> Node<K, V> makeLeftRed(@Var Node<K, V> current) {
        current = PathCopyingPersistentMaxTreeMap.colorFlip(current);
        if (Node.isRed(current.right.left)) {
            Node newRight = PathCopyingPersistentMaxTreeMap.rotateClockwise(current.right);
            current = new Node((Comparable)current.getKey(), (Comparable)current.getSecondaryKey(), (Comparable)current.getMax(), current.getValue(), current.left, newRight, current.getColor());
            current = PathCopyingPersistentMaxTreeMap.rotateCounterclockwise(current);
            current = PathCopyingPersistentMaxTreeMap.colorFlip(current);
        }
        return current;
    }

    private static <K extends Comparable<K>, V> Node<K, V> makeRightRed(@Var Node<K, V> current) {
        current = PathCopyingPersistentMaxTreeMap.colorFlip(current);
        if (Node.isRed(current.left.left)) {
            current = PathCopyingPersistentMaxTreeMap.rotateClockwise(current);
            current = PathCopyingPersistentMaxTreeMap.colorFlip(current);
        }
        return current;
    }

    public boolean equals(@Nullable Object pObj) {
        if (pObj instanceof PathCopyingPersistentMaxTreeMap && ((PathCopyingPersistentMaxTreeMap)pObj).root == this.root) {
            return true;
        }
        return super.equals(pObj);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public  @Nullable Map.Entry<K, V> getEntry(K pKey) {
        return PathCopyingPersistentMaxTreeMap.findNode(pKey, this.root);
    }

    public Iterator<Map.Entry<K, V>> entryIterator() {
        return EntryInOrderIterator.create(this.root);
    }

    public Set<V> getValuesSet() {
        Iterable iterable = () -> this.entryIterator();
        return (Set)Streams.stream(iterable).map(n -> n.getValue()).collect(ImmutableSet.toImmutableSet());
    }

    public Iterator<Map.Entry<K, V>> descendingEntryIterator() {
        return DescendingEntryInOrderIterator.create(this.root);
    }

    public PathCopyingPersistentMaxTreeMap<K, V> empty() {
        return PathCopyingPersistentMaxTreeMap.of();
    }

    public boolean containsKey(K pObj) {
        return PathCopyingPersistentMaxTreeMap.findNode(pObj, this.root) != null;
    }

    public boolean contains(K key, V value) {
        @Nullable Node<K, V> node = PathCopyingPersistentMaxTreeMap.findNode(key, this.root);
        return node != null && node.getValue() == value;
    }

    public V get(K pObj) {
        Node<K, V> node = PathCopyingPersistentMaxTreeMap.findNode(pObj, this.root);
        return node == null ? null : (V)node.getValue();
    }

    public ImmutableSet<V> filterByOverlappingZeroEdges(K largerEqualsKey, K lessEqualsMax) {
        ImmutableSet.Builder setBuilder = ImmutableSet.builder();
        this.filterByThingy1(largerEqualsKey, lessEqualsMax, SMGValue.zeroValue(), this.root, setBuilder);
        return setBuilder.build();
    }

    private void filterByThingy1(K offSetPlusSize, K offset, Object valueEqualityConstraint, Node<K, V> node, ImmutableSet.Builder<V> builder) {
        if (node == null) {
            return;
        }
        int compare = ((Comparable)node.getKey()).compareTo(offSetPlusSize);
        if (compare < 0) {
            if (node.getMax().compareTo(offset) > 0) {
                if (((SMGHasValueEdge)node.getValue()).hasValue().equals(valueEqualityConstraint) && node.getSecondaryKey().compareTo(offset) > 0) {
                    builder.add(node.getValue());
                }
                this.filterByThingy1(offSetPlusSize, offset, valueEqualityConstraint, node.left, builder);
                this.filterByThingy1(offSetPlusSize, offset, valueEqualityConstraint, node.right, builder);
            }
        } else if (compare > 0 && node.getMax().compareTo(offset) > 0) {
            this.filterByThingy1(offSetPlusSize, offset, valueEqualityConstraint, node.left, builder);
        } else if (node.getMax().compareTo(offset) > 0) {
            if (((SMGHasValueEdge)node.getValue()).hasValue().equals(valueEqualityConstraint) && node.getSecondaryKey().compareTo(offset) > 0) {
                builder.add(node.getValue());
            }
            this.filterByThingy1(offSetPlusSize, offset, valueEqualityConstraint, node.left, builder);
        }
    }

    public ImmutableSet<V> filterByOverlappingNonZeroEdges(K largerEqualsKey, K lessEqualsMax) {
        ImmutableSet.Builder setBuilder = ImmutableSet.builder();
        this.filterByThingy2(largerEqualsKey, lessEqualsMax, this.root, setBuilder);
        return setBuilder.build();
    }

    private void filterByThingy2(K offSetPlusSize, K offset, Node<K, V> node, ImmutableSet.Builder<V> builder) {
        if (node == null) {
            return;
        }
        int compare = ((Comparable)node.getKey()).compareTo(offSetPlusSize);
        if (compare < 0) {
            if (node.getMax().compareTo(offset) > 0) {
                if (((SMGHasValueEdge)node.getValue()).hasValue() != SMGValue.zeroValue() && node.getSecondaryKey().compareTo(offset) > 0) {
                    builder.add(this.root.getValue());
                }
                this.filterByThingy2(offSetPlusSize, offset, node.left, builder);
                this.filterByThingy2(offSetPlusSize, offset, node.right, builder);
            }
        } else if (compare > 0 && node.getMax().compareTo(offset) > 0) {
            this.filterByThingy2(offSetPlusSize, offset, node.left, builder);
        } else if (node.getMax().compareTo(offset) > 0) {
            if (((SMGHasValueEdge)node.getValue()).hasValue() != SMGValue.zeroValue() && node.getSecondaryKey().compareTo(offset) > 0) {
                builder.add(this.root.getValue());
            }
            this.filterByThingy2(offSetPlusSize, offset, node.left, builder);
        }
    }

    public void deleteOverlappingNonZeroEdges(K largerEqualsKey, K lessEqualsMax, Object valueEqualityConstraint) {
    }

    public PersistentSortedMap<K, V> filterToSortedMap(K largerEqualsKey, K lessEqualsMax, Object valueEqualityConstraint) {
        PersistentSortedMap<K, V> map = PathCopyingPersistentTreeMap.of();
        map = this.filterToSortedMap0(largerEqualsKey, lessEqualsMax, valueEqualityConstraint, this.root, map);
        return map;
    }

    private PersistentSortedMap<K, V> filterToSortedMap0(K offSetPlusSize, K offset, Object valueEqualityConstraint, Node<K, V> node, PersistentSortedMap<K, V> map) {
        if (node == null) {
            return map;
        }
        int compare = ((Comparable)node.getKey()).compareTo(offSetPlusSize);
        if (compare < 0) {
            if (node.getMax().compareTo(offset) > 0) {
                if (((SMGHasValueEdge)node.getValue()).hasValue() == valueEqualityConstraint && node.getSecondaryKey().compareTo(offset) > 0) {
                    map = map.putAndCopy((Object)((Comparable)node.getKey()), node.getValue());
                }
                map = this.filterToSortedMap0(offSetPlusSize, offset, valueEqualityConstraint, node.left, map);
                return this.filterToSortedMap0(offSetPlusSize, offset, valueEqualityConstraint, node.right, map);
            }
        } else {
            if (compare > 0 && node.getMax().compareTo(offset) > 0) {
                return this.filterToSortedMap0(offSetPlusSize, offset, valueEqualityConstraint, node.left, map);
            }
            if (node.getMax().compareTo(offset) > 0) {
                if (node.getValue() == valueEqualityConstraint && node.getSecondaryKey().compareTo(offset) > 0) {
                    map = map.putAndCopy((Object)((Comparable)node.getKey()), node.getValue());
                }
                return this.filterToSortedMap0(offSetPlusSize, offset, valueEqualityConstraint, node.left, map);
            }
        }
        return map;
    }

    public V getOrDefault(K pKey, V pDefaultValue) {
        Node<K, V> node = PathCopyingPersistentMaxTreeMap.findNode(pKey, this.root);
        return node == null ? pDefaultValue : node.getValue();
    }

    public boolean isEmpty() {
        return this.root == null;
    }

    public int size() {
        if (this.size <= 0) {
            this.size = Node.countNodes(this.root);
        }
        return this.size;
    }

    public  @Nullable Map.Entry<K, V> firstEntry() {
        if (this.isEmpty()) {
            return null;
        }
        return PathCopyingPersistentMaxTreeMap.findSmallestNode(this.root);
    }

    public  @Nullable Map.Entry<K, V> lastEntry() {
        if (this.isEmpty()) {
            return null;
        }
        return PathCopyingPersistentMaxTreeMap.findLargestNode(this.root);
    }

    public Map.Entry<K, V> ceilingEntry(K pKey) {
        return PathCopyingPersistentMaxTreeMap.findNextGreaterNode(pKey, this.root, true);
    }

    public Map.Entry<K, V> floorEntry(K pKey) {
        return PathCopyingPersistentMaxTreeMap.findNextSmallerNode(pKey, this.root, true);
    }

    public Map.Entry<K, V> higherEntry(K pKey) {
        return PathCopyingPersistentMaxTreeMap.findNextGreaterNode(pKey, this.root, false);
    }

    public Map.Entry<K, V> lowerEntry(K pKey) {
        return PathCopyingPersistentMaxTreeMap.findNextSmallerNode(pKey, this.root, false);
    }

    public Comparator<? super K> comparator() {
        return null;
    }

    public OurSortedMap<K, V> subMap(K pFromKey, boolean pFromInclusive, K pToKey, boolean pToInclusive) {
        Preconditions.checkNotNull(pFromKey);
        Preconditions.checkNotNull(pToKey);
        return PartialSortedMap.create(this.root, pFromKey, pFromInclusive, pToKey, pToInclusive);
    }

    public OurSortedMap<K, V> headMap(K pToKey, boolean pToInclusive) {
        Preconditions.checkNotNull(pToKey);
        return PartialSortedMap.create(this.root, null, true, pToKey, pToInclusive);
    }

    public OurSortedMap<K, V> tailMap(K pFromKey, boolean pFromInclusive) {
        Preconditions.checkNotNull(pFromKey);
        return PartialSortedMap.create(this.root, pFromKey, pFromInclusive, null, false);
    }

    public String toString() {
        return this.toString(this.root);
    }

    private String toString(Node<K, V> pCurrent) {
        if (pCurrent == null) {
            return "";
        }
        String thisNode = "(max: " + pCurrent.getMax() + "; Value: " + pCurrent.getValue() + ")";
        return this.toString(pCurrent.left) + thisNode + this.toString(pCurrent.right);
    }

    String printer(Node<?, ?> pCurrent) {
        if (pCurrent == null) {
            return "";
        }
        String thisNode = "(max: " + pCurrent.getMax() + "; Value: " + pCurrent.getValue() + ")";
        return this.printer(pCurrent.left) + thisNode + this.printer(pCurrent.right);
    }

    @Immutable(containerOf={"K", "V"})
    private static final class PartialSortedMap<K extends Comparable<K>, V>
    extends AbstractImmutableSortedMap<K, V>
    implements OurSortedMap<K, V>,
    Serializable {
        private static final long serialVersionUID = 5354023186935889223L;
        private final Node<K, V> root;
        private final @Nullable K fromKey;
        private final boolean fromInclusive;
        private final @Nullable K toKey;
        private final boolean toInclusive;
        @LazyInit
        private transient int size;
        @LazyInit
        private transient @Nullable NavigableSet<Map.Entry<K, V>> entrySet;

        static <K extends Comparable<K>, V> OurSortedMap<K, V> create(Node<K, V> pRoot, @Nullable K pFromKey, boolean pFromInclusive, @Nullable K pToKey, boolean pToInclusive) {
            Node<K, V> root;
            Preconditions.checkArgument((pFromKey != null || pToKey != null ? 1 : 0) != 0);
            if (pFromKey != null && pToKey != null) {
                int comp = pFromKey.compareTo(pToKey);
                if (!(comp != 0 || pFromInclusive && pToInclusive)) {
                    return OurSortedMap.EmptyImmutableOurSortedMap.of();
                }
                Preconditions.checkArgument((comp <= 0 ? 1 : 0) != 0, (Object)"fromKey > toKey");
            }
            if ((root = PartialSortedMap.findBestRoot(pRoot, pFromKey, pFromInclusive, pToKey, pToInclusive)) == null) {
                return OurSortedMap.EmptyImmutableOurSortedMap.of();
            }
            Node<K, V> lowestNode = null;
            if (pFromKey != null && (lowestNode = PathCopyingPersistentMaxTreeMap.findNextGreaterNode(pFromKey, root, pFromInclusive)) == null) {
                return OurSortedMap.EmptyImmutableOurSortedMap.of();
            }
            Node<K, V> highestNode = null;
            if (pToKey != null && (highestNode = PathCopyingPersistentMaxTreeMap.findNextSmallerNode(pToKey, root, pToInclusive)) == null) {
                return OurSortedMap.EmptyImmutableOurSortedMap.of();
            }
            if (pFromKey != null && pToKey != null) {
                assert (lowestNode != null && highestNode != null);
                if (PathCopyingPersistentMaxTreeMap.exceedsUpperBound((Comparable)lowestNode.getKey(), pToKey, pToInclusive)) {
                    Verify.verify((boolean)PathCopyingPersistentMaxTreeMap.exceedsLowerBound((Comparable)highestNode.getKey(), pFromKey, pFromInclusive));
                    return OurSortedMap.EmptyImmutableOurSortedMap.of();
                }
            }
            return new PartialSortedMap<K, V>(root, pFromKey, pFromInclusive, pToKey, pToInclusive);
        }

        private static <K extends Comparable<K>, V> @Nullable Node<K, V> findBestRoot(@Nullable Node<K, V> pRoot, @Nullable K pFromKey, boolean pFromInclusive, @Nullable K pToKey, boolean pToInclusive) {
            Node<K, V> current = pRoot;
            while (current != null) {
                if (pFromKey != null && PathCopyingPersistentMaxTreeMap.exceedsLowerBound((Comparable)current.getKey(), pFromKey, pFromInclusive)) {
                    current = current.right;
                    continue;
                }
                if (pToKey != null && PathCopyingPersistentMaxTreeMap.exceedsUpperBound((Comparable)current.getKey(), pToKey, pToInclusive)) {
                    current = current.left;
                    continue;
                }
                return current;
            }
            return null;
        }

        private PartialSortedMap(Node<K, V> pRoot, @Nullable K pFromKey, boolean pFromInclusive, @Nullable K pToKey, boolean pToInclusive) {
            this.root = pRoot;
            this.fromKey = pFromKey;
            this.fromInclusive = pFromInclusive;
            this.toKey = pToKey;
            this.toInclusive = pToInclusive;
            assert (this.root != null);
            assert (pFromKey == null || this.containsKey(PathCopyingPersistentMaxTreeMap.findNextGreaterNode(pFromKey, pRoot, this.fromInclusive).getKey()));
            assert (pToKey == null || this.containsKey(PathCopyingPersistentMaxTreeMap.findNextSmallerNode(pToKey, pRoot, this.toInclusive).getKey()));
        }

        private boolean inRange(K key, boolean treatBoundsAsInclusive) {
            return !this.tooLow(key, treatBoundsAsInclusive) && !this.tooHigh(key, treatBoundsAsInclusive);
        }

        private boolean tooLow(K key, boolean treatBoundAsInclusive) {
            return this.fromKey != null && PathCopyingPersistentMaxTreeMap.exceedsLowerBound(key, this.fromKey, treatBoundAsInclusive || this.fromInclusive);
        }

        private boolean tooHigh(K key, boolean treatBoundAsInclusive) {
            return this.toKey != null && PathCopyingPersistentMaxTreeMap.exceedsUpperBound(key, this.toKey, treatBoundAsInclusive || this.toInclusive);
        }

        @Override
        public Iterator<Map.Entry<K, V>> entryIterator() {
            return EntryInOrderIterator.createWithBounds(this.root, this.fromKey, this.fromInclusive, this.toKey, this.toInclusive);
        }

        @Override
        public Iterator<Map.Entry<K, V>> descendingEntryIterator() {
            return DescendingEntryInOrderIterator.createWithBounds(this.root, this.fromKey, this.fromInclusive, this.toKey, this.toInclusive);
        }

        @Override
        public boolean equals(@Nullable Object pObj) {
            if (pObj instanceof PartialSortedMap) {
                PartialSortedMap other = (PartialSortedMap)pObj;
                if (this.root == other.root && Objects.equals(this.fromKey, other.fromKey) && this.fromInclusive == other.fromInclusive && Objects.equals(this.toKey, other.toKey) && this.toInclusive == other.toInclusive) {
                    return true;
                }
            }
            return super.equals(pObj);
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }

        @Override
        public boolean containsKey(Object pKey) {
            Comparable key = (Comparable)Preconditions.checkNotNull((Object)pKey);
            return this.inRange(key, false) && PathCopyingPersistentMaxTreeMap.findNode(key, this.root) != null;
        }

        @Override
        public @Nullable Node<K, V> getEntry(Object pKey) {
            Comparable key = (Comparable)Preconditions.checkNotNull((Object)pKey);
            if (!this.inRange(key, false)) {
                return null;
            }
            Node<Comparable, V> node = PathCopyingPersistentMaxTreeMap.findNode(key, this.root);
            return node;
        }

        @Override
        public V get(Object pKey) {
            Map.Entry node = this.getEntry(pKey);
            return node == null ? null : (V)((AbstractMap.SimpleImmutableEntry)node).getValue();
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public int size() {
            if (this.size == 0) {
                this.size = Iterators.size(this.entryIterator());
            }
            return this.size;
        }

        @Override
        public Map.Entry<K, V> firstEntry() {
            if (this.fromKey == null) {
                return PathCopyingPersistentMaxTreeMap.findSmallestNode(this.root);
            }
            return PathCopyingPersistentMaxTreeMap.findNextGreaterNode(this.fromKey, this.root, this.fromInclusive);
        }

        @Override
        public Map.Entry<K, V> lastEntry() {
            if (this.toKey == null) {
                return PathCopyingPersistentMaxTreeMap.findLargestNode(this.root);
            }
            return PathCopyingPersistentMaxTreeMap.findNextSmallerNode(this.toKey, this.root, this.toInclusive);
        }

        @Override
        public  @Nullable Map.Entry<K, V> ceilingEntry(K pKey) {
            Node<K, V> result = PathCopyingPersistentMaxTreeMap.findNextGreaterNode(pKey, this.root, true);
            if (result != null && !this.inRange((Comparable)result.getKey(), false)) {
                return null;
            }
            return result;
        }

        @Override
        public  @Nullable Map.Entry<K, V> floorEntry(K pKey) {
            Node<K, V> result = PathCopyingPersistentMaxTreeMap.findNextSmallerNode(pKey, this.root, true);
            if (result != null && !this.inRange((Comparable)result.getKey(), false)) {
                return null;
            }
            return result;
        }

        @Override
        public  @Nullable Map.Entry<K, V> higherEntry(K pKey) {
            Node<K, V> result = PathCopyingPersistentMaxTreeMap.findNextGreaterNode(pKey, this.root, false);
            if (result != null && !this.inRange((Comparable)result.getKey(), false)) {
                return null;
            }
            return result;
        }

        @Override
        public  @Nullable Map.Entry<K, V> lowerEntry(K pKey) {
            Node<K, V> result = PathCopyingPersistentMaxTreeMap.findNextSmallerNode(pKey, this.root, false);
            if (result != null && !this.inRange((Comparable)result.getKey(), false)) {
                return null;
            }
            return result;
        }

        @Override
        public Comparator<? super K> comparator() {
            return null;
        }

        @Override
        public OurSortedMap<K, V> descendingMap() {
            return new DescendingSortedMap(this);
        }

        @Override
        public NavigableSet<Map.Entry<K, V>> entrySet() {
            if (this.entrySet == null) {
                this.entrySet = new SortedMapEntrySet(this);
            }
            return this.entrySet;
        }

        @Override
        public OurSortedMap<K, V> subMap(K pFromKey, boolean pFromInclusive, K pToKey, boolean pToInclusive) {
            Preconditions.checkNotNull(pFromKey);
            Preconditions.checkNotNull(pToKey);
            Preconditions.checkArgument((boolean)this.inRange(pFromKey, !pFromInclusive));
            Preconditions.checkArgument((boolean)this.inRange(pToKey, !pToInclusive));
            return PartialSortedMap.create(this.root, pFromKey, pFromInclusive, pToKey, pToInclusive);
        }

        @Override
        public OurSortedMap<K, V> headMap(K pToKey, boolean pInclusive) {
            Preconditions.checkNotNull(pToKey);
            Preconditions.checkArgument((boolean)this.inRange(pToKey, !pInclusive));
            return PartialSortedMap.create(this.root, this.fromKey, this.fromInclusive, pToKey, pInclusive);
        }

        @Override
        public OurSortedMap<K, V> tailMap(K pFromKey, boolean pInclusive) {
            Preconditions.checkNotNull(pFromKey);
            Preconditions.checkArgument((boolean)this.inRange(pFromKey, !pInclusive));
            return PartialSortedMap.create(this.root, pFromKey, pInclusive, this.toKey, this.toInclusive);
        }
    }

    private static class DescendingEntryInOrderIterator<K extends Comparable<K>, V>
    extends UnmodifiableIterator<Map.Entry<K, V>> {
        private final Deque<Node<K, V>> stack = new ArrayDeque<Node<K, V>>();
        private final @Nullable K lowKey;
        private final boolean lowInclusive;

        static <K extends Comparable<K>, V> Iterator<Map.Entry<K, V>> create(@Nullable Node<K, V> root) {
            if (root == null) {
                return Collections.emptyIterator();
            }
            return new DescendingEntryInOrderIterator<Object, V>(root, null, false, null, false);
        }

        static <K extends Comparable<K>, V> Iterator<Map.Entry<K, V>> createWithBounds(@Nullable Node<K, V> root, @Nullable K pFromKey, boolean pFromInclusive, @Nullable K pToKey, boolean pToInclusive) {
            if (root == null) {
                return Collections.emptyIterator();
            }
            return new DescendingEntryInOrderIterator<K, V>(root, pFromKey, pFromInclusive, pToKey, pToInclusive);
        }

        private DescendingEntryInOrderIterator(Node<K, V> root, @Nullable K pLowKey, boolean pLowInclusive, @Nullable K pHighKey, boolean pHighInclusive) {
            this.lowKey = pLowKey;
            this.lowInclusive = pLowInclusive;
            if (pHighKey == null) {
                this.pushRightMostNodesOnStack(root);
            } else {
                this.pushNodesToKeyOnStack(root, (Comparable)PathCopyingPersistentMaxTreeMap.findNextSmallerNode(pHighKey, root, pHighInclusive).getKey());
            }
            this.stopFurtherIterationIfOutOfRange();
        }

        public boolean hasNext() {
            return !this.stack.isEmpty();
        }

        private void pushRightMostNodesOnStack(@Var Node<K, V> current) {
            while (current.right != null) {
                this.stack.push(current);
                current = current.right;
            }
            this.stack.push(current);
        }

        private void pushNodesToKeyOnStack(@Var Node<K, V> current, K key) {
            while (current != null) {
                int comp = key.compareTo((Comparable)((Comparable)current.getKey()));
                if (comp > 0) {
                    this.stack.push(current);
                    current = current.right;
                    continue;
                }
                if (comp < 0) {
                    current = current.left;
                    continue;
                }
                this.stack.push(current);
                return;
            }
            throw new AssertionError((Object)"PartialEntryInOrderIterator created with upper bound that is not in map");
        }

        private void stopFurtherIterationIfOutOfRange() {
            if (this.lowKey != null && !this.stack.isEmpty() && PathCopyingPersistentMaxTreeMap.exceedsLowerBound((Comparable)this.stack.peek().getKey(), this.lowKey, this.lowInclusive)) {
                this.stack.clear();
            }
        }

        public Map.Entry<K, V> next() {
            Node<K, V> current = this.stack.pop();
            if (current.left != null) {
                this.pushRightMostNodesOnStack(current.left);
            }
            this.stopFurtherIterationIfOutOfRange();
            return current;
        }
    }

    private static class EntryInOrderIterator<K extends Comparable<K>, V>
    extends UnmodifiableIterator<Map.Entry<K, V>> {
        private final Deque<Node<K, V>> stack = new ArrayDeque<Node<K, V>>();
        private final @Nullable K highKey;
        private final boolean highInclusive;

        static <K extends Comparable<K>, V> Iterator<Map.Entry<K, V>> create(@Nullable Node<K, V> root) {
            if (root == null) {
                return Collections.emptyIterator();
            }
            return new EntryInOrderIterator<Object, V>(root, null, false, null, false);
        }

        static <K extends Comparable<K>, V> Iterator<Map.Entry<K, V>> createWithBounds(@Nullable Node<K, V> root, @Nullable K pFromKey, boolean pFromInclusive, @Nullable K pToKey, boolean pToInclusive) {
            if (root == null) {
                return Collections.emptyIterator();
            }
            return new EntryInOrderIterator<K, V>(root, pFromKey, pFromInclusive, pToKey, pToInclusive);
        }

        private EntryInOrderIterator(Node<K, V> root, @Nullable K pLowKey, boolean pLowInclusive, @Nullable K pHighKey, boolean pHighInclusive) {
            this.highKey = pHighKey;
            this.highInclusive = pHighInclusive;
            if (pLowKey == null) {
                this.pushLeftMostNodesOnStack(root);
            } else {
                this.pushNodesToKeyOnStack(root, (Comparable)PathCopyingPersistentMaxTreeMap.findNextGreaterNode(pLowKey, root, pLowInclusive).getKey());
            }
            this.stopFurtherIterationIfOutOfRange();
        }

        public boolean hasNext() {
            return !this.stack.isEmpty();
        }

        private void pushLeftMostNodesOnStack(@Var Node<K, V> current) {
            while (current.left != null) {
                this.stack.push(current);
                current = current.left;
            }
            this.stack.push(current);
        }

        private void pushNodesToKeyOnStack(@Var Node<K, V> current, K key) {
            while (current != null) {
                int comp = key.compareTo((Comparable)((Comparable)current.getKey()));
                if (comp < 0) {
                    this.stack.push(current);
                    current = current.left;
                    continue;
                }
                if (comp > 0) {
                    current = current.right;
                    continue;
                }
                this.stack.push(current);
                return;
            }
            throw new AssertionError((Object)"PartialEntryInOrderIterator created with lower bound that is not in map");
        }

        private void stopFurtherIterationIfOutOfRange() {
            if (this.highKey != null && !this.stack.isEmpty() && PathCopyingPersistentMaxTreeMap.exceedsUpperBound((Comparable)this.stack.peek().getKey(), this.highKey, this.highInclusive)) {
                this.stack.clear();
            }
        }

        public Map.Entry<K, V> next() {
            Node<K, V> current = this.stack.pop();
            if (current.right != null) {
                this.pushLeftMostNodesOnStack(current.right);
            }
            this.stopFurtherIterationIfOutOfRange();
            return current;
        }
    }

    @Immutable(containerOf={"K", "V"})
    @SuppressFBWarnings(value={"EQ_DOESNT_OVERRIDE_EQUALS"}, justification="Inherits equals() according to specification.")
    private static final class Node<K extends Comparable<K>, V>
    extends AbstractMap.SimpleImmutableEntry<K, V> {
        private final K max;
        private final K secondaryKey;
        private static final boolean RED = true;
        private static final boolean BLACK = false;
        private static final long serialVersionUID = -7393505826652634501L;
        private final @Nullable Node<K, V> left;
        private final @Nullable Node<K, V> right;
        private final boolean isRed;

        Node(K pKey, K pSecondaryKey, V pValue) {
            super(pKey, pValue);
            this.max = pSecondaryKey;
            this.secondaryKey = pSecondaryKey;
            this.left = null;
            this.right = null;
            this.isRed = true;
        }

        Node(K pKey, K pSecondaryKey, K pMax, V pValue, Node<K, V> pLeft, Node<K, V> pRight, boolean pRed) {
            super(pKey, pValue);
            this.secondaryKey = pSecondaryKey;
            this.max = pMax;
            this.left = pLeft;
            this.right = pRight;
            this.isRed = pRed;
        }

        boolean isLeaf() {
            return this.left == null && this.right == null;
        }

        boolean getColor() {
            return this.isRed;
        }

        static <K extends Comparable<K>, V> boolean isRed(@Nullable Node<K, V> n) {
            return n != null && n.isRed;
        }

        static <K extends Comparable<K>, V> boolean isBlack(@Nullable Node<K, V> n) {
            return n != null && !n.isRed;
        }

        K getMax() {
            return this.max;
        }

        K getSecondaryKey() {
            return this.secondaryKey;
        }

        Node<K, V> withColor(boolean color) {
            if (this.isRed == color) {
                return this;
            }
            return new Node((Comparable)this.getKey(), (Comparable)this.getSecondaryKey(), (Comparable)this.getMax(), this.getValue(), this.left, this.right, color);
        }

        Node<K, V> withLeftChild(Node<K, V> newLeft) {
            if (newLeft == this.left) {
                return this;
            }
            K newMax = this.getMax();
            if (newLeft != null && newLeft.getMax().compareTo(newMax) > 0) {
                newMax = newLeft.getMax();
            }
            return new Node((Comparable)this.getKey(), (Comparable)this.getSecondaryKey(), (Comparable)newMax, this.getValue(), newLeft, this.right, this.isRed);
        }

        Node<K, V> withRightChild(Node<K, V> newRight) {
            if (newRight == this.right) {
                return this;
            }
            K newMax = this.getMax();
            if (newRight != null && newRight.getMax().compareTo(newMax) > 0) {
                newMax = newRight.getMax();
            }
            return new Node((Comparable)this.getKey(), (Comparable)this.getSecondaryKey(), (Comparable)newMax, this.getValue(), this.left, newRight, this.isRed);
        }

        static <K extends Comparable<K>, V> int countNodes(@Nullable Node<K, V> n) {
            if (n == null) {
                return 0;
            }
            return Node.countNodes(n.left) + 1 + Node.countNodes(n.right);
        }
    }
}

