/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.smg.util;

import com.google.common.base.Equivalence;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.cpachecker.util.smg.util.Collections3;
import org.sosy_lab.cpachecker.util.smg.util.OurSortedMap;

final class SortedMapEntrySet<K, V>
extends AbstractSet<Map.Entry<K, V>>
implements NavigableSet<Map.Entry<K, V>>,
Serializable {
    private static final long serialVersionUID = 2891466632825409479L;
    private final OurSortedMap<K, V> map;

    SortedMapEntrySet(OurSortedMap<K, V> pMap) {
        this.map = (OurSortedMap)Preconditions.checkNotNull(pMap);
    }

    @Override
    public boolean equals(@Nullable Object pO) {
        if (pO instanceof SortedMapEntrySet && Collections3.guaranteedSameOrder(this.map.comparator(), ((SortedMapEntrySet)pO).map.comparator())) {
            return this.map.equals(((SortedMapEntrySet)pO).map);
        }
        return super.equals(pO);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean contains(@Nullable Object pO) {
        if (!(pO instanceof Map.Entry)) {
            return false;
        }
        Map.Entry other = (Map.Entry)pO;
        Map.Entry<K, V> entry = this.map.getEntry(other.getKey());
        return entry != null && Objects.equals(entry.getValue(), other.getValue());
    }

    @Override
    public boolean containsAll(Collection<?> pC) {
        return Collections3.sortedSetContainsAll(this, pC, (Equivalence<Object>)Equivalence.equals());
    }

    @Override
    public Map.Entry<K, V> ceiling(Map.Entry<K, V> pE) {
        return this.map.ceilingEntry(pE.getKey());
    }

    @Override
    public Map.Entry<K, V> first() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.map.firstEntry();
    }

    @Override
    public Map.Entry<K, V> floor(Map.Entry<K, V> pE) {
        return this.map.floorEntry(pE.getKey());
    }

    @Override
    public Map.Entry<K, V> higher(Map.Entry<K, V> pE) {
        return this.map.higherEntry(pE.getKey());
    }

    @Override
    public Map.Entry<K, V> last() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.map.lastEntry();
    }

    @Override
    public Map.Entry<K, V> lower(Map.Entry<K, V> pE) {
        return this.map.lowerEntry(pE.getKey());
    }

    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        return this.map.entryIterator();
    }

    @Override
    public Iterator<Map.Entry<K, V>> descendingIterator() {
        return this.map.descendingMap().entryIterator();
    }

    @Override
    public NavigableSet<Map.Entry<K, V>> descendingSet() {
        return this.map.descendingMap().entrySet();
    }

    @Override
    public boolean add(Map.Entry<K, V> pE) {
        if (this.contains(pE)) {
            return false;
        }
        this.map.put(pE.getKey(), pE.getValue());
        return true;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Map.Entry<K, V> pollFirst() {
        return this.map.pollFirstEntry();
    }

    @Override
    public Map.Entry<K, V> pollLast() {
        return this.map.pollLastEntry();
    }

    @Override
    public boolean remove(@Nullable Object pO) {
        if (!(pO instanceof Map.Entry)) {
            return false;
        }
        Map.Entry entry = (Map.Entry)pO;
        return this.map.remove(entry.getKey(), entry.getValue());
    }

    @Override
    public Comparator<? super Map.Entry<K, V>> comparator() {
        if (this.map.comparator() == null) {
            Comparator comp = Map.Entry.comparingByKey();
            return comp;
        }
        return Map.Entry.comparingByKey(this.map.comparator());
    }

    @Override
    public NavigableSet<Map.Entry<K, V>> subSet(Map.Entry<K, V> pFromElement, boolean pFromInclusive, Map.Entry<K, V> pToElement, boolean pToInclusive) {
        return this.map.subMap((Object)pFromElement.getKey(), pFromInclusive, (Object)pToElement.getKey(), pToInclusive).entrySet();
    }

    @Override
    public NavigableSet<Map.Entry<K, V>> headSet(Map.Entry<K, V> pToElement, boolean pInclusive) {
        return this.map.headMap((Object)pToElement.getKey(), pInclusive).entrySet();
    }

    @Override
    public NavigableSet<Map.Entry<K, V>> tailSet(Map.Entry<K, V> pFromElement, boolean pInclusive) {
        return this.map.tailMap((Object)pFromElement.getKey(), pInclusive).entrySet();
    }

    @Override
    public NavigableSet<Map.Entry<K, V>> subSet(Map.Entry<K, V> pFromElement, Map.Entry<K, V> pToElement) {
        return this.map.subMap((Object)pFromElement.getKey(), (Object)pToElement.getKey()).entrySet();
    }

    @Override
    public NavigableSet<Map.Entry<K, V>> headSet(Map.Entry<K, V> pToElement) {
        return this.map.headMap((Object)pToElement.getKey()).entrySet();
    }

    @Override
    public NavigableSet<Map.Entry<K, V>> tailSet(Map.Entry<K, V> pFromElement) {
        return this.map.tailMap((Object)pFromElement.getKey()).entrySet();
    }
}

