/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.smg.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableSet;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.cpachecker.util.smg.util.Collections3;
import org.sosy_lab.cpachecker.util.smg.util.OurSortedMap;

@SuppressFBWarnings(value={"NP_PARAMETER_MUST_BE_NONNULL_BUT_MARKED_AS_NULLABLE"}, justification="nullability depends on underlying map")
final class SortedMapKeySet<K>
extends AbstractSet<K>
implements NavigableSet<K>,
Serializable {
    private static final long serialVersionUID = 8196534519512074110L;
    private final OurSortedMap<K, ?> map;

    SortedMapKeySet(OurSortedMap<K, ?> pMap) {
        this.map = (OurSortedMap)Preconditions.checkNotNull(pMap);
    }

    @Override
    public Iterator<K> iterator() {
        return Iterators.transform(this.map.entryIterator(), Map.Entry::getKey);
    }

    @Override
    public boolean equals(@Nullable Object pO) {
        return Collections3.sortedSetEquals(this, pO);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean contains(@Nullable Object pO) {
        return this.map.containsKey(pO);
    }

    @Override
    public boolean containsAll(Collection<?> pC) {
        return Collections3.sortedSetContainsAll(this, pC, null);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Comparator<? super K> comparator() {
        return this.map.comparator();
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean remove(@Nullable Object pO) {
        if (this.map.containsKey(pO)) {
            this.map.remove(pO);
            return true;
        }
        return false;
    }

    @Override
    public K first() {
        return this.map.firstKey();
    }

    @Override
    public K last() {
        return this.map.lastKey();
    }

    @Override
    public NavigableSet<K> subSet(@Nullable K pFromElement, @Nullable K pToElement) {
        return new SortedMapKeySet<K>(this.map.subMap((Object)pFromElement, (Object)pToElement));
    }

    @Override
    public NavigableSet<K> headSet(@Nullable K pToElement) {
        return new SortedMapKeySet<K>(this.map.headMap((Object)pToElement));
    }

    @Override
    public NavigableSet<K> tailSet(@Nullable K pFromElement) {
        return new SortedMapKeySet<K>(this.map.tailMap((Object)pFromElement));
    }

    @Override
    public K lower(@Nullable K pE) {
        return this.map.lowerKey(pE);
    }

    @Override
    public K floor(@Nullable K pE) {
        return this.map.floorKey(pE);
    }

    @Override
    public K ceiling(@Nullable K pE) {
        return this.map.ceilingKey(pE);
    }

    @Override
    public K higher(@Nullable K pE) {
        return this.map.higherKey(pE);
    }

    @Override
    public K pollFirst() {
        return this.map.pollFirstEntry().getKey();
    }

    @Override
    public K pollLast() {
        return this.map.pollLastEntry().getKey();
    }

    @Override
    public NavigableSet<K> descendingSet() {
        return this.map.descendingKeySet();
    }

    @Override
    public Iterator<K> descendingIterator() {
        return this.map.descendingKeySet().iterator();
    }

    @Override
    public NavigableSet<K> subSet(@Nullable K pFromElement, boolean pFromInclusive, @Nullable K pToElement, boolean pToInclusive) {
        return new SortedMapKeySet<K>(this.map.subMap((Object)pFromElement, pFromInclusive, (Object)pToElement, pToInclusive));
    }

    @Override
    public NavigableSet<K> headSet(@Nullable K pToElement, boolean pInclusive) {
        return new SortedMapKeySet<K>(this.map.headMap((Object)pToElement, pInclusive));
    }

    @Override
    public NavigableSet<K> tailSet(@Nullable K pFromElement, boolean pInclusive) {
        return new SortedMapKeySet<K>(this.map.tailMap((Object)pFromElement, pInclusive));
    }
}

