/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.states;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Ordering;
import com.google.errorprone.annotations.Immutable;
import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.cpachecker.cfa.ast.ASimpleDeclaration;

@Immutable
public final class MemoryLocation
implements Comparable<MemoryLocation>,
Serializable {
    private static final long serialVersionUID = -8910967707373729034L;
    private final @Nullable String functionName;
    private final String identifier;
    private final @Nullable Long offset;

    private MemoryLocation(@Nullable String pFunctionName, String pIdentifier, @Nullable Long pOffset) {
        Preconditions.checkNotNull((Object)pIdentifier);
        this.functionName = pFunctionName;
        this.identifier = pIdentifier;
        this.offset = pOffset;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MemoryLocation)) {
            return false;
        }
        MemoryLocation otherLocation = (MemoryLocation)other;
        return Objects.equals(this.functionName, otherLocation.functionName) && Objects.equals(this.identifier, otherLocation.identifier) && Objects.equals(this.offset, otherLocation.offset);
    }

    public int hashCode() {
        return Objects.hash(this.functionName, this.identifier, this.offset);
    }

    public static MemoryLocation forDeclaration(ASimpleDeclaration pDeclaration) {
        return MemoryLocation.fromQualifiedName(pDeclaration.getQualifiedName());
    }

    public static MemoryLocation forIdentifier(String pIdentifier) {
        return new MemoryLocation(null, pIdentifier, null);
    }

    public static MemoryLocation forIdentifier(String pIdentifier, long pOffset) {
        return new MemoryLocation(null, pIdentifier, pOffset);
    }

    public static MemoryLocation forLocalVariable(String pFunctionName, String pIdentifier) {
        return new MemoryLocation((String)Preconditions.checkNotNull((Object)pFunctionName), pIdentifier, null);
    }

    public static MemoryLocation forLocalVariable(String pFunctionName, String pIdentifier, long pOffset) {
        return new MemoryLocation((String)Preconditions.checkNotNull((Object)pFunctionName), pIdentifier, pOffset);
    }

    private static MemoryLocation fromQualifiedName(String pIdentifier, @Nullable Long pOffset) {
        String identifier;
        String functionName;
        int separatorIndex = pIdentifier.indexOf("::");
        if (separatorIndex >= 0) {
            functionName = pIdentifier.substring(0, separatorIndex);
            identifier = pIdentifier.substring(separatorIndex + 2);
        } else {
            functionName = null;
            identifier = pIdentifier;
        }
        return new MemoryLocation(functionName, identifier, pOffset);
    }

    public static MemoryLocation fromQualifiedName(String pIdentifier) {
        return MemoryLocation.fromQualifiedName(pIdentifier, null);
    }

    public static MemoryLocation fromQualifiedName(String pIdentifier, long pOffset) {
        return MemoryLocation.fromQualifiedName(pIdentifier, (Long)pOffset);
    }

    public static MemoryLocation parseExtendedQualifiedName(String pVariableName) {
        Long offset;
        List nameParts = Splitter.on((String)"::").splitToList((CharSequence)pVariableName);
        List offsetParts = Splitter.on((char)'/').splitToList((CharSequence)pVariableName);
        boolean isScoped = nameParts.size() == 2;
        boolean hasOffset = offsetParts.size() == 2;
        Long l = offset = hasOffset ? Long.valueOf(Long.parseLong((String)offsetParts.get(1))) : null;
        if (isScoped) {
            String functionName = (String)nameParts.get(0);
            String varName = (String)nameParts.get(1);
            if (hasOffset) {
                varName = varName.replace("/" + offset, "");
            }
            return new MemoryLocation(functionName, varName, offset);
        }
        String varName = (String)nameParts.get(0);
        if (hasOffset) {
            varName = varName.replace("/" + offset, "");
        }
        return new MemoryLocation(null, varName.replace("/" + offset, ""), offset);
    }

    public String getExtendedQualifiedName() {
        String variableName = this.getQualifiedName();
        if (this.offset == null) {
            return variableName;
        }
        return variableName + "/" + this.offset;
    }

    public String getQualifiedName() {
        return this.isOnFunctionStack() ? this.functionName + "::" + this.identifier : this.identifier;
    }

    public boolean isOnFunctionStack() {
        return this.functionName != null;
    }

    public boolean isOnFunctionStack(String pFunctionName) {
        return this.functionName != null && pFunctionName.equals(this.functionName);
    }

    public String getFunctionName() {
        return (String)Preconditions.checkNotNull((Object)this.functionName);
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public boolean isReference() {
        return this.offset != null;
    }

    public long getOffset() {
        Preconditions.checkState((this.offset != null ? 1 : 0) != 0, (String)"memory location '%s' has no offset", (Object)this);
        return this.offset;
    }

    public MemoryLocation getReferenceStart() {
        Preconditions.checkState((boolean)this.isReference(), (String)"Memory location is no reference: %s", (Object)this);
        return new MemoryLocation(this.functionName, this.identifier, null);
    }

    public MemoryLocation withOffset(long pNewOffset) {
        return new MemoryLocation(this.functionName, this.identifier, pNewOffset);
    }

    public MemoryLocation withAddedOffset(long pAddToOffset) {
        long oldOffset = this.offset == null ? 0L : this.offset;
        return new MemoryLocation(this.functionName, this.identifier, oldOffset + pAddToOffset);
    }

    public String toString() {
        return this.getExtendedQualifiedName();
    }

    @Override
    public int compareTo(MemoryLocation other) {
        return ComparisonChain.start().compare((Object)this.functionName, (Object)other.functionName, (Comparator)Ordering.natural().nullsFirst()).compare((Comparable)((Object)this.identifier), (Comparable)((Object)other.identifier)).compare((Object)this.offset, (Object)other.offset, (Comparator)Ordering.natural().nullsFirst()).result();
    }
}

