/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.statistics;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multiset;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.sosy_lab.cpachecker.util.statistics.AbstractStatValue;
import org.sosy_lab.cpachecker.util.statistics.StatKind;

public class StatHist
extends AbstractStatValue {
    protected final Multiset<Long> hist = HashMultiset.create();

    public StatHist(String pTitle) {
        super(StatKind.AVG, pTitle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTimesWithValue(Long value) {
        Multiset<Long> multiset = this.hist;
        synchronized (multiset) {
            return this.hist.count((Object)value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertValue(long pNewValue) {
        Multiset<Long> multiset = this.hist;
        synchronized (multiset) {
            this.hist.add((Object)pNewValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertValue(long pNewValue, int occurrences) {
        Multiset<Long> multiset = this.hist;
        synchronized (multiset) {
            this.hist.add((Object)pNewValue, occurrences);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Multiset<Long> multiset = this.hist;
        synchronized (multiset) {
            return String.format("%s (cnt=%d, avg=%.2f, dev=%.2f)", this.hist, this.hist.size(), this.getAvg(), this.getStdDeviation());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getStdDeviation() {
        Multiset<Long> multiset = this.hist;
        synchronized (multiset) {
            double avg = this.getAvg();
            double sum = 0.0;
            for (Multiset.Entry e : this.hist.entrySet()) {
                double deviation = avg - (double)((Long)e.getElement()).longValue();
                sum += deviation * deviation * (double)e.getCount();
            }
            return Math.sqrt(sum / (double)this.hist.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getAvg() {
        Multiset<Long> multiset = this.hist;
        synchronized (multiset) {
            return this.getSum() / (double)this.hist.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMean() {
        Multiset<Long> multiset = this.hist;
        synchronized (multiset) {
            ImmutableList values = ImmutableList.sortedCopyOf((Iterable)this.hist.elementSet());
            int i = 0;
            int middle = (this.hist.size() + 1) / 2;
            UnmodifiableIterator unmodifiableIterator = values.iterator();
            while (unmodifiableIterator.hasNext()) {
                long value = (Long)unmodifiableIterator.next();
                int count = this.hist.count((Object)value);
                if (i < middle && middle <= i + count) {
                    return value;
                }
                i += count;
            }
            return 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMax() {
        Multiset<Long> multiset = this.hist;
        synchronized (multiset) {
            return this.hist.isEmpty() ? Long.MIN_VALUE : (Long)Collections.max(this.hist.elementSet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMin() {
        Multiset<Long> multiset = this.hist;
        synchronized (multiset) {
            return this.hist.isEmpty() ? Long.MAX_VALUE : (Long)Collections.min(this.hist.elementSet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getSum() {
        Multiset<Long> multiset = this.hist;
        synchronized (multiset) {
            return this.hist.entrySet().stream().mapToDouble(e -> (double)((Long)e.getElement()).longValue() * (double)e.getCount()).sum();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getUpdateCount() {
        Multiset<Long> multiset = this.hist;
        synchronized (multiset) {
            return this.hist.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mergeWith(StatHist other) {
        LinkedHashMap<Long, Integer> countMap = new LinkedHashMap<Long, Integer>();
        Multiset<Long> multiset = other.hist;
        synchronized (multiset) {
            for (Long l : other.hist.elementSet()) {
                countMap.put(l, other.hist.count((Object)l));
            }
        }
        multiset = this.hist;
        synchronized (multiset) {
            for (Map.Entry entry : countMap.entrySet()) {
                this.hist.add((Object)((Long)entry.getKey()), ((Integer)entry.getValue()).intValue());
            }
        }
    }
}

