/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.statistics;

import com.google.common.truth.Truth;
import org.junit.Before;
import org.junit.Test;
import org.sosy_lab.cpachecker.util.statistics.StatHist;

public class StatHistTest {
    private StatHist sh;

    @Before
    public void init() {
        this.sh = new StatHist("foo");
    }

    @Test
    public void testMinMax0() {
        Truth.assert_().that(Long.valueOf(this.sh.getMax())).isEqualTo((Object)Long.MIN_VALUE);
        Truth.assert_().that(Long.valueOf(this.sh.getMin())).isEqualTo((Object)Long.MAX_VALUE);
    }

    @Test
    public void testMinMax1() {
        this.sh.insertValue(1L);
        this.sh.insertValue(3L);
        this.sh.insertValue(1L);
        this.sh.insertValue(-10L);
        Truth.assert_().that(Long.valueOf(this.sh.getMax())).isEqualTo((Object)3);
        Truth.assert_().that(Long.valueOf(this.sh.getMin())).isEqualTo((Object)-10);
    }

    @Test
    public void testAvg0() {
        Truth.assert_().that(Double.valueOf(this.sh.getAvg())).isEqualTo((Object)Double.NaN);
    }

    @Test
    public void testDev0() {
        Truth.assert_().that(Double.valueOf(this.sh.getStdDeviation())).isEqualTo((Object)Double.NaN);
    }

    @Test
    public void testMean0() {
        Truth.assert_().that(Long.valueOf(this.sh.getMean())).isEqualTo((Object)0);
    }

    @Test
    public void testAvg1() {
        this.sh.insertValue(1L);
        Truth.assert_().that(Double.valueOf(this.sh.getAvg())).isEqualTo((Object)1.0);
        Truth.assert_().that(Long.valueOf(this.sh.getMean())).isEqualTo((Object)1);
        this.sh.insertValue(1L);
        Truth.assert_().that(Double.valueOf(this.sh.getAvg())).isEqualTo((Object)1.0);
        Truth.assert_().that(Long.valueOf(this.sh.getMean())).isEqualTo((Object)1);
        this.sh.insertValue(4L);
        Truth.assert_().that(Double.valueOf(this.sh.getAvg())).isEqualTo((Object)2.0);
        Truth.assert_().that(Long.valueOf(this.sh.getMean())).isEqualTo((Object)1);
        this.sh.insertValue(4L);
        Truth.assert_().that(Double.valueOf(this.sh.getAvg())).isEqualTo((Object)2.5);
        Truth.assert_().that(Long.valueOf(this.sh.getMean())).isEqualTo((Object)1);
    }

    @Test
    public void testAvg2() {
        for (int x : new int[]{2, 4, 4, 4, 5, 5, 7, 9}) {
            this.sh.insertValue(x);
        }
        Truth.assert_().that(Double.valueOf(this.sh.getAvg())).isEqualTo((Object)5.0);
        Truth.assert_().that(Double.valueOf(this.sh.getStdDeviation())).isEqualTo((Object)2.0);
        Truth.assert_().that(Long.valueOf(this.sh.getMin())).isEqualTo((Object)2);
        Truth.assert_().that(Long.valueOf(this.sh.getMax())).isEqualTo((Object)9);
        Truth.assert_().that(Long.valueOf(this.sh.getMean())).isEqualTo((Object)4);
    }
}

