/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.statistics;

import com.google.errorprone.annotations.InlineMe;
import java.util.IntSummaryStatistics;
import java.util.concurrent.atomic.LongAccumulator;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.IntConsumer;
import java.util.stream.IntStream;
import org.sosy_lab.cpachecker.util.statistics.AbstractStatValue;
import org.sosy_lab.cpachecker.util.statistics.StatKind;

public class StatInt
extends AbstractStatValue
implements IntConsumer {
    private LongAccumulator maxValue = new LongAccumulator(Math::max, Integer.MIN_VALUE);
    private LongAccumulator minValue = new LongAccumulator(Math::min, Integer.MAX_VALUE);
    private LongAdder valueCount = new LongAdder();
    private LongAdder valueSum = new LongAdder();

    public static StatInt forStream(StatKind pMainStatisticKind, String pTitle, IntStream pStream) {
        return new StatInt(pMainStatisticKind, pTitle, pStream.summaryStatistics());
    }

    public StatInt(StatKind pMainStatisticKind, String pTitle) {
        super(pMainStatisticKind, pTitle);
    }

    public StatInt(StatKind pMainStatisticKind, String pTitle, IntSummaryStatistics initialValues) {
        this(pMainStatisticKind, pTitle);
        this.maxValue.accumulate(initialValues.getMax());
        this.minValue.accumulate(initialValues.getMin());
        this.valueCount.add(initialValues.getCount());
        this.valueSum.add(initialValues.getSum());
    }

    public void add(StatInt pOther) {
        this.valueSum.add(pOther.getValueSum());
        this.valueCount.add(pOther.getValueCount());
        this.maxValue.accumulate(pOther.getMaxValue());
        this.minValue.accumulate(pOther.getMinValue());
    }

    @Override
    @Deprecated
    @InlineMe(replacement="this.setNextValue(pValue)")
    public final void accept(int pValue) {
        this.setNextValue(pValue);
    }

    public void setNextValue(int newValue) {
        this.valueSum.add(newValue);
        this.valueCount.increment();
        this.maxValue.accumulate(newValue);
        this.minValue.accumulate(newValue);
    }

    public long getMaxValue() {
        return this.valueCount.sum() == 0L ? 0L : (long)this.maxValue.intValue();
    }

    public long getMinValue() {
        return this.valueCount.sum() == 0L ? 0L : (long)this.minValue.intValue();
    }

    public long getValueCount() {
        return this.valueCount.sum();
    }

    public long getValueSum() {
        return this.valueSum.sum();
    }

    public float getAverage() {
        long count = this.valueCount.sum();
        if (count > 0L) {
            return (float)this.valueSum.sum() / (float)count;
        }
        return 0.0f;
    }

    @Deprecated
    public long getMax() {
        return this.maxValue.get();
    }

    @Deprecated
    public long getMin() {
        return this.minValue.get();
    }

    @Override
    public int getUpdateCount() {
        return this.valueCount.intValue();
    }

    public String toString() {
        switch (this.getMainStatisticKind()) {
            case SUM: {
                return String.format("%8d (count: %d, min: %d, max: %d, avg: %.2f)", this.getValueSum(), this.getValueCount(), this.getMinValue(), this.getMaxValue(), Float.valueOf(this.getAverage()));
            }
            case AVG: {
                return String.format("%.2f (sum: %d, count: %d, min: %d, max: %d)", Float.valueOf(this.getAverage()), this.getValueSum(), this.getValueCount(), this.getMinValue(), this.getMaxValue());
            }
            case COUNT: {
                return String.format("%8d (sum: %d, min: %d, max: %d, avg: %.2f)", this.getValueCount(), this.getValueSum(), this.getMinValue(), this.getMaxValue(), Float.valueOf(this.getAverage()));
            }
            case MIN: {
                return String.format("%8d (sum: %d, count: %d, max: %d, avg: %.2f)", this.getMinValue(), this.getValueSum(), this.getValueCount(), this.getMaxValue(), Float.valueOf(this.getAverage()));
            }
            case MAX: {
                return String.format("%8d (sum: %d, count: %d, min: %d, avg: %.2f)", this.getMaxValue(), this.getValueSum(), this.getValueCount(), this.getMinValue(), Float.valueOf(this.getAverage()));
            }
        }
        throw new AssertionError();
    }
}

