/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.statistics;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.sosy_lab.cpachecker.util.statistics.StatHist;
import org.sosy_lab.cpachecker.util.statistics.StatInt;
import org.sosy_lab.cpachecker.util.statistics.StatKind;

public class StatisticsSeries<T> {
    private final long startTime = System.currentTimeMillis();
    private final Collection<DataObject<T>> series = new ConcurrentLinkedQueue<DataObject<T>>();

    public void add(T pData) {
        this.series.add(new DataObject<T>(pData));
    }

    Collection<DataObject<T>> getSeries() {
        return ImmutableList.sortedCopyOf(this.series);
    }

    long getStartTime() {
        return this.startTime;
    }

    public String toString() {
        return Joiner.on((char)'\n').join(this.series);
    }

    public static class StatisticsSeriesWithNumbers
    extends StatisticsSeries<Integer> {
        public StatInt getStatsWithoutTime() {
            StatInt stats = new StatInt(StatKind.AVG, null);
            for (DataObject data : this.getSeries()) {
                stats.setNextValue((Integer)data.data);
            }
            return stats;
        }

        public StatHist getStatsOverTime() {
            StatHist stats = new StatHist(null);
            long currentTime = this.getStartTime();
            for (DataObject data : this.getSeries()) {
                long occurences = data.time - currentTime;
                stats.insertValue(((Integer)data.data).intValue(), Ints.checkedCast((long)occurences));
                currentTime = data.time;
            }
            return stats;
        }
    }

    public static class NoopStatisticsSeries<T>
    extends StatisticsSeries<T> {
        @Override
        public void add(T pData) {
        }
    }

    private class DataObject<TT>
    implements Comparable<DataObject<TT>> {
        private final long time = System.currentTimeMillis();
        private final TT data;

        DataObject(TT pData) {
            this.data = pData;
        }

        public String toString() {
            return this.time - StatisticsSeries.this.startTime + ", " + this.data;
        }

        @Override
        public int compareTo(DataObject<TT> pOther) {
            return Longs.compare((long)this.time, (long)pOther.time);
        }

        public boolean equals(Object pOther) {
            return super.equals(pOther);
        }

        public int hashCode() {
            return super.hashCode();
        }
    }
}

