/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.statistics;

import com.google.common.base.Strings;
import java.io.PrintStream;
import java.util.logging.Level;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.time.TimeSpan;
import org.sosy_lab.common.time.Timer;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.util.statistics.AbstractStatValue;

public class StatisticsUtils {
    private static final TimeSpan STATISTICS_WARNING_TIME = TimeSpan.ofSeconds((long)10L);

    private StatisticsUtils() {
    }

    public static String toPercent(double val, double full) {
        return String.format("%1.0f%%", val / full * 100.0);
    }

    public static String toPercent(long val, long full) {
        return StatisticsUtils.toPercent((double)val, (double)full);
    }

    public static String valueWithPercentage(Number value, Number totalCount) {
        return value + " (" + StatisticsUtils.toPercent(value.doubleValue(), totalCount.doubleValue()) + ")";
    }

    public static String div(double val, double full) {
        return String.format("%.2f", val / full);
    }

    public static String div(long val, long full) {
        return StatisticsUtils.div((double)val, (double)full);
    }

    public static void write(PrintStream target, int indentLevel, int outputNameColWidth, String name, Object value) {
        String indentation = "  ".repeat(indentLevel);
        target.println(String.format("%-" + outputNameColWidth + "s %s", indentation + name + ":", value));
    }

    public static void write(PrintStream target, int indentLevel, int outputNameColWidth, AbstractStatValue stat) {
        StatisticsUtils.write(target, indentLevel, outputNameColWidth, stat.getTitle(), stat.toString());
    }

    public static void printStatistics(Statistics pStatistics, PrintStream pOut, LogManager pLogger, CPAcheckerResult.Result pResult, UnmodifiableReachedSet pReached) {
        String name = StatisticsUtils.getStatisticsName(pStatistics);
        if (!Strings.isNullOrEmpty((String)pStatistics.getName())) {
            pOut.println();
            pOut.println(name);
            pOut.println("-".repeat(name.length()));
        }
        Timer timer = new Timer();
        timer.start();
        try {
            pStatistics.printStatistics(pOut, pResult, pReached);
        }
        catch (OutOfMemoryError e) {
            pLogger.logUserException(Level.WARNING, (Throwable)e, "Out of memory while generating statistics from " + name + " and writing output files");
        }
        timer.stop();
        if (timer.getLengthOfLastInterval().compareTo(STATISTICS_WARNING_TIME) > 0) {
            pLogger.logf(Level.WARNING, "Generating statistics from %s took %s.", new Object[]{name, timer});
        }
    }

    public static void writeOutputFiles(Statistics statistics, LogManager logger, CPAcheckerResult.Result result, UnmodifiableReachedSet reached) {
        Timer timer = new Timer();
        timer.start();
        try {
            statistics.writeOutputFiles(result, reached);
        }
        catch (OutOfMemoryError e) {
            logger.logUserException(Level.WARNING, (Throwable)e, "Out of memory while writing output files from " + StatisticsUtils.getStatisticsName(statistics));
        }
        timer.stop();
        if (timer.getLengthOfLastInterval().compareTo(STATISTICS_WARNING_TIME) > 0) {
            logger.logf(Level.WARNING, "Writing output files from %s took %s.", new Object[]{StatisticsUtils.getStatisticsName(statistics), timer});
        }
    }

    private static String getStatisticsName(Statistics pStatistics) {
        if (Strings.isNullOrEmpty((String)pStatistics.getName())) {
            return pStatistics.getClass().getName();
        }
        return pStatistics.getName() + " statistics";
    }
}

