/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.statistics;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.PrintStream;
import java.util.Optional;
import java.util.function.Function;
import org.sosy_lab.cpachecker.util.statistics.AbstractStatValue;
import org.sosy_lab.cpachecker.util.statistics.StatisticsUtils;

public class StatisticsWriter {
    private final StatisticsWriter parentLevelWriter;
    private final PrintStream target;
    private final int level;
    private final int outputNameColWidth;

    private StatisticsWriter(PrintStream pTarget, int pLevel, int pOutputNameColWidth, StatisticsWriter pParentLevelWriter) {
        this.parentLevelWriter = pParentLevelWriter;
        this.target = pTarget;
        this.level = pLevel;
        this.outputNameColWidth = pOutputNameColWidth;
    }

    protected StatisticsWriter newInstance(PrintStream pTarget, int pLevel, int pOutputNameColWidth, StatisticsWriter pParentLevelWriter) {
        return new StatisticsWriter(pTarget, pLevel, pOutputNameColWidth, pParentLevelWriter);
    }

    public static StatisticsWriter writingStatisticsTo(PrintStream pTarget) {
        return new StatisticsWriter(pTarget, 0, 50, null);
    }

    public StatisticsWriter withNameColumnWith(int pWidth) {
        return this.newInstance(this.target, this.level, pWidth, this);
    }

    public StatisticsWriter beginLevel() {
        return this.newInstance(this.target, this.level + 1, this.outputNameColWidth, this);
    }

    public StatisticsWriter withLevel(int pLevel) {
        return this.newInstance(this.target, pLevel, this.outputNameColWidth, this);
    }

    public StatisticsWriter endLevel() {
        if (this.parentLevelWriter == null) {
            return this;
        }
        return this.parentLevelWriter;
    }

    public StatisticsWriter ifUpdatedAtLeastOnce(AbstractStatValue stat) {
        return this.ifTrue(stat.getUpdateCount() > 0);
    }

    public StatisticsWriter ifTrue(boolean condition) {
        if (condition) {
            return this;
        }
        return new DisabledStatisticsWriter(this.target, this.level, this.outputNameColWidth, this.parentLevelWriter);
    }

    @CanIgnoreReturnValue
    public StatisticsWriter spacer() {
        this.target.println();
        return this;
    }

    @CanIgnoreReturnValue
    public StatisticsWriter put(String name, Object value) {
        StatisticsUtils.write(this.target, this.level, this.outputNameColWidth, name, value);
        return this;
    }

    @CanIgnoreReturnValue
    public StatisticsWriter put(AbstractStatValue stat) {
        StatisticsUtils.write(this.target, this.level, this.outputNameColWidth, stat);
        return this;
    }

    @CanIgnoreReturnValue
    public StatisticsWriter putIfUpdatedAtLeastOnce(AbstractStatValue stat) {
        return this.putIf(stat.getUpdateCount() > 0, stat);
    }

    @CanIgnoreReturnValue
    public StatisticsWriter putIf(boolean condition, AbstractStatValue stat) {
        if (condition) {
            this.put(stat);
        }
        return this;
    }

    @CanIgnoreReturnValue
    public StatisticsWriter putIf(boolean condition, String name, Object value) {
        if (condition) {
            this.put(name, value);
        }
        return this;
    }

    @CanIgnoreReturnValue
    public <T> StatisticsWriter putIfPresent(Optional<T> subject, String name, Function<T, ?> valueProducer) {
        subject.ifPresent(value -> this.put(name, valueProducer.apply(value)));
        return this;
    }

    @CanIgnoreReturnValue
    public <T> StatisticsWriter putIfPresent(Optional<T> subject, Function<T, ? extends AbstractStatValue> valueProducer) {
        return this.putIfPresent(subject.map(valueProducer));
    }

    @CanIgnoreReturnValue
    public StatisticsWriter putIfPresent(Optional<? extends AbstractStatValue> stat) {
        stat.ifPresent(this::put);
        return this;
    }

    private static class DisabledStatisticsWriter
    extends StatisticsWriter {
        DisabledStatisticsWriter(PrintStream pTarget, int pLevel, int pOutputNameColWidth, StatisticsWriter pParentLevelWriter) {
            super(pTarget, pLevel, pOutputNameColWidth, pParentLevelWriter);
        }

        @Override
        protected DisabledStatisticsWriter newInstance(PrintStream pTarget, int pLevel, int pOutputNameColWidth, StatisticsWriter pParentLevelWriter) {
            return new DisabledStatisticsWriter(pTarget, pLevel, pOutputNameColWidth, pParentLevelWriter);
        }

        @Override
        public StatisticsWriter spacer() {
            return this;
        }

        @Override
        public StatisticsWriter put(AbstractStatValue pStat) {
            return this;
        }

        @Override
        public StatisticsWriter put(String pName, Object pValue) {
            return this;
        }
    }
}

