/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.statistics;

import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.IdentityHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.sosy_lab.common.time.TimeSpan;
import org.sosy_lab.common.time.Timer;
import org.sosy_lab.cpachecker.util.statistics.AbstractStatValue;
import org.sosy_lab.cpachecker.util.statistics.StatKind;

public final class ThreadSafeTimerContainer
extends AbstractStatValue {
    @GuardedBy(value="activeTimers")
    private final IdentityHashMap<WeakReference<TimerWrapper>, Timer> activeTimers = new IdentityHashMap();
    private final ReferenceQueue<TimerWrapper> referenceQueue = new ReferenceQueue();
    private final TimeUnit unit = new Timer().getMaxTime().getUnit();
    @GuardedBy(value="activeTimers")
    private long sumTime = 0L;
    @GuardedBy(value="activeTimers")
    private long maxTime = 0L;
    @GuardedBy(value="activeTimers")
    private int numberOfIntervals = 0;

    @Deprecated
    public ThreadSafeTimerContainer(String title) {
        super(StatKind.SUM, title);
    }

    @Override
    public int getUpdateCount() {
        return this.getNumberOfIntervals();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimerWrapper getNewTimer() {
        this.cleanupReferences();
        Timer timer = new Timer();
        TimerWrapper wrapper = new TimerWrapper(timer);
        assert (this.unit == timer.getSumTime().getUnit()) : "sub-timers should use same unit";
        IdentityHashMap<WeakReference<TimerWrapper>, Timer> identityHashMap = this.activeTimers;
        synchronized (identityHashMap) {
            this.activeTimers.put(new WeakReference<TimerWrapper>(wrapper, this.referenceQueue), timer);
        }
        return wrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupReferences() {
        Reference<TimerWrapper> ref;
        while ((ref = this.referenceQueue.poll()) != null) {
            IdentityHashMap<WeakReference<TimerWrapper>, Timer> identityHashMap = this.activeTimers;
            synchronized (identityHashMap) {
                this.closeTimer(this.activeTimers.remove(ref));
            }
        }
    }

    @GuardedBy(value="activeTimers")
    private void closeTimer(Timer timer) {
        timer.stopIfRunning();
        this.sumTime += this.convert(timer.getSumTime());
        this.maxTime = Math.max(this.maxTime, this.convert(timer.getMaxTime()));
        this.numberOfIntervals += timer.getNumberOfIntervals();
    }

    private long convert(TimeSpan time) {
        return time.getSaturated(this.unit);
    }

    @GuardedBy(value="activeTimers")
    private long eval(Function<Timer, Long> f, BiFunction<Long, Long, Long> acc) {
        long currentInterval = 0L;
        for (Timer timer : this.activeTimers.values()) {
            boolean doNotRemove = timer.isRunning();
            currentInterval = acc.apply(currentInterval, f.apply(timer));
        }
        return currentInterval;
    }

    public TimeSpan getSumTime() {
        this.cleanupReferences();
        return this.export(this.sumTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long sumTime() {
        IdentityHashMap<WeakReference<TimerWrapper>, Timer> identityHashMap = this.activeTimers;
        synchronized (identityHashMap) {
            return this.sumTime + this.eval(t -> this.convert(t.getSumTime()), Math::addExact);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimeSpan getMaxTime() {
        this.cleanupReferences();
        IdentityHashMap<WeakReference<TimerWrapper>, Timer> identityHashMap = this.activeTimers;
        synchronized (identityHashMap) {
            return this.export(Math.max(this.maxTime, this.eval(t -> this.convert(t.getMaxTime()), Math::max)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfIntervals() {
        this.cleanupReferences();
        IdentityHashMap<WeakReference<TimerWrapper>, Timer> identityHashMap = this.activeTimers;
        synchronized (identityHashMap) {
            return (int)((long)this.numberOfIntervals + this.eval(t -> t.getNumberOfIntervals(), Math::addExact));
        }
    }

    public TimeSpan getAvgTime() {
        this.cleanupReferences();
        int currentNumberOfIntervals = this.getNumberOfIntervals();
        if (currentNumberOfIntervals == 0) {
            return this.export(0L);
        }
        return this.export(this.sumTime() / (long)currentNumberOfIntervals);
    }

    private TimeSpan export(long time) {
        return TimeSpan.of((long)time, (TimeUnit)this.unit);
    }

    public String toString() {
        this.cleanupReferences();
        return this.getSumTime().formatAs(TimeUnit.SECONDS);
    }

    public String prettyFormat() {
        this.cleanupReferences();
        TimeUnit t = TimeUnit.SECONDS;
        return String.format("%s (Max: %s), (Avg: %s), (#intervals = %s)", this.getSumTime().formatAs(t), this.getMaxTime().formatAs(t), this.getAvgTime().formatAs(t), this.getNumberOfIntervals());
    }

    public static class TimerWrapper {
        private final Timer timer;

        TimerWrapper(Timer pTimer) {
            this.timer = pTimer;
        }

        public void start() {
            this.timer.start();
        }

        public void stop() {
            this.timer.stop();
        }

        public void stopIfRunning() {
            this.timer.stopIfRunning();
        }

        public boolean isRunning() {
            return this.timer.isRunning();
        }

        public TimeSpan getLengthOfLastInterval() {
            return this.timer.getLengthOfLastInterval();
        }
    }
}

