/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.statistics;

import com.google.common.truth.Truth;
import org.junit.Before;
import org.junit.Test;
import org.sosy_lab.cpachecker.util.statistics.ThreadSafeTimerContainer;

public class ThreadSafeTimerContainerTest {
    private ThreadSafeTimerContainer container;

    @Before
    public void init() {
        this.container = new ThreadSafeTimerContainer("");
    }

    @Test
    public void singleTimer() {
        ThreadSafeTimerContainer.TimerWrapper timer = this.container.getNewTimer();
        for (int i = 0; i < 5; ++i) {
            this.checkIntervalNum(i);
            timer.start();
            this.checkIntervalNum(i + 1);
            timer.stop();
            this.checkIntervalNum(i + 1);
        }
    }

    @Test
    public void multipleTimer() {
        for (int i = 0; i < 5; ++i) {
            ThreadSafeTimerContainer.TimerWrapper timer = this.container.getNewTimer();
            this.checkIntervalNum(i);
            timer.start();
            this.checkIntervalNum(i + 1);
            timer.stop();
            this.checkIntervalNum(i + 1);
        }
    }

    @Test
    public void multipleTimerInterleaved() {
        ThreadSafeTimerContainer.TimerWrapper timer = this.container.getNewTimer();
        for (int i = 0; i < 5; ++i) {
            ThreadSafeTimerContainer.TimerWrapper timer2 = this.container.getNewTimer();
            this.checkIntervalNum(2 * i);
            timer.start();
            this.checkIntervalNum(2 * i + 1);
            timer2.start();
            this.checkIntervalNum(2 * i + 2);
            timer.stop();
            this.checkIntervalNum(2 * i + 2);
            timer2.stop();
            this.checkIntervalNum(2 * i + 2);
        }
    }

    @Test
    public void multipleTimerInterleaved2() {
        ThreadSafeTimerContainer.TimerWrapper timer = this.container.getNewTimer();
        ThreadSafeTimerContainer.TimerWrapper timer1 = this.container.getNewTimer();
        for (int i = 0; i < 5; ++i) {
            ThreadSafeTimerContainer.TimerWrapper timer2 = this.container.getNewTimer();
            this.checkIntervalNum(3 * i);
            timer.start();
            this.checkIntervalNum(3 * i + 1);
            timer1.start();
            this.checkIntervalNum(3 * i + 2);
            timer1.stop();
            this.checkIntervalNum(3 * i + 2);
            timer2.start();
            this.checkIntervalNum(3 * i + 3);
            timer2.stop();
            this.checkIntervalNum(3 * i + 3);
            timer.stop();
            this.checkIntervalNum(3 * i + 3);
        }
    }

    private void checkIntervalNum(int num) {
        Truth.assert_().withMessage("number of intervals does not match").that(Integer.valueOf(this.container.getNumberOfIntervals())).isEqualTo((Object)num);
    }
}

