/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.templates;

import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.sosy_lab.common.rationals.LinearExpression;
import org.sosy_lab.common.rationals.Rational;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;

public final class Template {
    private final LinearExpression<CIdExpression> linearExpression;

    public Collection<String> getUsedVars() {
        return Collections2.transform((Collection)this.linearExpression.getMap().keySet(), s -> s.getDeclaration().getQualifiedName());
    }

    private Template(LinearExpression<CIdExpression> pLinearExpression) {
        this.linearExpression = pLinearExpression;
    }

    public Kind getKind() {
        return Template.getKind(this.linearExpression);
    }

    public LinearExpression<CIdExpression> getLinearExpression() {
        return this.linearExpression;
    }

    public boolean isUnsigned() {
        for (Map.Entry e : this.linearExpression) {
            CIdExpression expr = (CIdExpression)e.getKey();
            CSimpleType type = (CSimpleType)expr.getExpressionType();
            if (type.isUnsigned()) continue;
            return false;
        }
        return true;
    }

    public boolean isIntegral() {
        for (Map.Entry e : this.linearExpression) {
            Rational coeff = (Rational)e.getValue();
            CIdExpression id = (CIdExpression)e.getKey();
            if (coeff.isIntegral() && ((CSimpleType)id.getExpressionType()).getType().isIntegerType()) continue;
            return false;
        }
        return true;
    }

    public static Template of(LinearExpression<CIdExpression> expr) {
        return new Template(expr);
    }

    private static Kind getKind(LinearExpression<CIdExpression> expr) {
        int s = expr.size();
        if (s == 1 && Objects.equals(((Map.Entry)Iterables.getOnlyElement(expr)).getValue(), Rational.ONE)) {
            return Kind.UPPER_BOUND;
        }
        if (s == 1 && Objects.equals(((Map.Entry)Iterables.getOnlyElement(expr)).getValue(), Rational.NEG_ONE)) {
            return Kind.NEG_LOWER_BOUND;
        }
        if (s == 2) {
            Iterator it = expr.iterator();
            Rational a = (Rational)((Map.Entry)it.next()).getValue();
            Rational b = (Rational)((Map.Entry)it.next()).getValue();
            if (Objects.equals(a, Rational.ONE) && Objects.equals(b, Rational.ONE)) {
                return Kind.SUM;
            }
            if (Objects.equals(a, Rational.NEG_ONE) && Objects.equals(b, Rational.NEG_ONE)) {
                return Kind.NEG_SUM_LOWER_BOUND;
            }
            if (Objects.equals(a, Rational.ONE) && Objects.equals(b, Rational.NEG_ONE) || Objects.equals(a, Rational.NEG_ONE) && Objects.equals(b, Rational.ONE)) {
                return Kind.DIFFERENCE;
            }
        }
        return Kind.COMPLEX;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        Template other = (Template)o;
        return this.linearExpression.equals(other.linearExpression);
    }

    public int hashCode() {
        return this.linearExpression.hashCode();
    }

    public int size() {
        return this.linearExpression.size();
    }

    public String toString() {
        HashMap<String, CIdExpression> mapping = new HashMap<String, CIdExpression>();
        ArrayList<String> varNames = new ArrayList<String>();
        for (Map.Entry monomial : this.linearExpression) {
            CIdExpression key = (CIdExpression)monomial.getKey();
            String varName = key.getDeclaration().getQualifiedName();
            mapping.put(varName, key);
            varNames.add(varName);
        }
        Collections.sort(varNames);
        StringBuilder b = new StringBuilder();
        for (String varName : varNames) {
            Rational coeff = this.linearExpression.getCoeff((Object)((CIdExpression)mapping.get(varName)));
            LinearExpression.writeMonomial((String)varName, (Rational)coeff, (StringBuilder)b);
        }
        return b.toString();
    }

    public static enum Kind {
        UPPER_BOUND,
        NEG_LOWER_BOUND,
        SUM,
        DIFFERENCE,
        NEG_SUM_LOWER_BOUND,
        COMPLEX;

    }
}

