/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.templates;

import com.google.common.base.Equivalence;
import com.google.common.collect.Collections2;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.stream.Stream;
import org.sosy_lab.common.collect.Collections3;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.rationals.LinearExpression;
import org.sosy_lab.common.rationals.Rational;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.ast.ASimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CLeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CSimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CStatement;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.c.CAssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.c.CReturnStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CStatementEdge;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.LiveVariables;
import org.sosy_lab.cpachecker.util.templates.Template;
import org.sosy_lab.cpachecker.util.templates.TemplateToFormulaConversionManager;

@Options(prefix="precision.template", deprecatedPrefix="cpa.lpi")
public class TemplatePrecision
implements Precision {
    private static final Comparator<Template> TEMPLATE_COMPARATOR = Comparator.comparingInt(template -> template.getLinearExpression().size()).thenComparingInt(t -> t.toString().trim().startsWith("-") ? 1 : 0).thenComparing(Template::toString);
    @Option(secure=true, description="Generate templates from assert statements")
    private boolean generateFromAsserts = true;
    @Option(secure=true, description="Generate templates from all program statements")
    private boolean generateFromStatements = false;
    @Option(secure=true, description="Maximum size for the generated template")
    private int maxExpressionSize = 1;
    @Option(secure=true, description="Perform refinement using enumerative template synthesis.")
    private boolean performEnumerativeRefinement = true;
    @Option(secure=true, description="Generate difference constraints.This option is redundant for `maxExpressionSize` >= 2.")
    private boolean generateDifferences = false;
    @Option(secure=true, description="Allowed coefficients in a template.")
    private ImmutableSet<Rational> allowedCoefficients = ImmutableSet.of((Object)Rational.NEG_ONE, (Object)Rational.ONE);
    @Option(secure=true, description="Strategy for filtering variables out of templates using liveness")
    private VarFilteringStrategy varFiltering = VarFilteringStrategy.ALL_LIVE;
    @Option(secure=true, description="Do not generate templates with threshold larger than specified. Set to '-1' for no limit.")
    private long templateConstantThreshold = 100L;
    @Option(secure=true, description="Force the inclusion of function parameters into the generated templates. Required for summaries computation.")
    private boolean includeFunctionParameters = false;
    private final CFA cfa;
    private final LogManager logger;
    private final ImmutableSet<Template> extractedFromAssertTemplates;
    private ImmutableSet<Template> extractedTemplates;
    private final Set<Template> extraTemplates;
    private final Set<Template> generatedTemplates;
    private final Multimap<CFANode, ASimpleDeclaration> varsInInterpolant;
    private final TemplateToFormulaConversionManager templateToFormulaConversionManager;
    private static final String TMP_VARIABLE = "__CPAchecker_TMP";
    private static final String ASSERT_FUNC_NAME = "assert";
    private static final String ASSERT_H_FUNC_NAME = "__assert_fail";
    private final Map<CFANode, ImmutableList<Template>> cache = new HashMap<CFANode, ImmutableList<Template>>();
    private final ImmutableSet<ASimpleDeclaration> allVariables;
    private final ImmutableSetMultimap<String, ASimpleDeclaration> functionParameters;
    private static final Equivalence<CIdExpression> BASIC_TYPE_EQUIVALENCE = Equivalence.equals().onResultOf(x -> ((CSimpleType)x.getDeclaration().getType()).getType());

    public TemplatePrecision(LogManager pLogger, Configuration pConfig, CFA pCfa, TemplateToFormulaConversionManager pTemplateToFormulaConversionManager) throws InvalidConfigurationException {
        this.templateToFormulaConversionManager = pTemplateToFormulaConversionManager;
        pConfig.inject((Object)this, TemplatePrecision.class);
        this.extraTemplates = new HashSet<Template>();
        this.cfa = pCfa;
        this.logger = pLogger;
        this.allowedCoefficients = FluentIterable.from(this.allowedCoefficients).filter(c -> !c.equals((Object)Rational.ZERO)).toSet();
        this.extractedFromAssertTemplates = this.generateFromAsserts ? ImmutableSet.copyOf(this.templatesFromAsserts()) : ImmutableSet.of();
        this.logger.log(Level.FINE, new Object[]{"Generated from assert templates", this.extractedFromAssertTemplates});
        this.extractedTemplates = this.generateFromStatements ? this.extractTemplates() : ImmutableSet.of();
        this.logger.log(Level.FINE, new Object[]{"Generated templates", this.extractedFromAssertTemplates});
        this.generatedTemplates = new HashSet<Template>();
        this.allVariables = ImmutableSet.copyOf(this.cfa.getLiveVariables().orElseThrow().getAllLiveVariables());
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        if (this.includeFunctionParameters) {
            for (FunctionEntryNode node : this.cfa.getAllFunctionHeads()) {
                CFunctionEntryNode casted = (CFunctionEntryNode)node;
                casted.getFunctionParameters().stream().map(p -> p.asVariableDeclaration()).forEach(qualifiedName -> builder.put((Object)node.getFunctionName(), qualifiedName));
            }
        }
        this.functionParameters = builder.build();
        this.varsInInterpolant = HashMultimap.create();
    }

    public ImmutableList<Template> getTemplatesForNode(CFANode node) {
        if (this.cache.containsKey(node)) {
            return this.cache.get(node);
        }
        ImmutableSet vars = (ImmutableSet)this.getVarsForNode(node).stream().filter(this::shouldProcessVariable).map(d -> new CIdExpression(FileLocation.DUMMY, (CSimpleDeclaration)d)).collect(ImmutableSet.toImmutableSet());
        Stream<Template> out = Streams.concat((Stream[])new Stream[]{this.extractTemplatesForNode(node), this.extraTemplates.stream(), this.extractedFromAssertTemplates.stream(), this.generateTemplates((ImmutableSet<CIdExpression>)vars)});
        if (this.generateDifferences) {
            out = Stream.concat(out, this.generateDifferenceTemplates((Collection<CIdExpression>)vars));
        }
        if (this.varFiltering == VarFilteringStrategy.ONE_LIVE) {
            out = out.filter(input -> this.shouldUseTemplate((Template)input, node));
        }
        ImmutableList sortedTemplates = (ImmutableList)((Stream)out.unordered()).distinct().sorted(TEMPLATE_COMPARATOR).collect(ImmutableList.toImmutableList());
        this.cache.put(node, (ImmutableList<Template>)sortedTemplates);
        return sortedTemplates;
    }

    private Stream<Template> generateTemplates(ImmutableSet<CIdExpression> vars) {
        int maxLength = Math.min(this.maxExpressionSize, vars.size());
        assert (!this.allowedCoefficients.contains((Object)Rational.ZERO));
        List<ImmutableSet<CIdExpression>> lists = Collections.nCopies(maxLength, vars);
        Set product = Sets.cartesianProduct(lists);
        return product.stream().map(HashSet::new).distinct().flatMap(variables -> {
            ImmutableList out = Collections3.transformedImmutableListCopy((Collection)variables, x -> Collections3.transformedImmutableListCopy(this.allowedCoefficients, coeff -> LinearExpression.monomial((Object)x, (Rational)coeff)));
            Stream<LinearExpression<CIdExpression>> linearExpressions = Lists.cartesianProduct((List)out).stream().map(l -> l.stream().reduce(LinearExpression.empty(), LinearExpression::add));
            return this.filterRedundantExpressions(linearExpressions).filter(this::hasSameType).filter(t -> !t.isEmpty()).map(Template::of);
        });
    }

    private Stream<Template> generateDifferenceTemplates(Collection<CIdExpression> vars) {
        Collection varExpression = Collections2.transform(vars, LinearExpression::ofVariable);
        return varExpression.stream().flatMap(v1 -> varExpression.stream().map(v2 -> v1.sub(v2))).filter(this::hasSameType).filter(t -> !t.isEmpty()).map(Template::of);
    }

    private Stream<LinearExpression<CIdExpression>> filterRedundantExpressions(Stream<LinearExpression<CIdExpression>> pLinearExpressions) {
        Predicate<Optional> existsAndMoreThanOne = coeff -> coeff.isPresent() && ((Rational)coeff.orElseThrow()).compareTo(Rational.ONE) > 0;
        Set linearExpressions = (Set)pLinearExpressions.collect(ImmutableSet.toImmutableSet());
        return linearExpressions.stream().filter(l -> linearExpressions.stream().noneMatch(l2 -> l2 != l && existsAndMoreThanOne.test(l2.divide(l))));
    }

    private boolean hasSameType(LinearExpression<CIdExpression> expr) {
        return expr.getMap().keySet().stream().allMatch(x -> BASIC_TYPE_EQUIVALENCE.equivalent(x, (Object)((CIdExpression)((Map.Entry)expr.iterator().next()).getKey())));
    }

    private boolean shouldProcessVariable(ASimpleDeclaration var) {
        return !var.getQualifiedName().contains(TMP_VARIABLE) && var.getType() instanceof CSimpleType && !var.getType().toString().contains("*");
    }

    private Set<Template> templatesFromAsserts() {
        HashSet<Template> templates = new HashSet<Template>();
        for (CFANode node : this.cfa.getAllNodes()) {
            for (CFAEdge edge : CFAUtils.leavingEdges(node)) {
                String statement = edge.getRawStatement();
                Optional<Object> template = Optional.empty();
                if (statement.contains(ASSERT_H_FUNC_NAME) && edge instanceof CStatementEdge) {
                    for (CFAEdge enteringEdge : CFAUtils.enteringEdges(node)) {
                        if (!(enteringEdge instanceof CAssumeEdge)) continue;
                        CAssumeEdge assumeEdge = (CAssumeEdge)enteringEdge;
                        CExpression expression = assumeEdge.getExpression();
                        template = this.expressionToSingleTemplate(expression);
                    }
                } else if (statement.contains(ASSERT_FUNC_NAME) && edge instanceof CFunctionCallEdge) {
                    CFunctionCallEdge callEdge = (CFunctionCallEdge)edge;
                    if (callEdge.getArguments().isEmpty()) continue;
                    CExpression expression = callEdge.getArguments().get(0);
                    template = this.expressionToSingleTemplate(expression);
                }
                template.filter(t -> !t.isEmpty()).ifPresent(t -> {
                    templates.add(Template.of((LinearExpression<CIdExpression>)t));
                    templates.add(Template.of((LinearExpression<CIdExpression>)t.negate()));
                });
            }
        }
        return templates;
    }

    private Stream<Template> extractTemplatesForNode(CFANode node) {
        return this.extractedTemplates.stream().filter(t -> this.shouldUseTemplate((Template)t, node));
    }

    private boolean shouldUseTemplate(Template t, CFANode node) {
        if (this.varFiltering == VarFilteringStrategy.ALL) {
            return true;
        }
        LiveVariables liveVariables = this.cfa.getLiveVariables().orElseThrow();
        for (Map.Entry e : t.getLinearExpression()) {
            CIdExpression id = (CIdExpression)e.getKey();
            if (this.varFiltering == VarFilteringStrategy.ONE_LIVE && !liveVariables.isVariableLive(id.getDeclaration(), node)) {
                return true;
            }
            if (this.varFiltering != VarFilteringStrategy.ALL_LIVE || liveVariables.isVariableLive(id.getDeclaration(), node) || this.functionParameters.containsEntry((Object)node.getFunctionName(), (Object)id.getDeclaration())) continue;
            return false;
        }
        return true;
    }

    private ImmutableSet<Template> extractTemplates() {
        return (ImmutableSet)this.cfa.getAllNodes().stream().flatMap(node -> CFAUtils.allEnteringEdges(node).stream()).flatMap(edge -> this.extractTemplatesFromEdge((CFAEdge)edge).stream()).filter(t -> t.size() >= 1).map(Template::of).collect(ImmutableSet.toImmutableSet());
    }

    private Collection<LinearExpression<CIdExpression>> extractTemplatesFromEdge(CFAEdge edge) {
        switch (edge.getEdgeType()) {
            case ReturnStatementEdge: {
                CReturnStatementEdge e = (CReturnStatementEdge)edge;
                if (!e.getExpression().isPresent()) break;
                return this.expressionToTemplate(e.getExpression().orElseThrow());
            }
            case FunctionCallEdge: {
                CFunctionCallEdge callEdge = (CFunctionCallEdge)edge;
                return FluentIterable.from(callEdge.getArguments()).transformAndConcat(this::expressionToTemplate).toSet();
            }
            case AssumeEdge: {
                CAssumeEdge assumeEdge = (CAssumeEdge)edge;
                return this.expressionToTemplate(assumeEdge.getExpression());
            }
            case StatementEdge: {
                return this.extractTemplatesFromStatementEdge((CStatementEdge)edge);
            }
        }
        return ImmutableSet.of();
    }

    private Collection<LinearExpression<CIdExpression>> extractTemplatesFromStatementEdge(CStatementEdge edge) {
        CStatement statement = edge.getStatement();
        if (statement instanceof CExpressionStatement) {
            return this.expressionToTemplate(((CExpressionStatement)statement).getExpression());
        }
        if (statement instanceof CExpressionAssignmentStatement) {
            HashSet<LinearExpression<CIdExpression>> out = new HashSet<LinearExpression<CIdExpression>>();
            CExpressionAssignmentStatement assignment = (CExpressionAssignmentStatement)statement;
            CLeftHandSide lhs = assignment.getLeftHandSide();
            if (lhs instanceof CIdExpression) {
                CIdExpression id = (CIdExpression)lhs;
                out.addAll(this.expressionToTemplate(assignment.getRightHandSide()));
                if (!this.shouldProcessVariable(id.getDeclaration())) {
                    return out;
                }
                this.expressionToSingleTemplate(assignment.getRightHandSide()).ifPresent(t -> out.add(LinearExpression.ofVariable((Object)id).sub(t)));
            }
            return out;
        }
        return ImmutableList.of();
    }

    private Collection<LinearExpression<CIdExpression>> expressionToTemplate(CExpression expression) {
        Optional<LinearExpression<CIdExpression>> t = this.expressionToSingleTemplate(expression);
        return t.isPresent() ? ImmutableList.of(t.orElseThrow(), (Object)t.orElseThrow().negate()) : ImmutableList.of();
    }

    private Optional<LinearExpression<CIdExpression>> expressionToSingleTemplate(CExpression expression) {
        return this.recExpressionToTemplate(expression).filter(t -> !t.isEmpty());
    }

    private Optional<LinearExpression<CIdExpression>> recExpressionToTemplate(CExpression expression) {
        if (expression instanceof CBinaryExpression) {
            CBinaryExpression binaryExpression = (CBinaryExpression)expression;
            CExpression operand1 = binaryExpression.getOperand1();
            CExpression operand2 = binaryExpression.getOperand2();
            CBinaryExpression.BinaryOperator operator = binaryExpression.getOperator();
            Optional<LinearExpression<CIdExpression>> templateA = this.recExpressionToTemplate(operand1);
            Optional<LinearExpression<CIdExpression>> templateB = this.recExpressionToTemplate(operand2);
            if (operator == CBinaryExpression.BinaryOperator.MULTIPLY && (templateA.isPresent() || templateB.isPresent())) {
                if (operand1 instanceof CIntegerLiteralExpression && templateB.isPresent()) {
                    return Optional.of(this.useCoeff((CIntegerLiteralExpression)operand1, templateB.orElseThrow()));
                }
                if (operand2 instanceof CIntegerLiteralExpression && templateA.isPresent()) {
                    return Optional.of(this.useCoeff((CIntegerLiteralExpression)operand2, templateA.orElseThrow()));
                }
                return Optional.empty();
            }
            if (templateA.isPresent() && templateB.isPresent() && binaryExpression.getCalculationType() instanceof CSimpleType) {
                LinearExpression<CIdExpression> a = templateA.orElseThrow();
                LinearExpression<CIdExpression> b = templateB.orElseThrow();
                LinearExpression t = operator == CBinaryExpression.BinaryOperator.PLUS ? a.add(b) : a.sub(b);
                return Optional.of(t);
            }
            return Optional.empty();
        }
        if (expression instanceof CLiteralExpression && expression.getExpressionType() instanceof CSimpleType) {
            return Optional.of(LinearExpression.empty());
        }
        if (expression instanceof CIdExpression && expression.getExpressionType() instanceof CSimpleType) {
            CIdExpression idExpression = (CIdExpression)expression;
            return Optional.of(LinearExpression.ofVariable((Object)idExpression));
        }
        return Optional.empty();
    }

    private LinearExpression<CIdExpression> useCoeff(CIntegerLiteralExpression literal, LinearExpression<CIdExpression> other) {
        Rational coeff = Rational.ofBigInteger((BigInteger)literal.getValue());
        return other.multByConst(coeff);
    }

    public void addGeneratedTemplates(Set<Template> templates) {
        this.generatedTemplates.addAll(templates);
    }

    public boolean injectPrecisionFromInterpolant(CFANode pNode, Set<String> usedVars) {
        LiveVariables liveVars = this.cfa.getLiveVariables().orElseThrow();
        ImmutableMap map = Maps.uniqueIndex(liveVars.getAllLiveVariables(), ASimpleDeclaration::getQualifiedName);
        List out = (List)usedVars.stream().filter(arg_0 -> TemplatePrecision.lambda$injectPrecisionFromInterpolant$28((Map)map, arg_0)).map(arg_0 -> TemplatePrecision.lambda$injectPrecisionFromInterpolant$29((Map)map, arg_0)).collect(ImmutableList.toImmutableList());
        boolean returned = this.varsInInterpolant.putAll((Object)pNode, (Iterable)out);
        this.logger.log(Level.FINE, new Object[]{"Generated vars", out});
        this.logger.log(Level.FINE, new Object[]{"Got input", usedVars});
        if (returned) {
            this.cache.remove(pNode);
        }
        return returned;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean adjustPrecision() {
        boolean changed = false;
        for (Template t : this.generatedTemplates) {
            changed |= this.addTemplateToExtra(t);
        }
        try {
            if (changed) {
                this.logger.log(Level.INFO, new Object[]{"Template Refinement: using templates generated with convex hull", this.generatedTemplates});
                this.generatedTemplates.clear();
                boolean bl = true;
                return bl;
            }
            if (!this.generateFromStatements) {
                this.logger.log(Level.INFO, new Object[]{"Template Refinement: Generating templates from all program statements."});
                this.generateFromStatements = true;
                this.extractedTemplates = this.extractTemplates();
                boolean bl = true;
                return bl;
            }
            if (!this.performEnumerativeRefinement) {
                boolean bl = false;
                return bl;
            }
            if (this.maxExpressionSize == 1) {
                this.logger.log(Level.INFO, new Object[]{"Template Refinement: Generating octagons"});
                this.maxExpressionSize = 2;
                boolean bl = true;
                return bl;
            }
            if (this.maxExpressionSize == 2 && !this.allowedCoefficients.contains((Object)Rational.ofLong((long)2L))) {
                this.logger.log(Level.INFO, new Object[]{"Template Refinement: increasing the coefficient size to 2"});
                this.allowedCoefficients = FluentIterable.from(this.allowedCoefficients).append((Object[])new Rational[]{Rational.ofLong((long)2L), Rational.ofLong((long)-2L)}).toSet();
                boolean bl = true;
                return bl;
            }
            if (this.maxExpressionSize == 2 && this.allowedCoefficients.contains((Object)Rational.ofLong((long)2L))) {
                this.logger.log(Level.INFO, new Object[]{"Template Refinement: increasing the expression size to 3"});
                this.maxExpressionSize = 3;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.cache.clear();
        }
    }

    private boolean addTemplateToExtra(Template t) {
        return this.shouldAddTemplate(t) && this.extraTemplates.add(t);
    }

    private boolean shouldAddTemplate(Template t) {
        if (t.size() == 1) {
            return false;
        }
        for (Map.Entry e : t.getLinearExpression()) {
            if (this.templateToFormulaConversionManager.isOverflowing(t, (Rational)e.getValue())) {
                return false;
            }
            if (this.templateConstantThreshold == -1L || ((Rational)e.getValue()).abs().compareTo(Rational.ofLong((long)this.templateConstantThreshold)) <= 0) continue;
            return false;
        }
        return true;
    }

    private Collection<ASimpleDeclaration> getVarsForNode(CFANode node) {
        if (this.varFiltering == VarFilteringStrategy.ALL_LIVE) {
            return Sets.union(this.cfa.getLiveVariables().orElseThrow().getLiveVariablesForNode(node), (Set)this.functionParameters.get((Object)node.getFunctionName()));
        }
        if (this.varFiltering == VarFilteringStrategy.INTERPOLATION_BASED) {
            return this.varsInInterpolant.get((Object)node);
        }
        return this.allVariables;
    }

    private static /* synthetic */ ASimpleDeclaration lambda$injectPrecisionFromInterpolant$29(Map map, String v) {
        return (ASimpleDeclaration)map.get(v);
    }

    private static /* synthetic */ boolean lambda$injectPrecisionFromInterpolant$28(Map map, String v) {
        return map.containsKey(v);
    }

    public static enum VarFilteringStrategy {
        INTERPOLATION_BASED,
        ALL_LIVE,
        ONE_LIVE,
        ALL;

    }
}

