/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.templates;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.rationals.Rational;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpressionBuilder;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSide;
import org.sosy_lab.cpachecker.cfa.model.BlankEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCodeException;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormula;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.cpachecker.util.templates.Template;
import org.sosy_lab.java_smt.api.BitvectorFormula;
import org.sosy_lab.java_smt.api.Formula;

public final class TemplateToFormulaConversionManager {
    private final CFA cfa;
    private static final CFAEdge dummyEdge = new BlankEdge("", FileLocation.DUMMY, CFANode.newDummyCFANode("dummy-1"), CFANode.newDummyCFANode("dummy-2"), "Dummy Edge");
    private final Map<ToFormulaCacheKey, Formula> toFormulaCache = new HashMap<ToFormulaCacheKey, Formula>();
    private final CBinaryExpressionBuilder expressionBuilder;

    public TemplateToFormulaConversionManager(CFA pCfa, LogManager logger) {
        this.cfa = pCfa;
        this.expressionBuilder = new CBinaryExpressionBuilder(this.cfa.getMachineModel(), logger);
    }

    public Formula toFormula(PathFormulaManager pfmgr, FormulaManagerView fmgr, Template template, PathFormula contextFormula) {
        ToFormulaCacheKey key = new ToFormulaCacheKey(pfmgr, fmgr, template, contextFormula);
        Formula out = this.toFormulaCache.get(key);
        if (out != null) {
            return out;
        }
        Formula sum = null;
        int maxBitvectorSize = this.getBitvectorSize(template, pfmgr, contextFormula, fmgr);
        for (Map.Entry entry : template.getLinearExpression()) {
            Formula item;
            Rational coeff = (Rational)entry.getValue();
            CIdExpression declaration = (CIdExpression)entry.getKey();
            try {
                Formula f = pfmgr.expressionToFormula(contextFormula, declaration, dummyEdge);
                item = this.normalizeLength(f, maxBitvectorSize, fmgr);
            }
            catch (UnrecognizedCodeException e) {
                throw new UnsupportedOperationException();
            }
            if (coeff.equals((Object)Rational.ZERO)) continue;
            Formula multipliedItem = coeff.equals((Object)Rational.NEG_ONE) ? fmgr.makeNegate(item) : (coeff.equals((Object)Rational.ONE) ? item : fmgr.makeMultiply(item, fmgr.makeNumber(item, (Rational)entry.getValue())));
            if (sum == null) {
                sum = multipliedItem;
                continue;
            }
            sum = fmgr.makePlus(sum, multipliedItem);
        }
        assert (sum != null);
        this.toFormulaCache.put(key, sum);
        return sum;
    }

    public boolean isOverflowing(Template template, Rational v) {
        CSimpleType templateType = this.getTemplateType(template);
        if (templateType.getType().isIntegerType()) {
            BigInteger maxValue = this.cfa.getMachineModel().getMaximalIntegerValue(templateType);
            BigInteger minValue = this.cfa.getMachineModel().getMinimalIntegerValue(templateType);
            if (v.compareTo(Rational.ofBigInteger((BigInteger)maxValue)) > 0 || v.compareTo(Rational.ofBigInteger((BigInteger)minValue)) < 0) {
                return true;
            }
        }
        return false;
    }

    private CSimpleType getTemplateType(Template t) {
        CRightHandSide sum = null;
        for (Map.Entry e : t.getLinearExpression()) {
            CIdExpression expr = (CIdExpression)e.getKey();
            if (sum == null) {
                sum = expr;
                continue;
            }
            sum = this.expressionBuilder.buildBinaryExpressionUnchecked((CExpression)sum, expr, CBinaryExpression.BinaryOperator.PLUS);
        }
        assert (sum != null);
        return (CSimpleType)sum.getExpressionType();
    }

    private int getBitvectorSize(Template t, PathFormulaManager pfmgr, PathFormula contextFormula, FormulaManagerView fmgr) {
        int length = 0;
        for (Map.Entry entry : t.getLinearExpression()) {
            Formula item;
            try {
                item = pfmgr.expressionToFormula(contextFormula, (CIdExpression)entry.getKey(), dummyEdge);
            }
            catch (UnrecognizedCodeException e) {
                throw new UnsupportedOperationException();
            }
            if (!(item instanceof BitvectorFormula)) continue;
            BitvectorFormula b = (BitvectorFormula)item;
            length = Math.max(fmgr.getBitvectorFormulaManager().getLength(b), length);
        }
        return length;
    }

    private Formula normalizeLength(Formula f, int maxBitvectorSize, FormulaManagerView fmgr) {
        if (!(f instanceof BitvectorFormula)) {
            return f;
        }
        BitvectorFormula bv = (BitvectorFormula)f;
        return fmgr.getBitvectorFormulaManager().extend(bv, Math.max(0, maxBitvectorSize - fmgr.getBitvectorFormulaManager().getLength(bv)), true);
    }

    private static class ToFormulaCacheKey {
        private final PathFormulaManager pathFormulaManager;
        private final FormulaManagerView formulaManagerView;
        private final Template template;
        private final PathFormula contextFormula;

        private ToFormulaCacheKey(PathFormulaManager pPathFormulaManager, FormulaManagerView pFormulaManagerView, Template pTemplate, PathFormula pContextFormula) {
            this.pathFormulaManager = pPathFormulaManager;
            this.formulaManagerView = pFormulaManagerView;
            this.template = pTemplate;
            this.contextFormula = pContextFormula;
        }

        public boolean equals(Object pO) {
            if (this == pO) {
                return true;
            }
            if (!(pO instanceof ToFormulaCacheKey)) {
                return false;
            }
            ToFormulaCacheKey that = (ToFormulaCacheKey)pO;
            return this.pathFormulaManager == that.pathFormulaManager && this.formulaManagerView == that.formulaManagerView && Objects.equals(this.template, that.template) && Objects.equals(this.contextFormula, that.contextFormula);
        }

        public int hashCode() {
            return Objects.hash(this.pathFormulaManager, this.formulaManagerView, this.template, this.contextFormula);
        }

        public String toString() {
            return "ToFormulaCacheKey{pathFormulaManager=" + this.pathFormulaManager + ", formulaManagerView=" + this.formulaManagerView + ", template=" + this.template + ", contextFormula=" + this.contextFormula + "}";
        }
    }
}

