/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.test;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.truth.Truth;
import java.io.IOException;
import java.nio.file.Path;
import java.util.logging.Handler;
import java.util.logging.Level;
import org.junit.Ignore;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.sosy_lab.common.ProcessExecutor;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.io.TempFile;
import org.sosy_lab.common.log.BasicLogManager;
import org.sosy_lab.common.log.ConsoleLogFormatter;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.log.StringBuildingLogHandler;
import org.sosy_lab.cpachecker.cfa.CFACreator;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.exceptions.ParserException;
import org.sosy_lab.cpachecker.util.test.CPATestRunner;
import org.sosy_lab.cpachecker.util.test.TestResults;

@Ignore(value="prevent this abstract class being executed as testcase by ant")
@RunWith(value=Parameterized.class)
public abstract class AbstractTranslationTest {
    public static final String TEST_DIR_PATH = "test/programs/programtranslation/";
    private static final String COMPILER = "gcc";
    private static final String PARAM_NO_LINKING = "-c";
    protected String filePrefix = "tmp";
    protected final LogManager logger;

    protected AbstractTranslationTest() {
        StringBuildingLogHandler stringLogHandler = new StringBuildingLogHandler();
        stringLogHandler.setLevel(Level.ALL);
        stringLogHandler.setFormatter(ConsoleLogFormatter.withoutColors());
        this.logger = BasicLogManager.createWithHandler((Handler)stringLogHandler);
    }

    protected Path newTempFile() throws IOException {
        return TempFile.builder().prefix(this.filePrefix).suffix(".spc").create().toAbsolutePath();
    }

    protected static TestResults run0(Configuration config, Path program) throws Exception {
        TestResults results;
        try {
            results = CPATestRunner.run(config, program.toString());
        }
        catch (NoClassDefFoundError | UnsatisfiedLinkError e) {
            throw new AssertionError((Object)e);
        }
        return results;
    }

    protected static ARGState run(Configuration config, Path program) throws Exception {
        TestResults results = AbstractTranslationTest.run0(config, program);
        ReachedSet reached = results.getCheckerResult().getReached();
        Truth.assert_().withMessage("reached set: %s\nlog: %s\nfirst state of reached set", new Object[]{reached, results.getLog()}).that((Object)reached.getFirstState()).isNotNull();
        return (ARGState)reached.getFirstState();
    }

    protected static void check(Configuration config, Path program, boolean expectedVerdict) throws Exception {
        TestResults results = AbstractTranslationTest.run0(config, program);
        if (expectedVerdict) {
            results.assertIsSafe();
        } else {
            results.assertIsUnsafe();
        }
    }

    protected static void checkProgramValid(Path program) throws InterruptedException, InvalidConfigurationException {
        LogManager logger = LogManager.createTestLogManager();
        ShutdownNotifier shutdown = ShutdownNotifier.createDummy();
        Configuration parseConfig = Configuration.builder().setOption("analysis.useLoopStructure", "false").build();
        CFACreator cfaCreator = new CFACreator(parseConfig, logger, shutdown);
        try {
            cfaCreator.parseFileAndCreateCFA(Lists.newArrayList((Object[])new String[]{program.toString()}));
        }
        catch (IOException | ParserException e) {
            throw new AssertionError((Object)e);
        }
    }

    protected static void checkProgramCompilable(Path program) throws IOException, InterruptedException {
        LogManager logger = LogManager.createTestLogManager();
        ImmutableList compileCommandList = ImmutableList.of((Object)COMPILER, (Object)PARAM_NO_LINKING, (Object)"-o", (Object)"/dev/null", (Object)program.toString());
        String[] compileCommand = compileCommandList.toArray(new String[0]);
        CompilerExecutor exec = new CompilerExecutor(logger, compileCommand);
        int returnCode = exec.join();
        Truth.assertThat((Integer)returnCode).isEqualTo((Object)0);
    }

    private static class CompilerExecutor
    extends ProcessExecutor<IOException> {
        public CompilerExecutor(LogManager pLogger, String ... cmd) throws IOException {
            super(pLogger, IOException.class, cmd);
        }
    }
}

