/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.test;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import java.util.logging.Handler;
import java.util.logging.Level;
import org.sosy_lab.common.ShutdownManager;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.log.BasicLogManager;
import org.sosy_lab.common.log.ConsoleLogFormatter;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.log.StringBuildingLogHandler;
import org.sosy_lab.cpachecker.core.CPAchecker;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.util.test.TestDataTools;
import org.sosy_lab.cpachecker.util.test.TestResults;

public class CPATestRunner {
    public static TestResults run(Map<String, String> pProperties, String pSourceCodeFilePath) throws Exception {
        Configuration config = TestDataTools.configurationForTest().setOptions(pProperties).build();
        return CPATestRunner.run(config, pSourceCodeFilePath);
    }

    public static TestResults run(Configuration config, String pSourceCodeFilePath) throws Exception {
        return CPATestRunner.run(config, pSourceCodeFilePath, Level.INFO);
    }

    public static TestResults run(Configuration config, String pSourceCodeFilePath, Level logLevel) throws Exception {
        StringBuildingLogHandler stringLogHandler = new StringBuildingLogHandler();
        stringLogHandler.setLevel(logLevel);
        stringLogHandler.setFormatter(ConsoleLogFormatter.withoutColors());
        LogManager logger = BasicLogManager.createWithHandler((Handler)stringLogHandler);
        ShutdownManager shutdownManager = ShutdownManager.create();
        CPAchecker cpaChecker = new CPAchecker(config, logger, shutdownManager);
        CPAcheckerResult results = cpaChecker.run((List<String>)ImmutableList.of((Object)pSourceCodeFilePath));
        logger.flush();
        return new TestResults(stringLogHandler.getLog(), results);
    }

    public static enum ExpectedVerdict {
        TRUE,
        FALSE,
        NONE;

    }
}

