/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.test;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.HashMap;
import org.junit.rules.TemporaryFolder;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.ConfigurationBuilder;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.converters.FileTypeConverter;
import org.sosy_lab.common.configuration.converters.TypeConverter;
import org.sosy_lab.common.io.IO;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.CFACreator;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.c.CDeclarationEdge;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.cfa.types.c.CStorageClass;
import org.sosy_lab.cpachecker.exceptions.ParserException;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormula;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMap;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.PointerTargetSet;

public class TestDataTools {
    public static ConfigurationBuilder configurationForTest() throws InvalidConfigurationException {
        Configuration typeConverterConfig = Configuration.builder().setOption("output.disable", "true").build();
        FileTypeConverter fileTypeConverter = FileTypeConverter.create((Configuration)typeConverterConfig);
        Configuration.getDefaultConverters().put(FileOption.class, fileTypeConverter);
        return Configuration.builder().addConverter(FileOption.class, (TypeConverter)fileTypeConverter);
    }

    public static CIdExpression makeVariable(String varName, CSimpleType varType) {
        FileLocation loc = FileLocation.DUMMY;
        CVariableDeclaration decl = new CVariableDeclaration(loc, true, CStorageClass.AUTO, varType, varName, varName, varName, null);
        return new CIdExpression(loc, decl);
    }

    public static CFA makeCFA(String ... lines) throws ParserException, InterruptedException {
        try {
            return TestDataTools.makeCFA(TestDataTools.configurationForTest().build(), lines);
        }
        catch (InvalidConfigurationException e) {
            throw new AssertionError((Object)"Default configuration is invalid?");
        }
    }

    public static CFA makeCFA(Configuration config, String ... lines) throws InvalidConfigurationException, ParserException, InterruptedException {
        CFACreator creator = new CFACreator(config, LogManager.createTestLogManager(), ShutdownNotifier.createDummy());
        return creator.parseSourceAndCreateCFA(Joiner.on((char)'\n').join((Object[])lines));
    }

    public static PathFormula toPathFormula(CFA cfa, SSAMap initialSSA, PathFormulaManager pfmgr, boolean ignoreDeclarations) throws Exception {
        HashMap<CFANode, PathFormula> mapping = new HashMap<CFANode, PathFormula>(cfa.getAllNodes().size());
        FunctionEntryNode start = cfa.getMainFunction();
        PathFormula initial = pfmgr.makeEmptyPathFormulaWithContext(initialSSA, PointerTargetSet.emptyPointerTargetSet());
        mapping.put(start, initial);
        ArrayDeque<CFANode> queue = new ArrayDeque<CFANode>();
        queue.add(start);
        while (!queue.isEmpty()) {
            CFANode node = (CFANode)queue.removeLast();
            Preconditions.checkState((!node.isLoopStart() ? 1 : 0) != 0, (Object)"Can only work on loop-free fragments");
            PathFormula path = (PathFormula)mapping.get(node);
            for (CFAEdge e : CFAUtils.leavingEdges(node)) {
                CFANode toNode = e.getSuccessor();
                PathFormula old = (PathFormula)mapping.get(toNode);
                PathFormula n = ignoreDeclarations && e instanceof CDeclarationEdge && ((CDeclarationEdge)e).getDeclaration() instanceof CVariableDeclaration ? path : pfmgr.makeAnd(path, e);
                PathFormula out = old == null ? n : pfmgr.makeOr(old, n);
                mapping.put(toNode, out);
                queue.add(toNode);
            }
        }
        return (PathFormula)mapping.get(cfa.getMainFunction().getExitNode());
    }

    public static CFA toSingleFunctionCFA(CFACreator creator, String ... parts) throws InvalidConfigurationException, ParserException, InterruptedException {
        return creator.parseSourceAndCreateCFA(TestDataTools.getProgram(parts));
    }

    public static CFA toMultiFunctionCFA(CFACreator creator, String ... parts) throws InvalidConfigurationException, ParserException, InterruptedException {
        return creator.parseSourceAndCreateCFA(Joiner.on((char)'\n').join((Object[])parts));
    }

    private static String getProgram(String ... parts) {
        return "int main() {" + Joiner.on((char)'\n').join((Object[])parts) + "}";
    }

    public static String getEmptyProgram(TemporaryFolder pTempFolder, boolean isJava) throws IOException {
        String program;
        String fileContent;
        File tempFile;
        if (isJava) {
            tempFile = TestDataTools.getTempFile(pTempFolder, "Main.java");
            fileContent = "public class Main { public static void main(String... args) {} }";
            program = "Main";
        } else {
            tempFile = TestDataTools.getTempFile(pTempFolder, "program.i");
            fileContent = TestDataTools.getProgram(new String[0]);
            program = tempFile.toString();
        }
        if (tempFile.createNewFile()) {
            IO.writeFile((Path)tempFile.toPath(), (Charset)StandardCharsets.US_ASCII, (Object)fileContent);
        }
        return program;
    }

    private static File getTempFile(TemporaryFolder pTempFolder, String pFileName) {
        return Path.of(pTempFolder.getRoot().toString(), pFileName).toFile();
    }
}

