/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.testcase;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.lang.invoke.LambdaMetafactory;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.BiPredicate;
import java.util.logging.Level;
import org.sosy_lab.common.Appender;
import org.sosy_lab.common.UniqueIdGenerator;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.IO;
import org.sosy_lab.common.io.PathTemplate;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.ast.AAstNode;
import org.sosy_lab.cpachecker.cfa.ast.ALiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.core.CPAchecker;
import org.sosy_lab.cpachecker.core.counterexample.CFAEdgeWithAssumptions;
import org.sosy_lab.cpachecker.core.counterexample.CounterexampleInfo;
import org.sosy_lab.cpachecker.core.specification.Property;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.util.BiPredicates;
import org.sosy_lab.cpachecker.util.harness.HarnessExporter;
import org.sosy_lab.cpachecker.util.testcase.ExpressionTestValue;
import org.sosy_lab.cpachecker.util.testcase.TestValuesToFormat;
import org.sosy_lab.cpachecker.util.testcase.TestVector;
import org.sosy_lab.cpachecker.util.testcase.XMLTestCaseExport;

@Options(prefix="testcase")
public class TestCaseExporter {
    private static UniqueIdGenerator id = new UniqueIdGenerator();
    @Option(secure=true, name="file", description="export test harness to file as code")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private PathTemplate testHarnessFile = null;
    @Option(secure=true, name="values", description="export test values to file (line separated)")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private PathTemplate testValueFile = null;
    @Option(secure=true, name="xml", description="export test cases to xm file (Test-Comp format)")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private PathTemplate testXMLFile = null;
    @Option(secure=true, name="compress", description="zip all exported test cases into a single file")
    private boolean zipTestCases = false;
    @Option(secure=true, name="zip.file", description="Zip file into which all test case files are bundled")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private Path testCaseZip = null;
    @Option(secure=true, description="Only convert literal value and do not add suffix, e.g., for unsigned, etc.")
    private boolean plainLiteralValue = false;
    @Option(secure=true, description="Do not output values for variables that are not initialized when declared")
    private boolean excludeInitialization = false;
    @Option(secure=true, description="Random seed for mutation of test cases")
    private long mutationSeed = 0L;
    private static int testsWritten = 0;
    private Random randomGen;
    private final CFA cfa;
    private final HarnessExporter harnessExporter;
    private final String producerString;
    private final LogManager logger;

    public TestCaseExporter(CFA pCfa, LogManager pLogger, Configuration pConfig) throws InvalidConfigurationException {
        pConfig.inject((Object)this);
        Preconditions.checkState((!this.isZippedTestCaseWritingEnabled() || this.testCaseZip != null ? 1 : 0) != 0, (Object)"Need to specify testcase.zip.file if test case values are compressed.");
        this.logger = pLogger;
        this.cfa = pCfa;
        this.harnessExporter = new HarnessExporter(pConfig, this.logger, pCfa);
        this.producerString = CPAchecker.getVersion(pConfig);
        this.randomGen = new Random(this.mutationSeed);
    }

    private static String printLineSeparated(List<String> pValues) {
        return Joiner.on((String)"\n").join(pValues);
    }

    public void writeTestCaseFiles(List<String> pInputs, Optional<Property> pSpec) {
        if (this.areTestsEnabled()) {
            if (this.testHarnessFile != null) {
                // empty if block
            }
            if (this.testValueFile != null) {
                this.writeTestCase(this.testValueFile.getPath(new Object[]{id.getFreshId()}), pInputs, FormatType.PLAIN, pSpec);
            }
            if (this.testXMLFile != null) {
                Path testCaseFile = this.testXMLFile.getPath(new Object[]{id.getFreshId()});
                if (TestCaseExporter.isFirstTest()) {
                    this.writeTestCase(testCaseFile.resolveSibling("metadata.xml"), pInputs, FormatType.METADATA, pSpec);
                }
                this.writeTestCase(testCaseFile, pInputs, FormatType.XML, pSpec);
            }
            TestCaseExporter.increaseTestsWritten();
        }
    }

    public void writeTestCaseFiles(CounterexampleInfo pCex, Optional<Property> pSpec) {
        this.writeTestCaseFilesAndMutations(pCex, pSpec, 0);
    }

    public void writeTestCaseFilesAndMutations(CounterexampleInfo pCex, Optional<Property> pSpec, int numMutations) {
        if (this.areTestsEnabled()) {
            ARGPath targetPath = pCex.getTargetPath();
            int numPaths = Math.max(1, numMutations + 1);
            if (this.testHarnessFile != null) {
                this.writeTestCase(this.getTestCaseFiles(this.testHarnessFile, 1), targetPath, pCex, FormatType.HARNESS, pSpec);
            }
            if (this.testValueFile != null) {
                this.writeTestCase(this.getTestCaseFiles(this.testValueFile, numPaths), targetPath, pCex, FormatType.PLAIN, pSpec);
            }
            if (this.testXMLFile != null) {
                List<Path> testCaseFiles = this.getTestCaseFiles(this.testXMLFile, numPaths);
                if (TestCaseExporter.isFirstTest()) {
                    ArrayList<Path> metadataFile = new ArrayList<Path>();
                    metadataFile.add(testCaseFiles.get(0).resolveSibling("metadata.xml"));
                    this.writeTestCase(metadataFile, targetPath, pCex, FormatType.METADATA, pSpec);
                }
                this.writeTestCase(testCaseFiles, targetPath, pCex, FormatType.XML, pSpec);
            }
            TestCaseExporter.increaseTestsWritten();
        }
    }

    private List<Path> getTestCaseFiles(PathTemplate pathGenerator, int numPaths) {
        Preconditions.checkArgument((0 < numPaths ? 1 : 0) != 0);
        ArrayList<Path> testCaseFiles = new ArrayList<Path>();
        for (int i = 0; i < numPaths; ++i) {
            testCaseFiles.add(pathGenerator.getPath(new Object[]{id.getFreshId()}));
        }
        return testCaseFiles;
    }

    private static void increaseTestsWritten() {
        ++testsWritten;
    }

    private static boolean isFirstTest() {
        return testsWritten == 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeTestCase(List<Path> pTestCaseFiles, ARGPath pTargetPath, CounterexampleInfo pCexInfo, FormatType type, Optional<Property> pSpec) {
        ARGState rootState = pTargetPath.getFirstState();
        Predicate relevantStates = Predicates.in(pTargetPath.getStateSet());
        BiPredicate<ARGState, ARGState> relevantEdges = BiPredicates.pairIn(ImmutableSet.copyOf(pTargetPath.getStatePairs()));
        if (type == FormatType.PLAIN || type == FormatType.XML) {
            Optional<List<String>> origInputs = this.getInputNondetValuesOrdered(rootState, (Predicate<? super ARGState>)relevantStates, relevantEdges, pCexInfo);
            if (!origInputs.isPresent()) return;
            this.writeTestCase(pTestCaseFiles, origInputs.orElseThrow(), type, pSpec);
            return;
        }
        if (type == FormatType.METADATA) {
            this.writeTestCase(pTestCaseFiles, new ArrayList<String>(), type, pSpec);
            return;
        }
        try {
            Preconditions.checkNotNull(pTestCaseFiles);
            Preconditions.checkArgument((!pTestCaseFiles.isEmpty() ? 1 : 0) != 0);
            if (this.zipTestCases) {
                try (FileSystem zipFS = this.openZipFS();){
                    Path fileName = pTestCaseFiles.get(0).getFileName();
                    Path testFile = zipFS.getPath((String)(fileName != null ? fileName.toString() : id.getFreshId() + "test.txt"), new String[0]);
                    try (OutputStreamWriter writer = new OutputStreamWriter(zipFS.provider().newOutputStream(testFile, StandardOpenOption.CREATE, StandardOpenOption.WRITE), Charset.defaultCharset());){
                        switch (type) {
                            case HARNESS: {
                                this.harnessExporter.writeHarness(writer, rootState, (Predicate<? super ARGState>)relevantStates, relevantEdges, pCexInfo);
                                return;
                            }
                            default: {
                                throw new AssertionError((Object)"Unknown test case format.");
                            }
                        }
                    }
                }
            }
            Appender content = null;
            switch (type) {
                case HARNESS: {
                    content = appendable -> this.harnessExporter.writeHarness(appendable, rootState, (Predicate<? super ARGState>)relevantStates, relevantEdges, pCexInfo);
                    break;
                }
                default: {
                    throw new AssertionError((Object)"Unknown test case format.");
                }
            }
            IO.writeFile((Path)pTestCaseFiles.get(0), (Charset)Charset.defaultCharset(), (Object)content);
            return;
        }
        catch (IOException e) {
            this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not write test case to file");
        }
    }

    private void writeTestCase(Path testCase, List<String> pInputs, FormatType pType, Optional<Property> pSpec) {
        if (TestCaseExporter.isFirstTest() && pType.equals((Object)FormatType.XML)) {
            ArrayList<Path> metadataFile = new ArrayList<Path>();
            metadataFile.add(testCase.resolveSibling("metadata.xml"));
            this.writeTestCase(metadataFile, new ArrayList<String>(), FormatType.METADATA, pSpec);
        }
        ArrayList<Path> testCaseList = new ArrayList<Path>();
        testCaseList.add(testCase);
        this.writeTestCase(testCaseList, pInputs, pType, pSpec);
        TestCaseExporter.increaseTestsWritten();
    }

    /*
     * Unable to fully structure code
     */
    private void writeTestCase(List<Path> pTestCaseFiles, List<String> pOrigInputs, FormatType pType, Optional<Property> pSpec) {
        block27: {
            Preconditions.checkArgument((boolean)(pType.equals((Object)FormatType.PLAIN) != false || pType.equals((Object)FormatType.XML) != false || pType.equals((Object)FormatType.METADATA) != false));
            try {
                nextInputs = pOrigInputs;
                if (this.zipTestCases) {
                    zipFS = this.openZipFS();
                    try {
                        for (Path pFile : pTestCaseFiles) {
                            fileName = pFile.getFileName();
                            testFile = zipFS.getPath((String)(fileName != null ? fileName.toString() : TestCaseExporter.id.getFreshId() + "test.txt"), new String[0]);
                            writer = new OutputStreamWriter(zipFS.provider().newOutputStream(testFile, new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.WRITE}), Charset.defaultCharset());
                            try {
                                switch (1.$SwitchMap$org$sosy_lab$cpachecker$util$testcase$TestCaseExporter$FormatType[pType.ordinal()]) {
                                    case 2: {
                                        writer.write(this.inputListToFormattedString(nextInputs, (TestValuesToFormat)LambdaMetafactory.metafactory(null, null, null, (Ljava/util/List;)Ljava/lang/String;, printLineSeparated(java.util.List<java.lang.String> ), (Ljava/util/List;)Ljava/lang/String;)()));
                                        ** break;
lbl16:
                                        // 1 sources

                                        break;
                                    }
                                    case 3: {
                                        XMLTestCaseExport.writeXMLMetadata(writer, this.cfa, pSpec.orElse(null), this.producerString);
                                        ** break;
lbl20:
                                        // 1 sources

                                        break;
                                    }
                                    case 4: {
                                        writer.write(this.inputListToFormattedString(nextInputs, XMLTestCaseExport.XML_TEST_CASE));
                                        ** break;
lbl24:
                                        // 1 sources

                                        break;
                                    }
                                    default: {
                                        throw new AssertionError((Object)"Unknown test case format.");
                                    }
                                }
                            }
                            finally {
                                writer.close();
                            }
                            nextInputs = this.mutateInputValues(pOrigInputs);
                        }
                        break block27;
                    }
                    finally {
                        if (zipFS != null) {
                            zipFS.close();
                        }
                    }
                }
                for (Path pFile : pTestCaseFiles) {
                    content = null;
                    switch (1.$SwitchMap$org$sosy_lab$cpachecker$util$testcase$TestCaseExporter$FormatType[pType.ordinal()]) {
                        case 2: {
                            plainOutput = this.inputListToFormattedString(nextInputs, (TestValuesToFormat)LambdaMetafactory.metafactory(null, null, null, (Ljava/util/List;)Ljava/lang/String;, printLineSeparated(java.util.List<java.lang.String> ), (Ljava/util/List;)Ljava/lang/String;)());
                            content = (Appender)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Appendable;)V, lambda$writeTestCase$1(java.lang.String java.lang.Appendable ), (Ljava/lang/Appendable;)V)((String)plainOutput);
                            break;
                        }
                        case 3: {
                            content = (Appender)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Appendable;)V, lambda$writeTestCase$2(java.util.Optional java.lang.Appendable ), (Ljava/lang/Appendable;)V)((TestCaseExporter)this, pSpec);
                            break;
                        }
                        case 4: {
                            xmlOutput = this.inputListToFormattedString(nextInputs, XMLTestCaseExport.XML_TEST_CASE);
                            content = (Appender)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Appendable;)V, lambda$writeTestCase$3(java.lang.String java.lang.Appendable ), (Ljava/lang/Appendable;)V)((String)xmlOutput);
                            break;
                        }
                        default: {
                            throw new AssertionError((Object)"Unknown test case format.");
                        }
                    }
                    IO.writeFile((Path)pFile, (Charset)Charset.defaultCharset(), (Object)content);
                    nextInputs = this.mutateInputValues(pOrigInputs);
                }
            }
            catch (IOException e) {
                this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not write test case to file");
            }
        }
    }

    private boolean areTestsEnabled() {
        return this.testValueFile != null || this.testHarnessFile != null || this.testXMLFile != null;
    }

    private boolean isZippedTestCaseWritingEnabled() {
        return this.zipTestCases && this.areTestsEnabled();
    }

    private FileSystem openZipFS() throws IOException {
        HashMap<String, String> env = new HashMap<String, String>(1);
        env.put("create", "true");
        Preconditions.checkNotNull((Object)this.testCaseZip);
        Path parent = this.testCaseZip.getParent();
        if (parent != null) {
            Files.createDirectories(parent, new FileAttribute[0]);
        }
        return FileSystems.newFileSystem(URI.create("jar:" + this.testCaseZip.toUri()), env, null);
    }

    private String unpack(AAstNode pInputValue) {
        if (pInputValue instanceof CCastExpression) {
            return this.unpack(((CCastExpression)pInputValue).getOperand());
        }
        if (this.plainLiteralValue && pInputValue instanceof ALiteralExpression) {
            return String.valueOf(((ALiteralExpression)pInputValue).getValue());
        }
        return pInputValue.toASTString();
    }

    private Optional<List<String>> getInputNondetValuesOrdered(ARGState pRootState, Predicate<? super ARGState> pIsRelevantState, BiPredicate<ARGState, ARGState> pIsRelevantEdge, CounterexampleInfo pCounterexampleInfo) {
        Multimap<ARGState, CFAEdgeWithAssumptions> valueMap = this.getValueMap(pCounterexampleInfo);
        Optional<TestVector.TargetTestVector> maybeTestVector = this.harnessExporter.extractTestVector(pRootState, pIsRelevantState, pIsRelevantEdge, valueMap);
        if (maybeTestVector.isPresent()) {
            TestVector vector = maybeTestVector.orElseThrow().getVector();
            List inputs = (List)vector.getTestInputsInOrder().stream().filter(v -> !this.excludeInitialization || v instanceof ExpressionTestValue).map(v -> this.unpack(v.getValue())).collect(ImmutableList.toImmutableList());
            return Optional.of(inputs);
        }
        return Optional.empty();
    }

    private List<String> mutateInputValues(List<String> origInputs) {
        ArrayList<String> newInput = new ArrayList<String>(origInputs);
        for (int i = 0; i < newInput.size(); ++i) {
            try {
                int val;
                double origVal = Double.parseDouble((String)newInput.get(i));
                double prob = this.randomGen.nextDouble();
                if (prob < 0.02) {
                    val = Integer.MIN_VALUE;
                } else if (prob < 0.04) {
                    val = Integer.MAX_VALUE;
                } else if (prob < 0.19) {
                    val = 0;
                } else if (prob < 0.34) {
                    val = (int)(-origVal);
                } else {
                    if (!(prob < 0.49)) continue;
                    val = this.randomGen.nextInt();
                }
                newInput.set(i, String.valueOf(val));
                continue;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return newInput;
    }

    private String inputListToFormattedString(List<String> inputs, TestValuesToFormat formatter) {
        return formatter.convertToOutput(inputs);
    }

    private Multimap<ARGState, CFAEdgeWithAssumptions> getValueMap(CounterexampleInfo pCounterexampleInfo) {
        if (pCounterexampleInfo.isPreciseCounterExample()) {
            return pCounterexampleInfo.getExactVariableValues();
        }
        return HashMultimap.create();
    }

    private static /* synthetic */ void lambda$writeTestCase$3(String xmlOutput, Appendable appendable) throws IOException {
        appendable.append(xmlOutput);
    }

    private /* synthetic */ void lambda$writeTestCase$2(Optional pSpec, Appendable appendable) throws IOException {
        XMLTestCaseExport.writeXMLMetadata(appendable, this.cfa, pSpec.orElse(null), this.producerString);
    }

    private static /* synthetic */ void lambda$writeTestCase$1(String plainOutput, Appendable appendable) throws IOException {
        appendable.append(plainOutput);
    }

    private static enum FormatType {
        HARNESS,
        METADATA,
        PLAIN,
        XML;

    }
}

