/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.testcase;

import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.sosy_lab.common.collect.PathCopyingPersistentTreeMap;
import org.sosy_lab.common.collect.PersistentSortedMap;
import org.sosy_lab.cpachecker.cfa.ast.AExpression;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.AInitializer;
import org.sosy_lab.cpachecker.cfa.ast.AParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.AVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.util.harness.PredefinedTypes;
import org.sosy_lab.cpachecker.util.testcase.ExpressionTestValue;
import org.sosy_lab.cpachecker.util.testcase.InitializerTestValue;
import org.sosy_lab.cpachecker.util.testcase.TestValue;

public class TestVector {
    private final PersistentSortedMap<ComparableFunctionDeclaration, ImmutableList<ExpressionTestValue>> inputFunctionValues;
    private final PersistentSortedMap<ComparableVariableDeclaration, InitializerTestValue> inputVariableValues;
    private final ImmutableList<TestValue> inputValues;
    private static final Ordering<AParameterDeclaration> PARAMETER_ORDERING = Ordering.from((pA, pB) -> ComparisonChain.start().compare((Comparable)((Object)pA.getQualifiedName()), (Comparable)((Object)pB.getQualifiedName())).compare((Object)pA.getType(), (Object)pB.getType(), (Comparator)Ordering.usingToString()).compare((Comparable)pA.getFileLocation(), (Comparable)pB.getFileLocation()).result());

    private TestVector() {
        this((PersistentSortedMap<ComparableFunctionDeclaration, ImmutableList<ExpressionTestValue>>)PathCopyingPersistentTreeMap.of(), (PersistentSortedMap<ComparableVariableDeclaration, InitializerTestValue>)PathCopyingPersistentTreeMap.of(), (ImmutableList<TestValue>)ImmutableList.of());
    }

    private TestVector(PersistentSortedMap<ComparableFunctionDeclaration, ImmutableList<ExpressionTestValue>> pInputFunctionValues, PersistentSortedMap<ComparableVariableDeclaration, InitializerTestValue> pInputVariableValues, ImmutableList<TestValue> pInputsInOrder) {
        this.inputFunctionValues = pInputFunctionValues;
        this.inputVariableValues = pInputVariableValues;
        this.inputValues = pInputsInOrder;
    }

    public TestVector addInputValue(AFunctionDeclaration pFunction, AExpression pValue) {
        return this.addInputValue(pFunction, ExpressionTestValue.of(pValue));
    }

    private ImmutableList<TestValue> getExtendedValues(TestValue pValue) {
        return ImmutableList.builderWithExpectedSize((int)(this.inputValues.size() + 1)).addAll(this.inputValues).add((Object)pValue).build();
    }

    public TestVector addInputValue(AFunctionDeclaration pFunction, ExpressionTestValue pValue) {
        ImmutableList newValues;
        ComparableFunctionDeclaration function = new ComparableFunctionDeclaration(pFunction);
        ImmutableList currentValues = (ImmutableList)this.inputFunctionValues.get((Object)function);
        if (currentValues == null) {
            newValues = ImmutableList.of((Object)pValue);
        } else {
            ImmutableList.Builder valueListBuilder = ImmutableList.builder();
            valueListBuilder.addAll((Iterable)currentValues).add((Object)pValue);
            newValues = valueListBuilder.build();
        }
        return new TestVector((PersistentSortedMap<ComparableFunctionDeclaration, ImmutableList<ExpressionTestValue>>)this.inputFunctionValues.putAndCopy((Object)function, (Object)newValues), this.inputVariableValues, this.getExtendedValues(pValue));
    }

    public List<TestValue> getTestInputsInOrder() {
        Preconditions.checkState((this.inputValues.size() == this.inputVariableValues.size() + this.inputFunctionValues.values().stream().map(l -> l.size()).reduce(0, (x, y) -> x + y) ? 1 : 0) != 0);
        return this.inputValues;
    }

    public TestVector addInputValue(AVariableDeclaration pVariable, AInitializer pValue) {
        return this.addInputValue(pVariable, InitializerTestValue.of(pValue));
    }

    public TestVector addInputValue(AVariableDeclaration pVariable, InitializerTestValue pValue) {
        ComparableVariableDeclaration variable = new ComparableVariableDeclaration(pVariable);
        InitializerTestValue currentValue = (InitializerTestValue)this.inputVariableValues.get((Object)variable);
        if (currentValue != null) {
            throw new IllegalArgumentException(String.format("Variable %s already declared with value %s: ", pVariable, pValue));
        }
        return new TestVector(this.inputFunctionValues, (PersistentSortedMap<ComparableVariableDeclaration, InitializerTestValue>)this.inputVariableValues.putAndCopy((Object)variable, (Object)pValue), this.getExtendedValues(pValue));
    }

    public Iterable<AFunctionDeclaration> getInputFunctions() {
        return FluentIterable.from((Iterable)this.inputFunctionValues.keySet()).transform(f -> f.declaration);
    }

    public List<ExpressionTestValue> getInputValues(AFunctionDeclaration pFunction) {
        ComparableFunctionDeclaration function = new ComparableFunctionDeclaration(pFunction);
        ImmutableList currentValues = (ImmutableList)this.inputFunctionValues.get((Object)function);
        if (currentValues == null) {
            return ImmutableList.of();
        }
        return currentValues;
    }

    public Iterable<AVariableDeclaration> getInputVariables() {
        return FluentIterable.from((Iterable)this.inputVariableValues.keySet()).transform(f -> f.declaration);
    }

    public InitializerTestValue getInputValue(AVariableDeclaration pDeclaration) {
        ComparableVariableDeclaration variable = new ComparableVariableDeclaration(pDeclaration);
        InitializerTestValue currentValue = (InitializerTestValue)this.inputVariableValues.get((Object)variable);
        Preconditions.checkArgument((currentValue != null ? 1 : 0) != 0, (String)"Unknown variable: %s", (Object)pDeclaration);
        return currentValue;
    }

    public boolean contains(AFunctionDeclaration pFunctionDeclaration) {
        return this.inputFunctionValues.containsKey((Object)new ComparableFunctionDeclaration(pFunctionDeclaration));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.inputFunctionValues.hashCode();
        result = 31 * result + this.inputVariableValues.hashCode();
        return result;
    }

    public boolean equals(Object pObj) {
        if (this == pObj) {
            return true;
        }
        if (pObj instanceof TestVector) {
            TestVector other = (TestVector)pObj;
            return this.inputFunctionValues.equals(other.inputFunctionValues) && this.inputVariableValues.equals(other.inputVariableValues);
        }
        return false;
    }

    public String toString() {
        return this.inputFunctionValues.toString() + this.inputVariableValues;
    }

    public static TestVector newTestVector() {
        return new TestVector();
    }

    private static <T> Iterable<T> upcast(Iterable<? extends T> pIterable, Class<T> pClass) {
        return FluentIterable.from(pIterable).filter(pClass);
    }

    public static class TargetTestVector {
        private final CFAEdge edgeToTarget;
        private final TestVector testVector;

        public TargetTestVector(CFAEdge pEdgeToTarget, TestVector pTestVector) {
            this.edgeToTarget = Objects.requireNonNull(pEdgeToTarget);
            this.testVector = Objects.requireNonNull(pTestVector);
        }

        public TestVector getVector() {
            return this.testVector;
        }

        public CFAEdge getEdgeToTarget() {
            return this.edgeToTarget;
        }

        public String toString() {
            return this.testVector.toString();
        }

        public int hashCode() {
            return Objects.hash(this.edgeToTarget, this.testVector);
        }

        public boolean equals(Object pObj) {
            if (pObj == this) {
                return true;
            }
            if (pObj instanceof TargetTestVector) {
                TargetTestVector other = (TargetTestVector)pObj;
                return this.edgeToTarget.equals(other.edgeToTarget) && this.testVector.equals(other.testVector);
            }
            return false;
        }
    }

    private static class ComparableVariableDeclaration
    implements Comparable<ComparableVariableDeclaration> {
        private final AVariableDeclaration declaration;

        public ComparableVariableDeclaration(AVariableDeclaration pDeclaration) {
            this.declaration = Objects.requireNonNull(pDeclaration);
        }

        @Override
        public int compareTo(ComparableVariableDeclaration pOther) {
            if (this.declaration.equals(pOther.declaration)) {
                return 0;
            }
            return ComparisonChain.start().compare((Comparable)((Object)this.declaration.getQualifiedName()), (Comparable)((Object)pOther.declaration.getQualifiedName())).compare((Object)PredefinedTypes.getCanonicalType(this.declaration.getType()), (Object)PredefinedTypes.getCanonicalType(pOther.declaration.getType()), (Comparator)Ordering.usingToString()).compareFalseFirst(this.declaration.isGlobal(), pOther.declaration.isGlobal()).result();
        }

        public boolean equals(Object pObj) {
            if (this == pObj) {
                return true;
            }
            if (pObj instanceof ComparableVariableDeclaration) {
                return this.declaration.equals(((ComparableVariableDeclaration)pObj).declaration);
            }
            return false;
        }

        public int hashCode() {
            return this.declaration.hashCode();
        }

        public String toString() {
            return this.declaration.toString();
        }
    }

    private static class ComparableFunctionDeclaration
    implements Comparable<ComparableFunctionDeclaration> {
        private final AFunctionDeclaration declaration;

        public ComparableFunctionDeclaration(AFunctionDeclaration pDeclaration) {
            this.declaration = Objects.requireNonNull(pDeclaration);
        }

        @Override
        public int compareTo(ComparableFunctionDeclaration pOther) {
            if (this.declaration.equals(pOther.declaration)) {
                return 0;
            }
            return ComparisonChain.start().compare((Comparable)((Object)this.declaration.getQualifiedName()), (Comparable)((Object)pOther.declaration.getQualifiedName())).compare(TestVector.upcast(this.declaration.getParameters(), AParameterDeclaration.class), TestVector.upcast(pOther.declaration.getParameters(), AParameterDeclaration.class), (Comparator)PARAMETER_ORDERING.lexicographical()).compare((Object)PredefinedTypes.getCanonicalType(this.declaration.getType().getReturnType()), (Object)PredefinedTypes.getCanonicalType(pOther.declaration.getType().getReturnType()), (Comparator)Ordering.usingToString()).compareFalseFirst(this.declaration.isGlobal(), pOther.declaration.isGlobal()).result();
        }

        public boolean equals(Object pObj) {
            if (this == pObj) {
                return true;
            }
            if (pObj instanceof ComparableFunctionDeclaration) {
                return this.declaration.equals(((ComparableFunctionDeclaration)pObj).declaration);
            }
            return false;
        }

        public int hashCode() {
            return this.declaration.hashCode();
        }

        public String toString() {
            return this.declaration.toString();
        }
    }
}

