/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.variableclassification;

import com.google.common.base.Preconditions;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CPointerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.util.variableclassification.VariablesCollectingVisitor;

class BoolCollectingVisitor
extends VariablesCollectingVisitor {
    private static boolean allowOneAsBooleanValue = false;
    private final Set<String> nonIntBoolVars;

    public BoolCollectingVisitor(CFANode pre, Set<String> pNonIntBoolVars) {
        super(pre);
        this.nonIntBoolVars = (Set)Preconditions.checkNotNull(pNonIntBoolVars);
    }

    @Override
    public Set<String> visit(CFieldReference exp) {
        this.nonIntBoolVars.addAll((Collection<String>)super.visit(exp));
        return null;
    }

    @Override
    public Set<String> visit(CBinaryExpression exp) {
        Set<String> operand1 = exp.getOperand1().accept(this);
        Set<String> operand2 = exp.getOperand2().accept(this);
        if (operand1 == null || operand2 == null) {
            if (operand1 != null) {
                this.nonIntBoolVars.addAll(operand1);
            }
            if (operand2 != null) {
                this.nonIntBoolVars.addAll(operand2);
            }
            return null;
        }
        switch (exp.getOperator()) {
            case EQUALS: 
            case NOT_EQUALS: {
                if (!operand1.isEmpty() && !operand2.isEmpty()) break;
                operand1.addAll(operand2);
                return operand1;
            }
        }
        this.nonIntBoolVars.addAll(operand1);
        this.nonIntBoolVars.addAll(operand2);
        return null;
    }

    @Override
    public Set<String> visit(CIntegerLiteralExpression exp) {
        BigInteger value = exp.getValue();
        if (BigInteger.ZERO.equals(value) || allowOneAsBooleanValue && BigInteger.ONE.equals(value)) {
            return new HashSet<String>(0);
        }
        return null;
    }

    @Override
    public Set<String> visit(CUnaryExpression exp) {
        Set<String> inner = exp.getOperand().accept(this);
        if (inner == null) {
            return null;
        }
        this.nonIntBoolVars.addAll(inner);
        return null;
    }

    @Override
    public Set<String> visit(CPointerExpression exp) {
        Set<String> inner = exp.getOperand().accept(this);
        if (inner == null) {
            return null;
        }
        this.nonIntBoolVars.addAll(inner);
        return null;
    }
}

