/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.variableclassification;

import com.google.common.base.Preconditions;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.ast.c.CArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CComplexCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CPointerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.DefaultCExpressionVisitor;
import org.sosy_lab.cpachecker.exceptions.NoException;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.variableclassification.CollectingRHSVisitor;
import org.sosy_lab.cpachecker.util.variableclassification.VariableAndFieldRelevancyComputer;
import org.sosy_lab.cpachecker.util.variableclassification.VariableOrField;

final class CollectingLHSVisitor
extends DefaultCExpressionVisitor<Pair<VariableOrField, VariableAndFieldRelevancyComputer.VarFieldDependencies>, NoException> {
    private final CFA cfa;

    private CollectingLHSVisitor(CFA pCfa) {
        this.cfa = (CFA)Preconditions.checkNotNull((Object)pCfa);
    }

    public static CollectingLHSVisitor create(CFA pCfa) {
        return new CollectingLHSVisitor(pCfa);
    }

    @Override
    public Pair<VariableOrField, VariableAndFieldRelevancyComputer.VarFieldDependencies> visit(CArraySubscriptExpression e) {
        Pair<VariableOrField, VariableAndFieldRelevancyComputer.VarFieldDependencies> r = e.getArrayExpression().accept(this);
        return Pair.of(r.getFirst(), r.getSecond().withDependencies(e.getSubscriptExpression().accept(CollectingRHSVisitor.create(this.cfa, r.getFirst()))));
    }

    @Override
    public Pair<VariableOrField, VariableAndFieldRelevancyComputer.VarFieldDependencies> visit(CFieldReference e) {
        VariableOrField.Field result = VariableOrField.newField(VariableAndFieldRelevancyComputer.getCanonicalFieldOwnerType(e), e.getFieldName());
        return Pair.of(result, e.getFieldOwner().accept(CollectingRHSVisitor.create(this.cfa, result)));
    }

    @Override
    public Pair<VariableOrField, VariableAndFieldRelevancyComputer.VarFieldDependencies> visit(CPointerExpression e) {
        return Pair.of(VariableOrField.unknown(), e.getOperand().accept(CollectingRHSVisitor.create(this.cfa, VariableOrField.unknown())));
    }

    @Override
    public Pair<VariableOrField, VariableAndFieldRelevancyComputer.VarFieldDependencies> visit(CComplexCastExpression e) {
        return e.getOperand().accept(this);
    }

    @Override
    public Pair<VariableOrField, VariableAndFieldRelevancyComputer.VarFieldDependencies> visit(CCastExpression e) {
        return e.getOperand().accept(this);
    }

    @Override
    public Pair<VariableOrField, VariableAndFieldRelevancyComputer.VarFieldDependencies> visit(CIdExpression e) {
        return Pair.of(VariableOrField.newVariable(e.getDeclaration().getQualifiedName()), VariableAndFieldRelevancyComputer.VarFieldDependencies.emptyDependencies());
    }

    @Override
    protected Pair<VariableOrField, VariableAndFieldRelevancyComputer.VarFieldDependencies> visitDefault(CExpression e) {
        if (e instanceof CUnaryExpression && CUnaryExpression.UnaryOperator.AMPER == ((CUnaryExpression)e).getOperator()) {
            return ((CUnaryExpression)e).getOperand().accept(this);
        }
        throw new AssertionError((Object)String.format("The expression %s from %s should not occur in the left hand side", e, e.getFileLocation()));
    }
}

