/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.variableclassification;

import com.google.common.base.Preconditions;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.ast.c.CArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CComplexCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CPointerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSideVisitor;
import org.sosy_lab.cpachecker.cfa.ast.c.CSimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.DefaultCExpressionVisitor;
import org.sosy_lab.cpachecker.cfa.types.c.CComplexType;
import org.sosy_lab.cpachecker.cfa.types.c.CCompositeType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cpa.smg.TypeUtils;
import org.sosy_lab.cpachecker.exceptions.NoException;
import org.sosy_lab.cpachecker.util.variableclassification.VariableAndFieldRelevancyComputer;
import org.sosy_lab.cpachecker.util.variableclassification.VariableOrField;

final class CollectingRHSVisitor
extends DefaultCExpressionVisitor<VariableAndFieldRelevancyComputer.VarFieldDependencies, NoException>
implements CRightHandSideVisitor<VariableAndFieldRelevancyComputer.VarFieldDependencies, NoException> {
    private final CFA cfa;
    private final VariableOrField lhs;
    private final boolean addressed;

    private CollectingRHSVisitor(CFA pCfa, VariableOrField lhs, boolean addressed) {
        this.cfa = (CFA)Preconditions.checkNotNull((Object)pCfa);
        this.lhs = (VariableOrField)Preconditions.checkNotNull((Object)lhs);
        this.addressed = addressed;
    }

    public static CollectingRHSVisitor create(CFA pCfa, VariableOrField lhs) {
        return new CollectingRHSVisitor(pCfa, lhs, false);
    }

    private CollectingRHSVisitor createAddressed() {
        return new CollectingRHSVisitor(this.cfa, this.lhs, true);
    }

    @Override
    public VariableAndFieldRelevancyComputer.VarFieldDependencies visit(CArraySubscriptExpression e) {
        return e.getSubscriptExpression().accept(this).withDependencies(e.getArrayExpression().accept(this));
    }

    @Override
    public VariableAndFieldRelevancyComputer.VarFieldDependencies visit(CFieldReference e) {
        CCompositeType ownerType = VariableAndFieldRelevancyComputer.getCanonicalFieldOwnerType(e);
        VariableOrField.Field field = VariableOrField.newField(ownerType, e.getFieldName());
        VariableAndFieldRelevancyComputer.VarFieldDependencies result = e.getFieldOwner().accept(this);
        result = ownerType.getKind() == CComplexType.ComplexTypeKind.UNION ? this.addNestedDependenciesAsNecessary(result, ownerType) : result.withDependency(this.lhs, field);
        if (this.addressed) {
            return result.withAddressedField(field);
        }
        return result;
    }

    private VariableAndFieldRelevancyComputer.VarFieldDependencies addNestedDependenciesAsNecessary(VariableAndFieldRelevancyComputer.VarFieldDependencies pResult, CCompositeType pType) {
        VariableAndFieldRelevancyComputer.VarFieldDependencies result = pResult;
        for (CCompositeType.CCompositeTypeMemberDeclaration member : pType.getMembers()) {
            result = result.withDependency(this.lhs, VariableOrField.newField(pType, member.getName()));
            CType memberType = TypeUtils.getRealExpressionType(member.getType());
            if (!(memberType instanceof CCompositeType)) continue;
            result = this.addNestedDependenciesAsNecessary(result, (CCompositeType)memberType);
        }
        return result;
    }

    @Override
    public VariableAndFieldRelevancyComputer.VarFieldDependencies visit(CBinaryExpression e) {
        return e.getOperand1().accept(this).withDependencies(e.getOperand2().accept(this));
    }

    @Override
    public VariableAndFieldRelevancyComputer.VarFieldDependencies visit(CUnaryExpression e) {
        if (e.getOperator() != CUnaryExpression.UnaryOperator.AMPER) {
            return e.getOperand().accept(this);
        }
        return e.getOperand().accept(this.createAddressed());
    }

    @Override
    public VariableAndFieldRelevancyComputer.VarFieldDependencies visit(CPointerExpression e) {
        return e.getOperand().accept(this);
    }

    @Override
    public VariableAndFieldRelevancyComputer.VarFieldDependencies visit(CComplexCastExpression e) {
        return e.getOperand().accept(this);
    }

    @Override
    public VariableAndFieldRelevancyComputer.VarFieldDependencies visit(CCastExpression e) {
        return e.getOperand().accept(this);
    }

    @Override
    public VariableAndFieldRelevancyComputer.VarFieldDependencies visit(CIdExpression e) {
        CSimpleDeclaration decl = e.getDeclaration();
        VariableOrField.Variable variable = VariableOrField.newVariable(decl != null ? decl.getQualifiedName() : e.getName());
        VariableAndFieldRelevancyComputer.VarFieldDependencies result = VariableAndFieldRelevancyComputer.VarFieldDependencies.emptyDependencies().withDependency(this.lhs, variable);
        if (this.addressed) {
            return result.withAddressedVariable(variable);
        }
        return result;
    }

    @Override
    public VariableAndFieldRelevancyComputer.VarFieldDependencies visit(CFunctionCallExpression e) {
        VariableAndFieldRelevancyComputer.VarFieldDependencies result = VariableAndFieldRelevancyComputer.VarFieldDependencies.emptyDependencies();
        CExpression functionNameExpression = e.getFunctionNameExpression();
        if (functionNameExpression instanceof CIdExpression) {
            CIdExpression idExpression = (CIdExpression)functionNameExpression;
            if (this.cfa.getAllFunctionNames().contains(idExpression.getName())) {
                result = functionNameExpression.accept(this);
            }
        } else {
            result = functionNameExpression.accept(this);
        }
        for (CExpression param : e.getParameterExpressions()) {
            result = result.withDependencies(param.accept(this));
        }
        return result;
    }

    @Override
    protected VariableAndFieldRelevancyComputer.VarFieldDependencies visitDefault(CExpression e) {
        Preconditions.checkNotNull((Object)e);
        return VariableAndFieldRelevancyComputer.VarFieldDependencies.emptyDependencies();
    }
}

