/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.variableclassification;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Table;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.util.variableclassification.Partition;

class Dependencies {
    final Set<Partition> partitions = new LinkedHashSet<Partition>();
    private final Map<String, Partition> varToPartition = new HashMap<String, Partition>();
    final Table<CFAEdge, Integer, Partition> edgeToPartition = HashBasedTable.create();

    Dependencies() {
    }

    public Partition getPartitionForVar(String var) {
        return this.varToPartition.get(Preconditions.checkNotNull((Object)var));
    }

    public void add(String var1, String var2) {
        Partition partition1 = this.varToPartition.get(var1);
        Partition partition2 = this.varToPartition.get(var2);
        if (partition1 != null && partition2 != null) {
            if (partition1.compareTo(partition2) > 0) {
                Partition tmp = partition2;
                partition2 = partition1;
                partition1 = tmp;
            }
            if (!partition1.equals(partition2)) {
                partition1.merge(partition2);
                this.partitions.remove(partition2);
            }
        } else if (partition1 != null) {
            partition1.add(var2);
        } else if (partition2 != null) {
            partition2.add(var1);
        } else {
            Partition partition = new Partition(this.varToPartition, this.edgeToPartition);
            partition.add(var1);
            partition.add(var2);
            this.partitions.add(partition);
        }
    }

    public void addAll(@Nullable Collection<String> vars, @Nullable Set<BigInteger> values, CFAEdge edge, int index) {
        Preconditions.checkNotNull((Object)edge);
        if (vars == null || vars.isEmpty()) {
            return;
        }
        Iterator<String> iter = vars.iterator();
        String var = iter.next();
        this.addVar(var);
        while (iter.hasNext()) {
            this.add(var, iter.next());
        }
        Partition partition = this.getPartitionForVar(var);
        partition.addValues(values);
        partition.addEdge(edge, index);
    }

    public void addVar(String var) {
        if (!this.varToPartition.containsKey(var)) {
            Partition partition = new Partition(this.varToPartition, this.edgeToPartition);
            partition.add(var);
            this.partitions.add(partition);
        }
    }

    public void solve(Set<String> vars) {
        Preconditions.checkNotNull(vars);
        for (Partition partition : this.partitions) {
            if (!Iterables.any(partition.getVars(), v -> vars.contains(v))) continue;
            vars.addAll(partition.getVars());
        }
    }

    public String toString() {
        StringBuilder str = new StringBuilder("[");
        Joiner.on((String)",\n").appendTo(str, this.partitions);
        str.append("]");
        return str.toString();
    }
}

