/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.variableclassification;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CPointerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.util.variableclassification.VariablesCollectingVisitor;

class IntAddCollectingVisitor
extends VariablesCollectingVisitor {
    private final Set<String> nonIntAddVars;

    public IntAddCollectingVisitor(CFANode pre, Set<String> pNonIntAddVars) {
        super(pre);
        this.nonIntAddVars = (Set)Preconditions.checkNotNull(pNonIntAddVars);
    }

    @Override
    public Set<String> visit(CCastExpression exp) {
        return exp.getOperand().accept(this);
    }

    @Override
    public Set<String> visit(CFieldReference exp) {
        this.nonIntAddVars.addAll((Collection<String>)super.visit(exp));
        return null;
    }

    @Override
    public Set<String> visit(CBinaryExpression exp) {
        Set<String> operand1 = exp.getOperand1().accept(this);
        Set<String> operand2 = exp.getOperand2().accept(this);
        if (operand1 == null || operand2 == null) {
            if (operand1 != null) {
                this.nonIntAddVars.addAll(operand1);
            }
            if (operand2 != null) {
                this.nonIntAddVars.addAll(operand2);
            }
            return null;
        }
        switch (exp.getOperator()) {
            case PLUS: 
            case MINUS: 
            case LESS_THAN: 
            case LESS_EQUAL: 
            case GREATER_THAN: 
            case GREATER_EQUAL: 
            case EQUALS: 
            case NOT_EQUALS: 
            case BINARY_AND: 
            case BINARY_XOR: 
            case BINARY_OR: {
                operand1.addAll(operand2);
                return operand1;
            }
        }
        this.nonIntAddVars.addAll(operand1);
        this.nonIntAddVars.addAll(operand2);
        return null;
    }

    @Override
    public Set<String> visit(CIntegerLiteralExpression exp) {
        Preconditions.checkNotNull((Object)exp);
        return new HashSet<String>(0);
    }

    @Override
    public Set<String> visit(CUnaryExpression exp) {
        Set<String> inner = exp.getOperand().accept(this);
        if (inner == null) {
            return null;
        }
        if (exp.getOperator() == CUnaryExpression.UnaryOperator.MINUS) {
            return inner;
        }
        this.nonIntAddVars.addAll(inner);
        return null;
    }

    @Override
    public Set<String> visit(CPointerExpression exp) {
        Set<String> inner = exp.getOperand().accept(this);
        if (inner == null) {
            return null;
        }
        this.nonIntAddVars.addAll(inner);
        return null;
    }
}

