/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.variableclassification;

import com.google.common.base.Preconditions;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CPointerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.util.variableclassification.VariableClassificationBuilder;
import org.sosy_lab.cpachecker.util.variableclassification.VariablesCollectingVisitor;

class IntEqualCollectingVisitor
extends VariablesCollectingVisitor {
    private final Set<String> nonIntEqVars;

    public IntEqualCollectingVisitor(CFANode pre, Set<String> pNonIntEqVars) {
        super(pre);
        this.nonIntEqVars = (Set)Preconditions.checkNotNull(pNonIntEqVars);
    }

    @Override
    public Set<String> visit(CCastExpression exp) {
        BigInteger val = VariableClassificationBuilder.getNumber(exp.getOperand());
        if (val == null) {
            return exp.getOperand().accept(this);
        }
        return new HashSet<String>(0);
    }

    @Override
    public Set<String> visit(CFieldReference exp) {
        this.nonIntEqVars.addAll((Collection<String>)super.visit(exp));
        return null;
    }

    @Override
    public Set<String> visit(CBinaryExpression exp) {
        BigInteger val1 = VariableClassificationBuilder.getNumber(exp.getOperand1());
        Set<Object> operand1 = val1 == null ? exp.getOperand1().accept(this) : new HashSet(0);
        BigInteger val2 = VariableClassificationBuilder.getNumber(exp.getOperand2());
        Set<Object> operand2 = val2 == null ? exp.getOperand2().accept(this) : new HashSet(0);
        if (operand1 == null || operand2 == null) {
            if (operand1 != null) {
                this.nonIntEqVars.addAll(operand1);
            }
            if (operand2 != null) {
                this.nonIntEqVars.addAll(operand2);
            }
            return null;
        }
        switch (exp.getOperator()) {
            case EQUALS: 
            case NOT_EQUALS: {
                operand1.addAll(operand2);
                return operand1;
            }
        }
        this.nonIntEqVars.addAll(operand1);
        this.nonIntEqVars.addAll(operand2);
        return null;
    }

    @Override
    public Set<String> visit(CIntegerLiteralExpression exp) {
        Preconditions.checkNotNull((Object)exp);
        return new HashSet<String>(0);
    }

    @Override
    public Set<String> visit(CUnaryExpression exp) {
        BigInteger val = VariableClassificationBuilder.getNumber(exp);
        if (val != null) {
            return new HashSet<String>(0);
        }
        Set<String> inner = exp.getOperand().accept(this);
        if (IntEqualCollectingVisitor.isNestedBinaryExp(exp)) {
            return inner;
        }
        if (inner != null) {
            this.nonIntEqVars.addAll(inner);
        }
        return null;
    }

    @Override
    public Set<String> visit(CPointerExpression exp) {
        BigInteger val = VariableClassificationBuilder.getNumber(exp);
        if (val != null) {
            return new HashSet<String>(0);
        }
        Set<String> inner = exp.getOperand().accept(this);
        if (IntEqualCollectingVisitor.isNestedBinaryExp(exp)) {
            return inner;
        }
        if (inner == null) {
            return null;
        }
        this.nonIntEqVars.addAll(inner);
        return null;
    }

    private static boolean isNestedBinaryExp(CExpression exp) {
        if (exp instanceof CBinaryExpression) {
            return true;
        }
        if (exp instanceof CCastExpression) {
            return IntEqualCollectingVisitor.isNestedBinaryExp(((CCastExpression)exp).getOperand());
        }
        return false;
    }
}

