/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.variableclassification;

import com.google.common.base.Preconditions;
import java.util.HashSet;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CPointerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.util.variableclassification.VariablesCollectingVisitor;

public class IntOverflowCollectingVisitor
extends VariablesCollectingVisitor {
    private final Set<String> intOverflowsVars;

    public IntOverflowCollectingVisitor(CFANode pre, Set<String> pIntOverflowVars) {
        super(pre);
        this.intOverflowsVars = (Set)Preconditions.checkNotNull(pIntOverflowVars);
    }

    @Override
    public Set<String> visit(CCastExpression exp) {
        return exp.getOperand().accept(this);
    }

    @Override
    public Set<String> visit(CFieldReference exp) {
        return super.visit(exp);
    }

    @Override
    public Set<String> visit(CBinaryExpression exp) {
        Set<String> operand1 = exp.getOperand1().accept(this);
        Set<String> operand2 = exp.getOperand2().accept(this);
        switch (exp.getOperator()) {
            case PLUS: 
            case MINUS: 
            case MULTIPLY: 
            case DIVIDE: 
            case MODULO: 
            case SHIFT_LEFT: {
                if (operand1 != null) {
                    this.intOverflowsVars.addAll(operand1);
                }
                if (operand2 != null) {
                    this.intOverflowsVars.addAll(operand2);
                }
                return null;
            }
        }
        if (operand1 == null || operand2 == null) {
            if (operand1 != null) {
                return operand1;
            }
            return operand2;
        }
        operand1.addAll(operand2);
        return operand1;
    }

    @Override
    public Set<String> visit(CIntegerLiteralExpression exp) {
        Preconditions.checkNotNull((Object)exp);
        return new HashSet<String>(0);
    }

    @Override
    public Set<String> visit(CUnaryExpression exp) {
        Set<String> inner = exp.getOperand().accept(this);
        if (inner == null) {
            return null;
        }
        if (exp.getOperator() == CUnaryExpression.UnaryOperator.MINUS) {
            this.intOverflowsVars.addAll(inner);
            return null;
        }
        return inner;
    }

    @Override
    public Set<String> visit(CPointerExpression exp) {
        return exp.getOperand().accept(this);
    }
}

