/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.variableclassification;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Table;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Collections;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeSet;
import org.sosy_lab.common.UniqueIdGenerator;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;

public class Partition
implements Comparable<Partition>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final transient UniqueIdGenerator idGenerator = new UniqueIdGenerator();
    private final int index;
    private final NavigableSet<String> vars = new TreeSet<String>();
    private final NavigableSet<BigInteger> values = new TreeSet<BigInteger>();
    @SuppressFBWarnings(value={"SE_BAD_FIELD"})
    private final Multimap<CFAEdge, Integer> edges = HashMultimap.create();
    private final Map<String, Partition> varToPartition;
    @SuppressFBWarnings(value={"SE_BAD_FIELD"})
    private final Table<CFAEdge, Integer, Partition> edgeToPartition;

    Partition(Map<String, Partition> varToPartition, Table<CFAEdge, Integer, Partition> edgeToPartition) {
        this.varToPartition = (Map)Preconditions.checkNotNull(varToPartition);
        this.edgeToPartition = (Table)Preconditions.checkNotNull(edgeToPartition);
        this.index = idGenerator.getFreshId();
    }

    public NavigableSet<String> getVars() {
        return Collections.unmodifiableNavigableSet(this.vars);
    }

    public NavigableSet<BigInteger> getValues() {
        return Collections.unmodifiableNavigableSet(this.values);
    }

    public Multimap<CFAEdge, Integer> getEdges() {
        return Multimaps.unmodifiableMultimap(this.edges);
    }

    void add(String var) {
        this.vars.add(var);
        this.varToPartition.put(var, this);
    }

    void addValues(Set<BigInteger> newValues) {
        this.values.addAll(newValues);
    }

    void addEdge(CFAEdge edge, int pIndex) {
        this.edges.put((Object)edge, (Object)pIndex);
        this.edgeToPartition.put((Object)edge, (Object)pIndex, (Object)this);
    }

    void merge(Partition other) {
        assert (this.varToPartition == other.varToPartition);
        this.vars.addAll(other.vars);
        this.values.addAll(other.values);
        this.edges.putAll(other.edges);
        for (String var : other.vars) {
            this.varToPartition.put(var, this);
        }
        for (Map.Entry edge : other.edges.entries()) {
            this.edgeToPartition.put((Object)((CFAEdge)edge.getKey()), (Object)((Integer)edge.getValue()), (Object)this);
        }
    }

    public boolean equals(Object other) {
        return other instanceof Partition && this.index == ((Partition)other).index;
    }

    public int hashCode() {
        return this.index;
    }

    public String toString() {
        return this.vars + " --> " + this.values;
    }

    @Override
    public int compareTo(Partition other) {
        return Integer.compare(this.index, other.index);
    }
}

