/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.variableclassification;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.annotations.FieldsAreNonnullByDefault;
import org.sosy_lab.common.annotations.ReturnValuesAreNonnullByDefault;
import org.sosy_lab.common.collect.PersistentLinkedList;
import org.sosy_lab.common.collect.PersistentList;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.ast.c.CAssignment;
import org.sosy_lab.cpachecker.cfa.ast.c.CDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCall;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializers;
import org.sosy_lab.cpachecker.cfa.ast.c.CParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CAssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CDeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CReturnStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CStatementEdge;
import org.sosy_lab.cpachecker.cfa.types.c.CArrayType;
import org.sosy_lab.cpachecker.cfa.types.c.CCompositeType;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCodeException;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.variableclassification.CollectingLHSVisitor;
import org.sosy_lab.cpachecker.util.variableclassification.CollectingRHSVisitor;
import org.sosy_lab.cpachecker.util.variableclassification.VariableOrField;

@ParametersAreNonnullByDefault
@ReturnValuesAreNonnullByDefault
@FieldsAreNonnullByDefault
final class VariableAndFieldRelevancyComputer {
    VariableAndFieldRelevancyComputer() {
    }

    static CCompositeType getCanonicalFieldOwnerType(CFieldReference fieldReference) {
        CType fieldOwnerType = fieldReference.getFieldOwner().getExpressionType().getCanonicalType();
        if (fieldOwnerType instanceof CPointerType) {
            fieldOwnerType = ((CPointerType)fieldOwnerType).getType();
        }
        assert (fieldOwnerType instanceof CCompositeType) : "Field owner should have composite type, but the field-owner type of expression " + fieldReference + " in " + fieldReference.getFileLocation() + " is " + fieldOwnerType + ", which is a " + fieldOwnerType.getClass().getSimpleName() + ".";
        CCompositeType compositeType = (CCompositeType)fieldOwnerType;
        if (compositeType.isConst() || compositeType.isVolatile()) {
            return new CCompositeType(false, false, compositeType.getKind(), compositeType.getMembers(), compositeType.getName(), compositeType.getOrigName());
        }
        return compositeType;
    }

    public static VarFieldDependencies handleEdge(CFA pCfa, CFAEdge edge) throws UnrecognizedCodeException {
        Preconditions.checkNotNull((Object)pCfa);
        VarFieldDependencies result = VarFieldDependencies.emptyDependencies();
        switch (edge.getEdgeType()) {
            case AssumeEdge: {
                CExpression exp = ((CAssumeEdge)edge).getExpression();
                result = result.withDependencies(exp.accept(CollectingRHSVisitor.create(pCfa, VariableOrField.unknown())));
                break;
            }
            case DeclarationEdge: {
                CExpression length;
                CDeclaration decl = ((CDeclarationEdge)edge).getDeclaration();
                if (!(decl instanceof CVariableDeclaration)) break;
                CType declType = decl.getType().getCanonicalType();
                if (declType instanceof CArrayType && (length = ((CArrayType)declType).getLength()) != null) {
                    result = result.withDependencies(length.accept(CollectingRHSVisitor.create(pCfa, VariableOrField.newVariable(decl.getQualifiedName()))));
                }
                CollectingLHSVisitor collectingLHSVisitor = CollectingLHSVisitor.create(pCfa);
                for (CExpressionAssignmentStatement init : CInitializers.convertToAssignments((CVariableDeclaration)decl, edge)) {
                    Pair<VariableOrField, VarFieldDependencies> r = init.getLeftHandSide().accept(collectingLHSVisitor);
                    result = result.withDependencies(r.getSecond().withDependencies(init.getRightHandSide().accept(CollectingRHSVisitor.create(pCfa, r.getFirst()))));
                }
                break;
            }
            case StatementEdge: {
                CStatement statement = ((CStatementEdge)edge).getStatement();
                if (statement instanceof CAssignment) {
                    CAssignment assignment = (CAssignment)statement;
                    CRightHandSide rhs = assignment.getRightHandSide();
                    Pair<VariableOrField, VarFieldDependencies> r = assignment.getLeftHandSide().accept(CollectingLHSVisitor.create(pCfa));
                    if (rhs instanceof CExpression || rhs instanceof CFunctionCallExpression) {
                        result = result.withDependencies(r.getSecond().withDependencies(rhs.accept(CollectingRHSVisitor.create(pCfa, r.getFirst()))));
                        break;
                    }
                    throw new UnrecognizedCodeException("Unhandled assignment", edge, assignment);
                }
                if (!(statement instanceof CFunctionCallStatement)) break;
                result = result.withDependencies(((CFunctionCallStatement)statement).getFunctionCallExpression().accept(CollectingRHSVisitor.create(pCfa, VariableOrField.unknown())));
                break;
            }
            case FunctionCallEdge: {
                CFunctionCallEdge call = (CFunctionCallEdge)edge;
                List<CExpression> args = call.getArguments();
                List<CParameterDeclaration> params = call.getSuccessor().getFunctionParameters();
                for (int i = 0; i < params.size(); ++i) {
                    result = result.withDependencies(args.get(i).accept(CollectingRHSVisitor.create(pCfa, VariableOrField.newVariable(params.get(i).getQualifiedName()))));
                }
                CFunctionCall statement = call.getSummaryEdge().getExpression();
                Optional<CVariableDeclaration> returnVar = call.getSuccessor().getReturnVariable();
                if (!returnVar.isPresent()) break;
                String scopedRetVal = returnVar.orElseThrow().getQualifiedName();
                if (!(statement instanceof CFunctionCallAssignmentStatement)) break;
                Pair<VariableOrField, VarFieldDependencies> r = ((CFunctionCallAssignmentStatement)statement).getLeftHandSide().accept(CollectingLHSVisitor.create(pCfa));
                result = result.withDependencies(r.getSecond()).withDependency(r.getFirst(), VariableOrField.newVariable(scopedRetVal));
                break;
            }
            case FunctionReturnEdge: {
                break;
            }
            case ReturnStatementEdge: {
                CReturnStatementEdge ret = (CReturnStatementEdge)edge;
                if (!ret.asAssignment().isPresent()) break;
                Pair<VariableOrField, VarFieldDependencies> r = ret.asAssignment().orElseThrow().getLeftHandSide().accept(CollectingLHSVisitor.create(pCfa));
                result = result.withDependencies(r.getSecond().withDependencies(ret.asAssignment().orElseThrow().getRightHandSide().accept(CollectingRHSVisitor.create(pCfa, r.getFirst()))));
                break;
            }
            case BlankEdge: 
            case CallToReturnEdge: {
                break;
            }
            default: {
                throw new UnrecognizedCodeException("Unknown edge type: " + edge.getEdgeType(), edge);
            }
        }
        return result;
    }

    public static final class VarFieldDependencies {
        private final Set<String> relevantVariables;
        private final Multimap<CCompositeType, String> relevantFields;
        private final Multimap<CCompositeType, String> addressedFields;
        private final Set<String> addressedVariables;
        private final Multimap<VariableOrField, VariableOrField> dependencies;
        private final PersistentList<VarFieldDependencies> pendingMerges;
        private final int currentSize;
        private final int pendingSize;
        private @Nullable VarFieldDependencies squashed = null;
        private static final int INITIAL_SIZE = 500;
        private static final VarFieldDependencies EMPTY_DEPENDENCIES = new VarFieldDependencies((Set<String>)ImmutableSet.of(), (Multimap<CCompositeType, String>)ImmutableListMultimap.of(), (Multimap<CCompositeType, String>)ImmutableListMultimap.of(), (Set<String>)ImmutableSet.of(), (Multimap<VariableOrField, VariableOrField>)ImmutableListMultimap.of(), (PersistentList<VarFieldDependencies>)PersistentLinkedList.of(), 0, 0);

        private static <T> Set<T> copy(Set<T> source) {
            if (source instanceof HashSet) {
                return (Set)((HashSet)source).clone();
            }
            return new HashSet<T>(source);
        }

        private static <T1, T2> Multimap<T1, T2> copy(Multimap<T1, T2> source) {
            return HashMultimap.create(source);
        }

        private VarFieldDependencies(Set<String> relevantVariables, Multimap<CCompositeType, String> relevantFields, Multimap<CCompositeType, String> addressedFields, Set<String> addressedVariables, Multimap<VariableOrField, VariableOrField> dependencies, PersistentList<VarFieldDependencies> pendingMerges, int currentSize, int pendingSize, boolean forceSquash) {
            if (currentSize > 0 && pendingSize > currentSize || currentSize == 0 && pendingSize >= 500 || forceSquash) {
                relevantVariables = VarFieldDependencies.copy(relevantVariables);
                relevantFields = VarFieldDependencies.copy(relevantFields);
                addressedFields = VarFieldDependencies.copy(addressedFields);
                addressedVariables = VarFieldDependencies.copy(addressedVariables);
                dependencies = VarFieldDependencies.copy(dependencies);
                ArrayDeque<Object> queue = new ArrayDeque<Object>();
                queue.add(pendingMerges);
                while (!queue.isEmpty()) {
                    for (VarFieldDependencies deps : (PersistentList)queue.poll()) {
                        relevantVariables.addAll(deps.relevantVariables);
                        for (Map.Entry e : deps.relevantFields.entries()) {
                            relevantFields.put((Object)((CCompositeType)e.getKey()), (Object)((String)e.getValue()));
                        }
                        for (Map.Entry e : deps.addressedFields.entries()) {
                            addressedFields.put((Object)((CCompositeType)e.getKey()), (Object)((String)e.getValue()));
                        }
                        addressedVariables.addAll(deps.addressedVariables);
                        for (Map.Entry e : deps.dependencies.entries()) {
                            dependencies.put((Object)((VariableOrField)e.getKey()), (Object)((VariableOrField)e.getValue()));
                        }
                        if (deps.pendingMerges.isEmpty()) continue;
                        queue.add(deps.pendingMerges);
                    }
                }
                pendingMerges = PersistentLinkedList.of();
                currentSize += pendingSize;
                pendingSize = 0;
            }
            this.relevantVariables = relevantVariables;
            this.relevantFields = relevantFields;
            this.addressedFields = addressedFields;
            this.addressedVariables = addressedVariables;
            this.dependencies = dependencies;
            this.pendingMerges = pendingMerges;
            this.currentSize = currentSize;
            this.pendingSize = pendingSize;
        }

        private VarFieldDependencies(Set<String> relevantVariables, Multimap<CCompositeType, String> relevantFields, Multimap<CCompositeType, String> addressedFields, Set<String> addressedVariables, Multimap<VariableOrField, VariableOrField> dependencies, PersistentList<VarFieldDependencies> pendingMerges, int currentSize, int pendingSize) {
            this(relevantVariables, relevantFields, addressedFields, addressedVariables, dependencies, pendingMerges, currentSize, pendingSize, false);
        }

        public static VarFieldDependencies emptyDependencies() {
            return EMPTY_DEPENDENCIES;
        }

        public VarFieldDependencies withDependency(VariableOrField lhs, VariableOrField rhs) {
            if (!lhs.isUnknown()) {
                VarFieldDependencies singleDependency = new VarFieldDependencies((Set<String>)ImmutableSet.of(), (Multimap<CCompositeType, String>)ImmutableListMultimap.of(), (Multimap<CCompositeType, String>)ImmutableListMultimap.of(), (Set<String>)ImmutableSet.of(), (Multimap<VariableOrField, VariableOrField>)ImmutableListMultimap.of((Object)lhs, (Object)rhs), (PersistentList<VarFieldDependencies>)PersistentLinkedList.of(), 1, 0);
                return new VarFieldDependencies(this.relevantVariables, this.relevantFields, this.addressedFields, this.addressedVariables, this.dependencies, (PersistentList<VarFieldDependencies>)this.pendingMerges.with((Object)singleDependency), this.currentSize, this.pendingSize + 1);
            }
            if (rhs.isVariable()) {
                VarFieldDependencies singleVariable = new VarFieldDependencies((Set<String>)ImmutableSet.of((Object)rhs.asVariable().getScopedName()), (Multimap<CCompositeType, String>)ImmutableListMultimap.of(), (Multimap<CCompositeType, String>)ImmutableListMultimap.of(), (Set<String>)ImmutableSet.of(), (Multimap<VariableOrField, VariableOrField>)ImmutableListMultimap.of(), (PersistentList<VarFieldDependencies>)PersistentLinkedList.of(), 1, 0);
                return new VarFieldDependencies(this.relevantVariables, this.relevantFields, this.addressedFields, this.addressedVariables, this.dependencies, (PersistentList<VarFieldDependencies>)this.pendingMerges.with((Object)singleVariable), this.currentSize, this.pendingSize + 1);
            }
            if (rhs.isField()) {
                VariableOrField.Field field = rhs.asField();
                VarFieldDependencies singleField = new VarFieldDependencies((Set<String>)ImmutableSet.of(), (Multimap<CCompositeType, String>)ImmutableListMultimap.of((Object)field.getCompositeType(), (Object)field.getName()), (Multimap<CCompositeType, String>)ImmutableListMultimap.of(), (Set<String>)ImmutableSet.of(), (Multimap<VariableOrField, VariableOrField>)ImmutableListMultimap.of(), (PersistentList<VarFieldDependencies>)PersistentLinkedList.of(), 1, 0);
                return new VarFieldDependencies(this.relevantVariables, this.relevantFields, this.addressedFields, this.addressedVariables, this.dependencies, (PersistentList<VarFieldDependencies>)this.pendingMerges.with((Object)singleField), this.currentSize, this.pendingSize + 1);
            }
            if (rhs.isUnknown()) {
                throw new IllegalArgumentException("Can't handle dependency on Unknown");
            }
            throw new AssertionError((Object)"Should be unreachable: all possible cases already handled");
        }

        public VarFieldDependencies withAddressedVariable(VariableOrField.Variable variable) {
            VarFieldDependencies singleVariable = new VarFieldDependencies((Set<String>)ImmutableSet.of(), (Multimap<CCompositeType, String>)ImmutableListMultimap.of(), (Multimap<CCompositeType, String>)ImmutableListMultimap.of(), (Set<String>)ImmutableSet.of((Object)variable.getScopedName()), (Multimap<VariableOrField, VariableOrField>)ImmutableListMultimap.of(), (PersistentList<VarFieldDependencies>)PersistentLinkedList.of(), 1, 0);
            return new VarFieldDependencies(this.relevantVariables, this.relevantFields, this.addressedFields, this.addressedVariables, this.dependencies, (PersistentList<VarFieldDependencies>)this.pendingMerges.with((Object)singleVariable), this.currentSize, this.pendingSize + 1);
        }

        public VarFieldDependencies withAddressedField(VariableOrField.Field field) {
            VarFieldDependencies singleField = new VarFieldDependencies((Set<String>)ImmutableSet.of(), (Multimap<CCompositeType, String>)ImmutableListMultimap.of(), (Multimap<CCompositeType, String>)ImmutableListMultimap.of((Object)field.getCompositeType(), (Object)field.getName()), (Set<String>)ImmutableSet.of(), (Multimap<VariableOrField, VariableOrField>)ImmutableListMultimap.of(), (PersistentList<VarFieldDependencies>)PersistentLinkedList.of(), 1, 0);
            return new VarFieldDependencies(this.relevantVariables, this.relevantFields, this.addressedFields, this.addressedVariables, this.dependencies, (PersistentList<VarFieldDependencies>)this.pendingMerges.with((Object)singleField), this.currentSize, this.pendingSize + 1);
        }

        public VarFieldDependencies withDependencies(VarFieldDependencies other) {
            if (this.currentSize + this.pendingSize == 0) {
                return other;
            }
            if (other.currentSize + other.pendingSize == 0) {
                return this;
            }
            if (this.currentSize >= other.currentSize) {
                return new VarFieldDependencies(this.relevantVariables, this.relevantFields, this.addressedFields, this.addressedVariables, this.dependencies, (PersistentList<VarFieldDependencies>)this.pendingMerges.with((Object)other), this.currentSize, this.pendingSize + other.currentSize + other.pendingSize);
            }
            return new VarFieldDependencies(other.relevantVariables, other.relevantFields, other.addressedFields, other.addressedVariables, other.dependencies, (PersistentList<VarFieldDependencies>)other.pendingMerges.with((Object)this), other.currentSize, other.pendingSize + this.currentSize + this.pendingSize);
        }

        private void ensureSquashed() {
            if (this.squashed == null) {
                this.squashed = new VarFieldDependencies(this.relevantVariables, this.relevantFields, this.addressedFields, this.addressedVariables, this.dependencies, this.pendingMerges, this.currentSize, this.pendingSize, true);
            }
        }

        public ImmutableSet<String> computeAddressedVariables() {
            this.ensureSquashed();
            return ImmutableSet.copyOf(this.squashed.addressedVariables);
        }

        public ImmutableMultimap<CCompositeType, String> computeAddressedFields() {
            this.ensureSquashed();
            return ImmutableListMultimap.copyOf(this.squashed.addressedFields);
        }

        public Pair<ImmutableSet<String>, ImmutableMultimap<CCompositeType, String>> computeRelevantVariablesAndFields() {
            this.ensureSquashed();
            ArrayDeque<VariableOrField> queue = new ArrayDeque<VariableOrField>(this.squashed.relevantVariables.size() + this.squashed.relevantFields.size());
            Set<String> currentRelevantVariables = VarFieldDependencies.copy(this.squashed.relevantVariables);
            Multimap<CCompositeType, String> currentRelevantFields = VarFieldDependencies.copy(this.squashed.relevantFields);
            for (String relevantVariable : this.squashed.relevantVariables) {
                queue.add(VariableOrField.newVariable(relevantVariable));
            }
            for (Map.Entry relevantField : this.squashed.relevantFields.entries()) {
                queue.add(VariableOrField.newField((CCompositeType)relevantField.getKey(), (String)relevantField.getValue()));
            }
            while (!queue.isEmpty()) {
                for (VariableOrField variableOrField : this.squashed.dependencies.get((Object)((VariableOrField)queue.poll()))) {
                    assert (variableOrField.isVariable() || variableOrField.isField()) : "Match failure: neither variable nor field!";
                    if (variableOrField.isVariable()) {
                        VariableOrField.Variable variable = variableOrField.asVariable();
                        if (!currentRelevantVariables.add(variable.getScopedName())) continue;
                        queue.add(variable);
                        continue;
                    }
                    VariableOrField.Field field = variableOrField.asField();
                    if (!currentRelevantFields.put((Object)field.getCompositeType(), (Object)field.getName())) continue;
                    queue.add(field);
                }
            }
            return Pair.of(ImmutableSet.copyOf(currentRelevantVariables), ImmutableListMultimap.copyOf(currentRelevantFields));
        }
    }
}

