/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.variableclassification;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import com.google.common.collect.Table;
import java.io.Serializable;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.log.LogManagerWithoutDuplicates;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.types.c.CCompositeType;
import org.sosy_lab.cpachecker.util.LoopStructure;
import org.sosy_lab.cpachecker.util.variableclassification.Partition;

public class VariableClassification
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final boolean hasRelevantNonIntAddVars;
    private final Set<String> intBoolVars;
    private final Set<String> intEqualVars;
    private final Set<String> intAddVars;
    private final Set<String> intOverflowVars;
    private final Set<String> relevantVariables;
    private final Set<String> addressedVariables;
    private final Multiset<String> assumedVariables;
    private final Multiset<String> assignedVariables;
    private final Multimap<CCompositeType, String> relevantFields;
    private final Multimap<CCompositeType, String> addressedFields;
    private final Set<Partition> partitions;
    private final Set<Partition> intBoolPartitions;
    private final Set<Partition> intEqualPartitions;
    private final Set<Partition> intAddPartitions;
    private final Table<CFAEdge, Integer, Partition> edgeToPartitions;

    VariableClassification(boolean pHasRelevantNonIntAddVars, Set<String> pIntBoolVars, Set<String> pIntEqualVars, Set<String> pIntAddVars, Set<String> pIntOverflowVars, Set<String> pRelevantVariables, Set<String> pAddressedVariables, Multimap<CCompositeType, String> pRelevantFields, Multimap<CCompositeType, String> pAddressedFields, Collection<Partition> pPartitions, Set<Partition> pIntBoolPartitions, Set<Partition> pIntEqualPartitions, Set<Partition> pIntAddPartitions, Table<CFAEdge, Integer, Partition> pEdgeToPartitions, Multiset<String> pAssumedVariables, Multiset<String> pAssignedVariables) {
        this.hasRelevantNonIntAddVars = pHasRelevantNonIntAddVars;
        this.intBoolVars = ImmutableSet.copyOf(pIntBoolVars);
        this.intEqualVars = ImmutableSet.copyOf(pIntEqualVars);
        this.intAddVars = ImmutableSet.copyOf(pIntAddVars);
        this.intOverflowVars = ImmutableSet.copyOf(pIntOverflowVars);
        this.relevantVariables = ImmutableSet.copyOf(pRelevantVariables);
        this.addressedVariables = ImmutableSet.copyOf(pAddressedVariables);
        this.relevantFields = ImmutableSetMultimap.copyOf(pRelevantFields);
        this.addressedFields = ImmutableSetMultimap.copyOf(pAddressedFields);
        this.partitions = ImmutableSet.copyOf(pPartitions);
        this.intBoolPartitions = ImmutableSet.copyOf(pIntBoolPartitions);
        this.intEqualPartitions = ImmutableSet.copyOf(pIntEqualPartitions);
        this.intAddPartitions = ImmutableSet.copyOf(pIntAddPartitions);
        this.edgeToPartitions = ImmutableTable.copyOf(pEdgeToPartitions);
        this.assumedVariables = ImmutableMultiset.copyOf(pAssumedVariables);
        this.assignedVariables = ImmutableMultiset.copyOf(pAssignedVariables);
    }

    @VisibleForTesting
    public static VariableClassification empty() {
        return new VariableClassification(false, (Set<String>)ImmutableSet.of(), (Set<String>)ImmutableSet.of(), (Set<String>)ImmutableSet.of(), (Set<String>)ImmutableSet.of(), (Set<String>)ImmutableSet.of(), (Set<String>)ImmutableSet.of(), (Multimap<CCompositeType, String>)ImmutableSetMultimap.of(), (Multimap<CCompositeType, String>)ImmutableSetMultimap.of(), (Collection<Partition>)ImmutableSet.of(), (Set<Partition>)ImmutableSet.of(), (Set<Partition>)ImmutableSet.of(), (Set<Partition>)ImmutableSet.of(), (Table<CFAEdge, Integer, Partition>)ImmutableTable.of(), (Multiset<String>)ImmutableMultiset.of(), (Multiset<String>)ImmutableMultiset.of());
    }

    public boolean hasRelevantNonIntAddVars() {
        return this.hasRelevantNonIntAddVars;
    }

    public Set<String> getRelevantVariables() {
        return this.relevantVariables;
    }

    public Set<String> getAddressedVariables() {
        return this.addressedVariables;
    }

    public Multimap<CCompositeType, String> getRelevantFields() {
        return this.relevantFields;
    }

    public Multimap<CCompositeType, String> getAddressedFields() {
        return this.addressedFields;
    }

    public Set<String> getIntBoolVars() {
        return this.intBoolVars;
    }

    public Set<Partition> getIntBoolPartitions() {
        return this.intBoolPartitions;
    }

    public Set<String> getIntEqualVars() {
        return this.intEqualVars;
    }

    public Set<Partition> getIntEqualPartitions() {
        return this.intEqualPartitions;
    }

    public Set<String> getIntAddVars() {
        return this.intAddVars;
    }

    public Set<String> getIntOverflowVars() {
        return this.intOverflowVars;
    }

    public Set<Partition> getIntAddPartitions() {
        return this.intAddPartitions;
    }

    public Set<Partition> getPartitions() {
        return this.partitions;
    }

    public Multiset<String> getAssumedVariables() {
        return this.assumedVariables;
    }

    public Multiset<String> getAssignedVariables() {
        return this.assignedVariables;
    }

    public Partition getPartitionForEdge(CFAEdge edge) {
        Preconditions.checkArgument((!(edge instanceof FunctionCallEdge) ? 1 : 0) != 0, (Object)"For FunctionCallEdges, use the specific methods because they have multiple partitions");
        return this.getPartitionForEdge(edge, 0);
    }

    public Partition getPartitionForParameterOfEdge(FunctionCallEdge edge, int param) {
        Preconditions.checkElementIndex((int)param, (int)edge.getArguments().size());
        return this.getPartitionForEdge(edge, param);
    }

    public Partition getPartitionForReturnValueOfEdge(FunctionCallEdge edge) {
        return this.getPartitionForEdge(edge, -1);
    }

    private Partition getPartitionForEdge(CFAEdge edge, int index) {
        Preconditions.checkNotNull((Object)edge);
        return (Partition)this.edgeToPartitions.get((Object)edge, (Object)index);
    }

    public int obtainDomainTypeScoreForVariables(Collection<String> variableNames, Optional<LoopStructure> loopStructure, LogManagerWithoutDuplicates logger) {
        boolean BOOLEAN_VAR = true;
        int INTEQUAL_VAR = 2;
        int UNKNOWN_VAR = 4;
        Preconditions.checkNotNull((Object)logger);
        Preconditions.checkNotNull(loopStructure);
        if (variableNames.isEmpty()) {
            return 4;
        }
        int newScore = 1;
        for (String variableName : variableNames) {
            int factor = 4;
            if (this.getIntBoolVars().contains(variableName)) {
                factor = 1;
            } else if (this.getIntEqualVars().contains(variableName)) {
                factor = 2;
            }
            newScore += factor;
            if (loopStructure.isPresent() && loopStructure.orElseThrow().getLoopIncDecVariables().contains(variableName)) {
                return Integer.MAX_VALUE;
            }
            if (newScore >= 0) continue;
            logger.logOnce(Level.WARNING, new Object[]{"Highest possible value reached in score computation. Error path prefix preference may not be applied reliably."});
            logger.logf(Level.FINE, "Overflow in score computation happened for variables %s.", new Object[]{variableNames.toString()});
            return 0x7FFFFFFE;
        }
        return newScore;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("\nIntBool  " + this.intBoolVars.size() + "\n    " + this.intBoolVars);
        str.append("\nIntEq  " + this.intEqualVars.size() + "\n    " + this.intEqualVars);
        str.append("\nIntAdd  " + this.intAddVars.size() + "\n    " + this.intAddVars);
        str.append("\nIntOverflow  " + this.intOverflowVars.size() + "\n    " + this.intOverflowVars);
        return str.toString();
    }

    private Object readResolve() {
        return new VariableClassification(this.hasRelevantNonIntAddVars, this.intBoolVars, this.intEqualVars, this.intAddVars, this.intOverflowVars, this.relevantVariables, this.addressedVariables, this.relevantFields, this.addressedFields, this.partitions, this.intBoolPartitions, this.intEqualPartitions, this.intAddPartitions, this.edgeToPartitions, this.assumedVariables, this.assignedVariables);
    }
}

