/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.variableclassification;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Writer;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.IO;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.Language;
import org.sosy_lab.cpachecker.cfa.ast.AVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CAssignment;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCall;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializer;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CLeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CPointerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CSimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.model.AStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.c.CAssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CDeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionReturnEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionSummaryEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CReturnStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CStatementEdge;
import org.sosy_lab.cpachecker.cfa.types.c.CCompositeType;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCodeException;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.statistics.StatTimer;
import org.sosy_lab.cpachecker.util.variableclassification.BoolCollectingVisitor;
import org.sosy_lab.cpachecker.util.variableclassification.Dependencies;
import org.sosy_lab.cpachecker.util.variableclassification.IntAddCollectingVisitor;
import org.sosy_lab.cpachecker.util.variableclassification.IntEqualCollectingVisitor;
import org.sosy_lab.cpachecker.util.variableclassification.IntOverflowCollectingVisitor;
import org.sosy_lab.cpachecker.util.variableclassification.Partition;
import org.sosy_lab.cpachecker.util.variableclassification.VariableAndFieldRelevancyComputer;
import org.sosy_lab.cpachecker.util.variableclassification.VariableClassification;
import org.sosy_lab.cpachecker.util.variableclassification.VariablesCollectingVisitor;

@Options(prefix="cfa.variableClassification")
public class VariableClassificationBuilder
implements StatisticsProvider {
    @Option(secure=true, name="logfile", description="Dump variable classification to a file.")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private Path dumpfile = Path.of("VariableClassification.log", new String[0]);
    @Option(secure=true, description="Dump variable type mapping to a file.")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private Path typeMapFile = Path.of("VariableTypeMapping.txt", new String[0]);
    @Option(secure=true, description="Dump domain type statistics to a CSV file.")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private Path domainTypeStatisticsFile = null;
    @Option(secure=true, description="Print some information about the variable classification.")
    private boolean printStatsOnStartup = false;
    @Deprecated
    public static final String FUNCTION_RETURN_VARIABLE = "__retval__";
    private static final String SCOPE_SEPARATOR = "::";
    private final Set<String> allVars = new HashSet<String>();
    private final Set<String> nonIntBoolVars = new HashSet<String>();
    private final Set<String> nonIntEqVars = new HashSet<String>();
    private final Set<String> nonIntAddVars = new HashSet<String>();
    private final Set<String> intOverflowVars = new HashSet<String>();
    private final Dependencies dependencies = new Dependencies();
    private @Nullable ImmutableSet<String> relevantVariables;
    private @Nullable ImmutableMultimap<CCompositeType, String> relevantFields;
    private @Nullable ImmutableMultimap<CCompositeType, String> addressedFields;
    private @Nullable ImmutableSet<String> addressedVariables;
    private final LogManager logger;
    private final VariableClassificationStatistics stats = new VariableClassificationStatistics();

    public VariableClassificationBuilder(Configuration config, LogManager pLogger) throws InvalidConfigurationException {
        this.logger = (LogManager)Preconditions.checkNotNull((Object)pLogger);
        config.inject((Object)this);
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        pStatsCollection.add(this.stats);
    }

    public VariableClassification build(CFA cfa) throws UnrecognizedCodeException {
        Preconditions.checkArgument((cfa.getLanguage() == Language.C ? 1 : 0) != 0, (Object)"VariableClassification currently only supports C");
        this.stats.variableClassificationTimer.start();
        this.stats.collectTimer.start();
        this.collectVars(cfa);
        this.stats.collectTimer.stop();
        this.stats.dependencyTimer.start();
        this.dependencies.solve(this.nonIntBoolVars);
        this.dependencies.solve(this.nonIntEqVars);
        this.dependencies.solve(this.nonIntAddVars);
        this.dependencies.solve(this.intOverflowVars);
        this.stats.dependencyTimer.stop();
        HashSet<String> intBoolVars = new HashSet<String>();
        HashSet<String> intEqualVars = new HashSet<String>();
        HashSet<String> intAddVars = new HashSet<String>();
        HashSet<Partition> intBoolPartitions = new HashSet<Partition>();
        HashSet<Partition> intEqualPartitions = new HashSet<Partition>();
        HashSet<Partition> intAddPartitions = new HashSet<Partition>();
        this.stats.hierarchyTimer.start();
        for (String var : this.allVars) {
            if (!this.nonIntBoolVars.contains(var)) {
                intBoolVars.add(var);
                intBoolPartitions.add(this.dependencies.getPartitionForVar(var));
                continue;
            }
            if (!this.nonIntEqVars.contains(var)) {
                intEqualVars.add(var);
                intEqualPartitions.add(this.dependencies.getPartitionForVar(var));
                continue;
            }
            if (this.nonIntAddVars.contains(var)) continue;
            intAddVars.add(var);
            intAddPartitions.add(this.dependencies.getPartitionForVar(var));
        }
        this.stats.hierarchyTimer.stop();
        for (String var : this.allVars) {
            this.dependencies.addVar(var);
        }
        boolean hasRelevantNonIntAddVars = !Sets.intersection(this.relevantVariables, this.nonIntAddVars).isEmpty();
        this.stats.buildTimer.start();
        VariableClassification result = new VariableClassification(hasRelevantNonIntAddVars, (Set<String>)intBoolVars, (Set<String>)intEqualVars, (Set<String>)intAddVars, this.intOverflowVars, (Set<String>)this.relevantVariables, (Set<String>)this.addressedVariables, (Multimap<CCompositeType, String>)this.relevantFields, (Multimap<CCompositeType, String>)this.addressedFields, (Collection<Partition>)this.dependencies.partitions, (Set<Partition>)intBoolPartitions, (Set<Partition>)intEqualPartitions, (Set<Partition>)intAddPartitions, this.dependencies.edgeToPartition, this.extractAssumedVariables(cfa.getAllNodes()), this.extractAssignedVariables(cfa.getAllNodes()));
        this.stats.buildTimer.stop();
        this.stats.exportTimer.start();
        if (this.printStatsOnStartup) {
            this.printStats(result);
        }
        if (this.dumpfile != null) {
            try (Writer w = IO.openOutputFile((Path)this.dumpfile, (Charset)Charset.defaultCharset(), (OpenOption[])new OpenOption[0]);){
                w.append("IntBool\n\n");
                w.append(((Object)intBoolVars).toString());
                w.append("\n\nIntEq\n\n");
                w.append(((Object)intEqualVars).toString());
                w.append("\n\nIntAdd\n\n");
                w.append(((Object)intAddVars).toString());
                w.append("\n\nIntOverflow\n\n");
                w.append(this.intOverflowVars.toString());
                w.append("\n\nALL\n\n");
                w.append(this.allVars.toString());
                w.append("\n\nDEPENDENCIES\n\n");
                w.append(this.dependencies.toString());
                w.append("\n\nRELEVANT VARS\n\n");
                w.append(this.relevantVariables.toString());
                w.append("\n\nRELEVANT FIELDS\n\n");
                w.append(this.relevantFields.toString());
                w.append("\n");
            }
            catch (IOException e) {
                this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not write variable classification to file");
            }
        }
        if (this.typeMapFile != null) {
            this.dumpVariableTypeMapping(this.typeMapFile, result);
        }
        if (this.domainTypeStatisticsFile != null) {
            this.dumpDomainTypeStatistics(this.domainTypeStatisticsFile, result);
        }
        this.stats.exportTimer.stop();
        this.stats.variableClassificationTimer.stop();
        return result;
    }

    private void dumpDomainTypeStatistics(Path pDomainTypeStatisticsFile, VariableClassification vc) {
        try (Writer w = IO.openOutputFile((Path)pDomainTypeStatisticsFile, (Charset)Charset.defaultCharset(), (OpenOption[])new OpenOption[0]);){
            int col;
            Object[][] statMapping = new Object[][]{{"intBoolVars", vc.getIntBoolVars().size()}, {"intEqualVars", vc.getIntEqualVars().size()}, {"intAddVars", vc.getIntAddVars().size()}, {"allVars", this.allVars.size()}, {"intBoolVarsRelevant", this.countNumberOfRelevantVars(vc.getIntBoolVars())}, {"intEqualVarsRelevant", this.countNumberOfRelevantVars(vc.getIntEqualVars())}, {"intAddVarsRelevant", this.countNumberOfRelevantVars(vc.getIntAddVars())}, {"allVarsRelevant", this.countNumberOfRelevantVars(this.allVars)}};
            for (col = 0; col < statMapping.length; ++col) {
                w.write(String.valueOf(statMapping[col][0]));
                if (col == statMapping.length - 1) continue;
                w.write("\t");
            }
            w.write("\n");
            for (col = 0; col < statMapping.length; ++col) {
                w.write(String.valueOf(statMapping[col][1]));
                if (col == statMapping.length - 1) continue;
                w.write("\t");
            }
            w.write("\n");
        }
        catch (IOException e) {
            this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not write variable classification statistics to file");
        }
    }

    private void dumpVariableTypeMapping(Path target, VariableClassification vc) {
        try (Writer w = IO.openOutputFile((Path)target, (Charset)Charset.defaultCharset(), (OpenOption[])new OpenOption[0]);){
            for (String var : this.allVars) {
                int type = 0;
                if (vc.getIntBoolVars().contains(var)) {
                    type += 7;
                } else if (vc.getIntEqualVars().contains(var)) {
                    type += 6;
                } else if (vc.getIntAddVars().contains(var)) {
                    type += 4;
                }
                w.append(String.format("%s\t%d%n", var, type));
            }
        }
        catch (IOException e) {
            this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not write variable type mapping to file");
        }
    }

    /*
     * WARNING - void declaration
     */
    private void printStats(VariableClassification vc) {
        void var4_8;
        int numOfBooleans = 0;
        for (Partition partition : vc.getIntEqualPartitions()) {
            numOfBooleans += partition.getVars().size();
        }
        assert (numOfBooleans == vc.getIntBoolVars().size());
        int numOfIntEquals = 0;
        for (Partition partition : vc.getIntEqualPartitions()) {
            numOfIntEquals += partition.getVars().size();
        }
        assert (numOfIntEquals == vc.getIntEqualVars().size());
        boolean bl = false;
        for (Partition p : vc.getIntAddPartitions()) {
            var4_8 += p.getVars().size();
        }
        assert (var4_8 == vc.getIntAddVars().size());
        String string = "\nVC ";
        StringBuilder str = new StringBuilder("VariableClassification Statistics\n");
        Joiner.on((String)"\nVC ").appendTo(str, (Object[])new String[]{"---------------------------------", "number of boolean vars:  " + numOfBooleans, "number of intEq vars:    " + numOfIntEquals, "number of intAdd vars:   " + (int)var4_8, "number of all vars:      " + this.allVars.size(), "number of rel. vars:     " + this.relevantVariables.size(), "number of addr. vars:    " + this.addressedVariables.size(), "number of rel. fields:   " + this.relevantFields.size(), "number of addr. fields:  " + this.addressedFields.size(), "number of intBool partitions:  " + vc.getIntBoolPartitions().size(), "number of intEq partitions:    " + vc.getIntEqualPartitions().size(), "number of intAdd partitions:   " + vc.getIntAddPartitions().size(), "number of all partitions:      " + this.dependencies.partitions.size()});
        str.append("\n---------------------------------\n");
        this.logger.log(Level.INFO, new Object[]{str.toString()});
    }

    private int countNumberOfRelevantVars(Set<String> ofVars) {
        return Sets.intersection(ofVars, this.relevantVariables).size();
    }

    private void collectVars(CFA cfa) throws UnrecognizedCodeException {
        Collection<CFANode> nodes = cfa.getAllNodes();
        VariableAndFieldRelevancyComputer.VarFieldDependencies varFieldDependencies = VariableAndFieldRelevancyComputer.VarFieldDependencies.emptyDependencies();
        for (CFANode node : nodes) {
            for (CFAEdge edge : CFAUtils.leavingEdges(node)) {
                this.handleEdge(edge, cfa);
                varFieldDependencies = varFieldDependencies.withDependencies(VariableAndFieldRelevancyComputer.handleEdge(cfa, edge));
            }
        }
        this.addressedVariables = varFieldDependencies.computeAddressedVariables();
        this.addressedFields = varFieldDependencies.computeAddressedFields();
        Pair<ImmutableSet<String>, ImmutableMultimap<CCompositeType, String>> relevant = varFieldDependencies.computeRelevantVariablesAndFields();
        this.relevantVariables = relevant.getFirst();
        this.relevantFields = relevant.getSecond();
    }

    private Multiset<String> extractAssumedVariables(Collection<CFANode> nodes) {
        HashMultiset assumeVariables = HashMultiset.create();
        for (CFANode node : nodes) {
            for (CAssumeEdge edge : Iterables.filter(CFAUtils.leavingEdges(node), CAssumeEdge.class)) {
                assumeVariables.addAll((Collection)CFAUtils.getIdExpressionsOfExpression(edge.getExpression()).transform(id -> id.getDeclaration().getQualifiedName()).toSet());
            }
        }
        return assumeVariables;
    }

    private Multiset<String> extractAssignedVariables(Collection<CFANode> nodes) {
        HashMultiset assignedVariables = HashMultiset.create();
        for (CFANode node : nodes) {
            for (CFAEdge leavingEdge : CFAUtils.leavingEdges(node)) {
                AStatementEdge edge;
                if (!(leavingEdge instanceof AStatementEdge) || !((edge = (AStatementEdge)leavingEdge).getStatement() instanceof CAssignment)) continue;
                CAssignment assignment = (CAssignment)edge.getStatement();
                assignedVariables.addAll((Collection)CFAUtils.getIdExpressionsOfExpression(assignment.getLeftHandSide()).transform(id -> id.getDeclaration().getQualifiedName()).toSet());
            }
        }
        return assignedVariables;
    }

    private void handleEdge(CFAEdge edge, CFA cfa) throws UnrecognizedCodeException {
        switch (edge.getEdgeType()) {
            case AssumeEdge: {
                CExpression exp = ((CAssumeEdge)edge).getExpression();
                CFANode pre = edge.getPredecessor();
                VariablesCollectingVisitor dcv = new VariablesCollectingVisitor(pre);
                Set<String> vars = exp.accept(dcv);
                if (vars != null) {
                    this.allVars.addAll(vars);
                    this.dependencies.addAll(vars, dcv.getValues(), edge, 0);
                }
                exp.accept(new BoolCollectingVisitor(pre, this.nonIntBoolVars));
                exp.accept(new IntEqualCollectingVisitor(pre, this.nonIntEqVars));
                exp.accept(new IntAddCollectingVisitor(pre, this.nonIntAddVars));
                exp.accept(new IntOverflowCollectingVisitor(pre, this.intOverflowVars));
                break;
            }
            case DeclarationEdge: {
                this.handleDeclarationEdge((CDeclarationEdge)edge);
                break;
            }
            case StatementEdge: {
                CStatement statement = ((CStatementEdge)edge).getStatement();
                if (statement instanceof CAssignment) {
                    this.handleAssignment(edge, (CAssignment)statement, cfa);
                    break;
                }
                if (!(statement instanceof CFunctionCallStatement)) break;
                this.handleExternalFunctionCall(edge, ((CFunctionCallStatement)statement).getFunctionCallExpression().getParameterExpressions());
                break;
            }
            case FunctionCallEdge: {
                this.handleFunctionCallEdge((CFunctionCallEdge)edge);
                break;
            }
            case FunctionReturnEdge: {
                Optional<CVariableDeclaration> returnVar = ((CFunctionReturnEdge)edge).getFunctionEntry().getReturnVariable();
                if (!returnVar.isPresent()) break;
                String scopedVarName = returnVar.orElseThrow().getQualifiedName();
                this.dependencies.addVar(scopedVarName);
                Partition partition = this.dependencies.getPartitionForVar(scopedVarName);
                partition.addEdge(edge, 0);
                break;
            }
            case ReturnStatementEdge: {
                CReturnStatementEdge returnStatement = (CReturnStatementEdge)edge;
                if (!returnStatement.asAssignment().isPresent()) break;
                this.handleAssignment(edge, returnStatement.asAssignment().orElseThrow(), cfa);
                break;
            }
            case BlankEdge: 
            case CallToReturnEdge: {
                break;
            }
            default: {
                throw new UnrecognizedCodeException("Unknown edgeType: " + edge.getEdgeType(), edge);
            }
        }
    }

    private void handleDeclarationEdge(CDeclarationEdge edge) {
        CInitializer initializer;
        CDeclaration declaration = edge.getDeclaration();
        if (!(declaration instanceof CVariableDeclaration)) {
            return;
        }
        CVariableDeclaration vdecl = (CVariableDeclaration)declaration;
        String varName = vdecl.getQualifiedName();
        this.allVars.add(varName);
        HashSet var = Sets.newHashSetWithExpectedSize((int)1);
        var.add(varName);
        this.dependencies.addAll(var, new HashSet<BigInteger>(), edge, 0);
        if (!(vdecl.getType() instanceof CSimpleType)) {
            this.nonIntBoolVars.add(varName);
            this.nonIntEqVars.add(varName);
            this.nonIntAddVars.add(varName);
        }
        if (!((initializer = vdecl.getInitializer()) instanceof CInitializerExpression)) {
            return;
        }
        CExpression exp = ((CInitializerExpression)initializer).getExpression();
        if (exp == null) {
            return;
        }
        this.handleExpression(edge, exp, varName);
    }

    private void handleAssignment(CFAEdge edge, CAssignment assignment, CFA cfa) throws UnrecognizedCodeException {
        CExpression operand;
        CRightHandSide rhs = assignment.getRightHandSide();
        CLeftHandSide lhs = assignment.getLeftHandSide();
        String function = VariableClassificationBuilder.isGlobal(lhs) ? null : edge.getPredecessor().getFunctionName();
        String varName = VariableClassificationBuilder.scopeVar(function, lhs.toASTString());
        if (lhs instanceof CPointerExpression && lhs.getExpressionType() instanceof CSimpleType && (operand = ((CPointerExpression)lhs).getOperand()) instanceof CIdExpression) {
            varName = VariableClassificationBuilder.scopeVar(function, operand.toASTString());
        }
        if (!(lhs instanceof CIdExpression) || !(lhs.getExpressionType() instanceof CSimpleType)) {
            this.nonIntBoolVars.add(varName);
            this.nonIntEqVars.add(varName);
            this.nonIntAddVars.add(varName);
        }
        this.dependencies.addVar(varName);
        if (rhs instanceof CExpression) {
            this.handleExpression(edge, (CExpression)rhs, varName);
        } else if (rhs instanceof CFunctionCallExpression) {
            CFunctionCallExpression func = (CFunctionCallExpression)rhs;
            String functionName = func.getFunctionNameExpression().toASTString();
            if (cfa.getAllFunctionNames().contains(functionName)) {
                Optional<? extends AVariableDeclaration> returnVariable = cfa.getFunctionHead(functionName).getReturnVariable();
                if (!returnVariable.isPresent()) {
                    throw new UnrecognizedCodeException("Void function " + functionName + " used in assignment", edge, assignment);
                }
                String returnVar = returnVariable.get().getQualifiedName();
                this.allVars.add(returnVar);
                this.allVars.add(varName);
                this.dependencies.add(returnVar, varName);
            } else {
                Partition partition = this.dependencies.getPartitionForVar(varName);
                partition.addEdge(edge, -1);
            }
            this.handleExternalFunctionCall(edge, func.getParameterExpressions());
        } else {
            throw new UnrecognizedCodeException("unhandled assignment", edge, assignment);
        }
    }

    private void handleExternalFunctionCall(CFAEdge edge, List<CExpression> params) {
        for (int i = 0; i < params.size(); ++i) {
            CExpression param = params.get(i);
            if (param instanceof CUnaryExpression && CUnaryExpression.UnaryOperator.AMPER == ((CUnaryExpression)param).getOperator() && ((CUnaryExpression)param).getOperand() instanceof CIdExpression) {
                CIdExpression id = (CIdExpression)((CUnaryExpression)param).getOperand();
                String varName = id.getDeclaration().getQualifiedName();
                this.dependencies.addVar(varName);
                Partition partition = this.dependencies.getPartitionForVar(varName);
                partition.addEdge(edge, i);
                continue;
            }
            CFANode pre = edge.getPredecessor();
            VariablesCollectingVisitor dcv = new VariablesCollectingVisitor(pre);
            Set<String> vars = param.accept(dcv);
            if (vars != null) {
                this.allVars.addAll(vars);
                this.dependencies.addAll(vars, dcv.getValues(), edge, i);
            }
            param.accept(new BoolCollectingVisitor(pre, this.nonIntBoolVars));
            param.accept(new IntEqualCollectingVisitor(pre, this.nonIntEqVars));
            param.accept(new IntAddCollectingVisitor(pre, this.nonIntAddVars));
            param.accept(new IntOverflowCollectingVisitor(pre, this.intOverflowVars));
        }
    }

    private void handleFunctionCallEdge(CFunctionCallEdge edge) {
        List<CExpression> args = edge.getArguments();
        List<CParameterDeclaration> params = edge.getSuccessor().getFunctionParameters();
        assert (args.size() >= params.size());
        for (int i = 0; i < params.size(); ++i) {
            CParameterDeclaration param = params.get(i);
            String varName = param.getQualifiedName();
            if (!(param.getType() instanceof CSimpleType)) {
                this.nonIntBoolVars.add(varName);
                this.nonIntEqVars.add(varName);
                this.nonIntAddVars.add(varName);
            }
            this.handleExpression(edge, args.get(i), varName, i);
        }
        CFunctionSummaryEdge func = edge.getSummaryEdge();
        CFunctionCall statement = func.getExpression();
        Optional<CVariableDeclaration> returnVar = edge.getSuccessor().getReturnVariable();
        if (returnVar.isPresent()) {
            String scopedRetVal = returnVar.orElseThrow().getQualifiedName();
            if (statement instanceof CFunctionCallAssignmentStatement) {
                CFunctionCallAssignmentStatement call = (CFunctionCallAssignmentStatement)statement;
                CLeftHandSide lhs = call.getLeftHandSide();
                String function = VariableClassificationBuilder.isGlobal(lhs) ? null : edge.getPredecessor().getFunctionName();
                String varName = VariableClassificationBuilder.scopeVar(function, lhs.toASTString());
                this.allVars.add(scopedRetVal);
                this.allVars.add(varName);
                this.dependencies.add(scopedRetVal, varName);
            } else if (statement instanceof CFunctionCallStatement) {
                this.dependencies.addVar(scopedRetVal);
            }
        }
    }

    private void handleExpression(CFAEdge edge, CExpression exp, String varName) {
        this.handleExpression(edge, exp, varName, 0);
    }

    private void handleExpression(CFAEdge edge, CExpression exp, String varName, int id) {
        CFANode pre = edge.getPredecessor();
        VariablesCollectingVisitor dcv = new VariablesCollectingVisitor(pre);
        HashSet vars = exp.accept(dcv);
        if (vars == null) {
            vars = Sets.newHashSetWithExpectedSize((int)1);
        }
        vars.add(varName);
        this.allVars.addAll(vars);
        this.dependencies.addAll(vars, dcv.getValues(), edge, id);
        BoolCollectingVisitor bcv = new BoolCollectingVisitor(pre, this.nonIntBoolVars);
        Set<String> possibleBoolean = exp.accept(bcv);
        this.handleResult(varName, possibleBoolean, this.nonIntBoolVars);
        IntEqualCollectingVisitor ncv = new IntEqualCollectingVisitor(pre, this.nonIntEqVars);
        Set<String> possibleIntEqualVars = exp.accept(ncv);
        this.handleResult(varName, possibleIntEqualVars, this.nonIntEqVars);
        IntAddCollectingVisitor icv = new IntAddCollectingVisitor(pre, this.nonIntAddVars);
        Set<String> possibleIntAddVars = exp.accept(icv);
        this.handleResult(varName, possibleIntAddVars, this.nonIntAddVars);
        IntOverflowCollectingVisitor iov = new IntOverflowCollectingVisitor(pre, this.intOverflowVars);
        Set<String> possibleIntOverflowVars = exp.accept(iov);
        this.handleResult(varName, possibleIntOverflowVars, this.intOverflowVars);
    }

    private void handleResult(String varName, Collection<String> possibleVars, Collection<String> notPossibleVars) {
        if (possibleVars == null) {
            notPossibleVars.add(varName);
        }
    }

    static String scopeVar(@Nullable String function, String var) {
        Preconditions.checkNotNull((Object)var);
        return function == null ? var : function + SCOPE_SEPARATOR + var;
    }

    static boolean isGlobal(CExpression exp) {
        CSimpleDeclaration decl;
        if (Preconditions.checkNotNull((Object)exp) instanceof CIdExpression && (decl = ((CIdExpression)exp).getDeclaration()) instanceof CDeclaration) {
            return ((CDeclaration)decl).isGlobal();
        }
        return false;
    }

    public static BigInteger getNumber(CExpression exp) {
        Preconditions.checkNotNull((Object)exp);
        if (exp instanceof CIntegerLiteralExpression) {
            return ((CIntegerLiteralExpression)exp).getValue();
        }
        if (exp instanceof CUnaryExpression) {
            CUnaryExpression unExp = (CUnaryExpression)exp;
            BigInteger value = VariableClassificationBuilder.getNumber(unExp.getOperand());
            if (value == null) {
                return null;
            }
            switch (unExp.getOperator()) {
                case MINUS: {
                    return value.negate();
                }
            }
            return null;
        }
        if (exp instanceof CCastExpression) {
            return VariableClassificationBuilder.getNumber(((CCastExpression)exp).getOperand());
        }
        return null;
    }

    public static class VariableClassificationStatistics
    implements Statistics {
        private final StatTimer variableClassificationTimer = new StatTimer("Time for classifying variables");
        private final StatTimer collectTimer = new StatTimer("Time for collecting variables");
        private final StatTimer dependencyTimer = new StatTimer("Time for solving dependencies");
        private final StatTimer hierarchyTimer = new StatTimer("Time for building hierarchy");
        private final StatTimer buildTimer = new StatTimer("Time for building classification");
        private final StatTimer exportTimer = new StatTimer("Time for exporting data");

        @Override
        public String getName() {
            return "";
        }

        @Override
        public void printStatistics(PrintStream out, CPAcheckerResult.Result pResult, UnmodifiableReachedSet pReached) {
            if (this.variableClassificationTimer.getUpdateCount() > 0) {
                this.put(out, 3, this.variableClassificationTimer);
                this.put(out, 4, this.collectTimer);
                this.put(out, 4, this.dependencyTimer);
                this.put(out, 4, this.hierarchyTimer);
                this.put(out, 4, this.buildTimer);
                this.put(out, 4, this.exportTimer);
            }
        }
    }
}

