/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.variableclassification;

import com.google.common.base.Preconditions;
import org.sosy_lab.cpachecker.cfa.types.c.CCompositeType;

abstract class VariableOrField
implements Comparable<VariableOrField> {
    private VariableOrField() {
    }

    public static Variable newVariable(String scopedName) {
        return new Variable(scopedName);
    }

    public static Field newField(CCompositeType composite, String name) {
        return new Field(composite, name);
    }

    public static Unknown unknown() {
        return Unknown.INSTANCE;
    }

    public boolean isVariable() {
        return this instanceof Variable;
    }

    public boolean isField() {
        return this instanceof Field;
    }

    public boolean isUnknown() {
        return this instanceof Unknown;
    }

    public Variable asVariable() {
        if (this instanceof Variable) {
            return (Variable)this;
        }
        throw new ClassCastException("Tried to match " + this.getClass().getName() + " with " + Variable.class.getName());
    }

    public Field asField() {
        if (this instanceof Field) {
            return (Field)this;
        }
        throw new ClassCastException("Tried to match " + this.getClass().getName() + " with " + Field.class.getName());
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    @Override
    public abstract int compareTo(VariableOrField var1);

    static final class Field
    extends VariableOrField {
        private final CCompositeType composite;
        private final String name;
        private static final String SCOPE_SEPARATOR = "::";

        private Field(CCompositeType composite, String name) {
            this.composite = (CCompositeType)Preconditions.checkNotNull((Object)composite);
            this.name = (String)Preconditions.checkNotNull((Object)name);
        }

        public CCompositeType getCompositeType() {
            return this.composite;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.composite + SCOPE_SEPARATOR + this.name;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Field)) {
                return false;
            }
            Field other = (Field)o;
            return this.composite.equals(other.composite) && this.name.equals(other.name);
        }

        @Override
        public int compareTo(VariableOrField other) {
            if (this == other) {
                return 0;
            }
            if (other instanceof Unknown) {
                return 1;
            }
            if (other instanceof Variable) {
                return 1;
            }
            if (other instanceof Field) {
                Field o = (Field)other;
                int result = this.composite.getQualifiedName().compareTo(o.composite.getQualifiedName());
                return result != 0 ? result : this.name.compareTo(o.name);
            }
            Preconditions.checkNotNull((Object)other);
            throw new AssertionError((Object)"Should not happen: all cases are covered above");
        }

        @Override
        public int hashCode() {
            int prime = 67;
            return 67 * this.composite.hashCode() + this.name.hashCode();
        }
    }

    static final class Variable
    extends VariableOrField {
        private final String scopedName;

        private Variable(String scopedName) {
            this.scopedName = (String)Preconditions.checkNotNull((Object)scopedName);
        }

        public String getScopedName() {
            return this.scopedName;
        }

        public String toString() {
            return this.getScopedName();
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Variable)) {
                return false;
            }
            Variable other = (Variable)o;
            return this.scopedName.equals(other.scopedName);
        }

        @Override
        public int compareTo(VariableOrField other) {
            if (this == other) {
                return 0;
            }
            if (other instanceof Unknown) {
                return 1;
            }
            if (other instanceof Field) {
                return -1;
            }
            if (other instanceof Variable) {
                return this.scopedName.compareTo(((Variable)other).scopedName);
            }
            Preconditions.checkNotNull((Object)other);
            throw new AssertionError((Object)"Should not happen: all cases are covered above");
        }

        @Override
        public int hashCode() {
            return this.scopedName.hashCode();
        }
    }

    private static final class Unknown
    extends VariableOrField {
        private static final Unknown INSTANCE = new Unknown();

        private Unknown() {
        }

        public String toString() {
            return "<Unknown>";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            return o instanceof Unknown;
        }

        @Override
        public int compareTo(VariableOrField other) {
            if (this == other) {
                return 0;
            }
            if (other instanceof Variable) {
                return -1;
            }
            if (other instanceof Field) {
                return -1;
            }
            Preconditions.checkNotNull((Object)other);
            throw new AssertionError((Object)"Should not happen: all cases are covered above");
        }

        @Override
        public int hashCode() {
            return 7;
        }
    }
}

