/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.variableclassification;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.sosy_lab.cpachecker.cfa.ast.c.CAddressOfLabelExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCharLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CComplexCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionVisitor;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CFloatLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CImaginaryLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CPointerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CStringLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CTypeIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.exceptions.NoException;
import org.sosy_lab.cpachecker.util.variableclassification.VariableClassificationBuilder;

class VariablesCollectingVisitor
implements CExpressionVisitor<Set<String>, NoException> {
    private CFANode predecessor;
    private Set<BigInteger> values = new TreeSet<BigInteger>();

    public VariablesCollectingVisitor(CFANode pre) {
        this.predecessor = (CFANode)Preconditions.checkNotNull((Object)pre);
    }

    public Set<BigInteger> getValues() {
        return this.values;
    }

    @Override
    public Set<String> visit(CArraySubscriptExpression exp) {
        Preconditions.checkNotNull((Object)exp);
        return null;
    }

    @Override
    public Set<String> visit(CBinaryExpression exp) {
        Set<String> operand2;
        Set<String> operand1;
        BigInteger val1 = VariableClassificationBuilder.getNumber(exp.getOperand1());
        if (val1 == null) {
            operand1 = exp.getOperand1().accept(this);
        } else {
            this.values.add(val1);
            operand1 = null;
        }
        BigInteger val2 = VariableClassificationBuilder.getNumber(exp.getOperand2());
        if (val2 == null) {
            operand2 = exp.getOperand2().accept(this);
        } else {
            this.values.add(val2);
            operand2 = null;
        }
        if (operand1 == null) {
            return operand2;
        }
        if (operand2 == null) {
            return operand1;
        }
        operand1.addAll(operand2);
        return operand1;
    }

    @Override
    public Set<String> visit(CCastExpression exp) {
        BigInteger val = VariableClassificationBuilder.getNumber(exp.getOperand());
        if (val == null) {
            return exp.getOperand().accept(this);
        }
        this.values.add(val);
        return null;
    }

    @Override
    public Set<String> visit(CComplexCastExpression exp) {
        BigInteger val = VariableClassificationBuilder.getNumber(exp.getOperand());
        if (val == null) {
            return exp.getOperand().accept(this);
        }
        this.values.add(val);
        return null;
    }

    @Override
    public Set<String> visit(CFieldReference exp) {
        String varName = exp.toASTString();
        String function = VariableClassificationBuilder.isGlobal(exp) ? "" : this.predecessor.getFunctionName();
        HashSet ret = Sets.newHashSetWithExpectedSize((int)1);
        ret.add(VariableClassificationBuilder.scopeVar(function, varName));
        return ret;
    }

    @Override
    public Set<String> visit(CIdExpression exp) {
        HashSet ret = Sets.newHashSetWithExpectedSize((int)1);
        ret.add(exp.getDeclaration().getQualifiedName());
        return ret;
    }

    @Override
    public Set<String> visit(CCharLiteralExpression exp) {
        Preconditions.checkNotNull((Object)exp);
        return null;
    }

    @Override
    public Set<String> visit(CFloatLiteralExpression exp) {
        Preconditions.checkNotNull((Object)exp);
        return null;
    }

    @Override
    public Set<String> visit(CImaginaryLiteralExpression exp) {
        return exp.getValue().accept(this);
    }

    @Override
    public Set<String> visit(CIntegerLiteralExpression exp) {
        this.values.add(exp.getValue());
        return null;
    }

    @Override
    public Set<String> visit(CStringLiteralExpression exp) {
        Preconditions.checkNotNull((Object)exp);
        return null;
    }

    @Override
    public Set<String> visit(CTypeIdExpression exp) {
        Preconditions.checkNotNull((Object)exp);
        return null;
    }

    @Override
    public Set<String> visit(CUnaryExpression exp) {
        BigInteger val = VariableClassificationBuilder.getNumber(exp);
        if (val == null) {
            return exp.getOperand().accept(this);
        }
        this.values.add(val);
        return null;
    }

    @Override
    public Set<String> visit(CPointerExpression exp) {
        BigInteger val = VariableClassificationBuilder.getNumber(exp);
        if (val == null) {
            return exp.getOperand().accept(this);
        }
        this.values.add(val);
        return null;
    }

    @Override
    public Set<String> visit(CAddressOfLabelExpression exp) {
        Preconditions.checkNotNull((Object)exp);
        return null;
    }
}

