/*
 * Decompiled with CFR 0.152.
 */
package jsylvan;

import java.io.IOException;
import jsylvan.JSylvan;
import jsylvan.NativeUtils;

class MCFile {
    private long vectorSize;
    private long bitsPerInteger;
    private long initial;
    private long domain;
    private long[] relations;
    private long[] relation_domains;

    MCFile() {
    }

    private static native MCFile fromFile(String var0);

    public long bfs() {
        long level_counter = 1L;
        long states = this.initial;
        long new_states = JSylvan.ref(states);
        do {
            System.out.format("Level %d\n", level_counter++);
            long cur_states = new_states;
            new_states = JSylvan.getFalse();
            for (int i = 0; i < this.relations.length; ++i) {
                long a = JSylvan.ref(JSylvan.makeNext(cur_states, this.relations[i], this.relation_domains[i]));
                long b = JSylvan.ref(JSylvan.makeIte(states, JSylvan.getFalse(), a));
                JSylvan.deref(a);
                long c = JSylvan.ref(JSylvan.makeOr(new_states, b));
                JSylvan.deref(b);
                JSylvan.deref(new_states);
                new_states = c;
            }
            JSylvan.deref(cur_states);
            long temp = JSylvan.ref(JSylvan.makeOr(states, new_states));
            JSylvan.deref(states);
            states = temp;
        } while (new_states != JSylvan.getFalse());
        JSylvan.deref(new_states);
        return states;
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("Use: jsylvan.MCFile <filename> [workers]");
            return;
        }
        try {
            NativeUtils.loadLibraryFromJar("/native/libsylvan-1.so");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        if (args.length == 2) {
            JSylvan.initialize(Integer.parseInt(args[1]), 100000L, 30, 26, 4);
        } else {
            JSylvan.initialize(4L, 100000L, 30, 26, 4);
        }
        MCFile f = MCFile.fromFile(args[0]);
        System.out.format("Read '%s': state vector: %d ints, %d bits per int, %d transition groups\n", args[0], f.vectorSize, f.bitsPerInteger, f.relations.length);
        System.out.format("Initial states: %d BDD nodes\n", JSylvan.nodecount(f.initial));
        for (int i = 0; i < f.relations.length; ++i) {
            System.out.format("Transition %d: %d BDD nodes\n", i, JSylvan.nodecount(f.relations[i]));
        }
        long t1 = System.nanoTime();
        long result = f.bfs();
        long t2 = System.nanoTime();
        System.out.format("Expired time: %d.%d seconds\n", (t2 - t1) / 1000000000L, (t2 - t1) % 1000000000L);
        System.out.format("Final result: %.0f states\n", JSylvan.satcount(result, f.domain));
        System.out.format("Final result: %d nodes\n", JSylvan.nodecount(result));
    }
}

