/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lassoranker;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.LinkedHashMap;
import java.util.Map;

public class AffineTerm
implements Serializable {
    private static final long serialVersionUID = -4454719554662175493L;
    private Rational mConstant;
    private final Map<Term, Rational> mCoefficients;

    public AffineTerm() {
        this.mCoefficients = new LinkedHashMap<Term, Rational>();
        this.mConstant = Rational.ZERO;
    }

    public AffineTerm(AffineTerm at) {
        this.mConstant = at.mConstant;
        this.mCoefficients = new LinkedHashMap<Term, Rational>(at.mCoefficients);
    }

    public AffineTerm(BigInteger i) {
        this();
        this.mConstant = Rational.valueOf((BigInteger)i, (BigInteger)BigInteger.ONE);
    }

    public AffineTerm(Rational r) {
        this();
        this.mConstant = r;
    }

    public AffineTerm(Term var, Rational r) {
        this();
        this.mCoefficients.put(var, r);
    }

    public boolean isConstant() {
        return this.mCoefficients.isEmpty();
    }

    public boolean isZero() {
        return this.mCoefficients.isEmpty() && this.mConstant.equals((Object)Rational.ZERO);
    }

    public Rational getConstant() {
        return this.mConstant;
    }

    public void add(Rational r) {
        this.mConstant = this.mConstant.add(r);
    }

    public void add(Term var, Rational c) {
        if (this.mCoefficients.containsKey(var)) {
            Rational r = this.mCoefficients.get(var).add(c);
            if (!r.equals((Object)Rational.ZERO)) {
                this.mCoefficients.put(var, r);
            } else {
                this.mCoefficients.remove(var);
            }
        } else if (!c.equals((Object)Rational.ZERO)) {
            this.mCoefficients.put(var, c);
        }
    }

    public void add(AffineTerm p) {
        this.add(p.mConstant);
        for (Map.Entry<Term, Rational> entry : p.mCoefficients.entrySet()) {
            this.add(entry.getKey(), entry.getValue());
        }
    }

    public void mult(Rational r) {
        this.mConstant = this.mConstant.mul(r);
        for (Map.Entry<Term, Rational> var : this.mCoefficients.entrySet()) {
            this.mCoefficients.put(var.getKey(), var.getValue().mul(r));
        }
    }

    public Term asRealTerm(Script script) {
        Term[] summands = new Term[this.mCoefficients.size() + 1];
        int i = 0;
        for (Map.Entry<Term, Rational> entry : this.mCoefficients.entrySet()) {
            Term coeff = entry.getValue().toTerm(SmtSortUtils.getRealSort((Script)script));
            summands[i] = script.term("*", new Term[]{coeff, entry.getKey()});
            ++i;
        }
        summands[i] = this.mConstant.toTerm(SmtSortUtils.getRealSort((Script)script));
        return SmtUtils.sum((Script)script, (Sort)SmtSortUtils.getRealSort((Script)script), (Term[])summands);
    }

    public Term asIntTerm(Script script) {
        Term[] summands = new Term[this.mCoefficients.size() + 1];
        int i = 0;
        for (Map.Entry<Term, Rational> entry : this.mCoefficients.entrySet()) {
            assert (entry.getValue().isIntegral());
            Term coeff = SmtUtils.constructIntValue((Script)script, (BigInteger)entry.getValue().numerator());
            summands[i] = script.term("*", new Term[]{coeff, entry.getKey()});
            ++i;
        }
        assert (this.mConstant.isIntegral());
        summands[i] = SmtUtils.constructIntValue((Script)script, (BigInteger)this.mConstant.numerator());
        return SmtUtils.sum((Script)script, (Sort)SmtSortUtils.getIntSort((Script)script), (Term[])summands);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Map.Entry<Term, Rational> entry : this.mCoefficients.entrySet()) {
            if (entry.getValue().isNegative() || !first) {
                if (!first) {
                    sb.append(" ");
                }
                sb.append(entry.getValue().isNegative() ? "- " : "+ ");
            }
            sb.append(entry.getValue().abs() + "*" + entry.getKey());
            first = false;
        }
        if (!this.mConstant.equals((Object)Rational.ZERO) || sb.length() == 0) {
            if (this.mConstant.isNegative() || !first) {
                if (!first) {
                    sb.append(" ");
                }
                sb.append(this.mConstant.isNegative() ? "- " : "+ ");
            }
            sb.append(this.mConstant.abs());
        }
        return sb.toString();
    }
}

