/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lassoranker;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.TermException;
import de.uni_freiburg.informatik.ultimate.lassoranker.ILassoRankerPreferences;
import de.uni_freiburg.informatik.ultimate.lassoranker.Lasso;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.io.Closeable;
import java.io.IOException;

public abstract class ArgumentSynthesizer
implements Closeable {
    protected final ILogger mLogger;
    public static final String SOLVER_UNKNOWN_MESSAGE = "Warning solver responded UNKNOWN to the check-sat above";
    protected final Script mScript;
    protected final Lasso mLasso;
    protected final ILassoRankerPreferences mPreferences;
    private boolean mSynthesisSuccessful = false;
    private boolean mClosed = false;
    protected IUltimateServiceProvider mServices;

    public ArgumentSynthesizer(Lasso lasso, ILassoRankerPreferences preferences, String constaintsName, IUltimateServiceProvider services) throws IOException {
        this.mLogger = services.getLoggingService().getLogger("Library-LassoRanker");
        this.mPreferences = preferences;
        this.mLasso = lasso;
        this.mServices = services;
        this.mScript = this.constructScript(this.mPreferences, constaintsName);
    }

    protected abstract Script constructScript(ILassoRankerPreferences var1, String var2);

    public Script getScript() {
        return this.mScript;
    }

    public boolean synthesisSuccessful() {
        return this.mSynthesisSuccessful;
    }

    public final Script.LBool synthesize() throws SMTLIBException, TermException, IOException {
        Script.LBool lBool = this.doSynthesis();
        this.mSynthesisSuccessful = lBool == Script.LBool.SAT;
        return lBool;
    }

    protected abstract Script.LBool doSynthesis() throws SMTLIBException, TermException, IOException;

    public Term newConstant(String name, String sortname) throws SMTLIBException {
        return SmtUtils.buildNewConstant((Script)this.mScript, (String)name, (String)sortname);
    }

    @Override
    public void close() {
        if (!this.mClosed) {
            this.mScript.exit();
            this.mClosed = true;
        }
    }

    protected void finalize() throws Throwable {
        this.close();
    }
}

