/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lassoranker;

import de.uni_freiburg.informatik.ultimate.lassoranker.AffineTerm;
import de.uni_freiburg.informatik.ultimate.lassoranker.LinearInequality;
import de.uni_freiburg.informatik.ultimate.lassoranker.LinearTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Lasso
implements Serializable {
    private static final long serialVersionUID = 8922273828007750770L;
    private final LinearTransition mStem;
    private final LinearTransition mLoop;

    public Lasso(LinearTransition stem, LinearTransition loop) {
        LinearTransition newStem = Lasso.balanceVariablesStem(stem, loop);
        LinearTransition newLoop = Lasso.balanceVariablesLoop(stem, loop);
        this.mStem = newStem == null ? LinearTransition.getTranstionTrue() : newStem;
        this.mLoop = newLoop == null ? LinearTransition.getTranstionTrue() : newLoop;
    }

    public LinearTransition getStem() {
        assert (this.mStem != null);
        return this.mStem;
    }

    public LinearTransition getLoop() {
        assert (this.mLoop != null);
        return this.mLoop;
    }

    public int getLoopVarNum() {
        return this.mLoop.getVariables().size();
    }

    public int getStemVarNum() {
        return this.mStem.getVariables().size();
    }

    public int getLoopDisjuncts() {
        return this.mLoop.getNumPolyhedra();
    }

    public int getStemDisjuncts() {
        return this.mStem.getNumPolyhedra();
    }

    public Collection<IProgramVar> getAllRankVars() {
        LinkedHashSet<IProgramVar> rankVars = new LinkedHashSet<IProgramVar>();
        rankVars.addAll(this.mStem.getInVars().keySet());
        rankVars.addAll(this.mStem.getOutVars().keySet());
        rankVars.addAll(this.mLoop.getInVars().keySet());
        rankVars.addAll(this.mLoop.getOutVars().keySet());
        return rankVars;
    }

    public Rational[] guessEigenvalues(boolean includeNegative) {
        HashSet<Rational> motzkinCoeffs = new HashSet<Rational>();
        motzkinCoeffs.add(Rational.ZERO);
        motzkinCoeffs.add(Rational.ONE);
        for (List<LinearInequality> polyhedron : this.mLoop.getPolyhedra()) {
            HashMap aliases = new HashMap();
            for (LinearInequality linearInequality : polyhedron) {
                if (linearInequality.isStrict() || !linearInequality.getConstant().isZero() || linearInequality.getVariables().size() != 2) continue;
                Term[] vars = linearInequality.getVariables().toArray(new Term[2]);
                AffineTerm at0 = linearInequality.getCoefficient(vars[0]);
                AffineTerm at1 = linearInequality.getCoefficient(vars[1]);
                assert (!at0.isZero());
                assert (!at1.isZero());
                if (!at0.isConstant() || !at1.isConstant() || !at0.getConstant().equals((Object)at1.getConstant().negate())) continue;
                Term var0 = vars[0];
                Term var1 = vars[1];
                if (at0.getConstant().isNegative()) {
                    Term var2 = var0;
                    var0 = var1;
                    var1 = var2;
                }
                if (!aliases.containsKey(var0)) {
                    aliases.put(var0, new HashSet());
                }
                ((Set)aliases.get(var0)).add(var1);
            }
            for (Map.Entry entry : this.mLoop.getOutVars().entrySet()) {
                IProgramVar rkVar = (IProgramVar)entry.getKey();
                Term outVar = (Term)entry.getValue();
                if (!this.mLoop.getInVars().containsKey(rkVar)) continue;
                ArrayList<Term> possibleInVars = new ArrayList<Term>();
                Term inVar = (Term)this.mLoop.getInVars().get(rkVar);
                possibleInVars.add(inVar);
                if (aliases.containsKey(inVar)) {
                    for (Term aliasVar : (Set)aliases.get(inVar)) {
                        if (!aliases.containsKey(aliasVar) || !((Set)aliases.get(aliasVar)).contains(inVar)) continue;
                        possibleInVars.add(aliasVar);
                    }
                }
                for (LinearInequality li : polyhedron) {
                    for (Term aliasVar : possibleInVars) {
                        AffineTerm cIn = li.getCoefficient(aliasVar);
                        AffineTerm cOut = li.getCoefficient(outVar);
                        if (cIn.isZero() || cOut.isZero()) continue;
                        assert (cIn.isConstant());
                        assert (cOut.isConstant());
                        Rational eigenv = cIn.getConstant().div(cOut.getConstant()).negate();
                        if (eigenv.isNegative() && !includeNegative) continue;
                        motzkinCoeffs.add(eigenv);
                    }
                }
            }
        }
        return motzkinCoeffs.toArray(new Rational[motzkinCoeffs.size()]);
    }

    private static LinearTransition balanceVariablesStem(LinearTransition stem, LinearTransition loop) {
        if (stem == null || loop == null) {
            return stem;
        }
        HashMap<IProgramVar, TermVariable> addVars = new HashMap<IProgramVar, TermVariable>();
        for (Map.Entry<IProgramVar, TermVariable> entry : loop.getInVars().entrySet()) {
            if (stem.getInVars().containsKey(entry.getKey()) || stem.getOutVars().containsKey(entry.getKey())) continue;
            addVars.put(entry.getKey(), entry.getValue());
        }
        if (!addVars.isEmpty()) {
            HashMap<IProgramVar, TermVariable> inVars = new HashMap<IProgramVar, TermVariable>(stem.getInVars());
            HashMap<IProgramVar, TermVariable> outVars = new HashMap<IProgramVar, TermVariable>(stem.getOutVars());
            inVars.putAll(addVars);
            outVars.putAll(addVars);
            return new LinearTransition(stem.getPolyhedra(), inVars, outVars);
        }
        return stem;
    }

    private static LinearTransition balanceVariablesLoop(LinearTransition stem, LinearTransition loop) {
        if (stem == null || loop == null) {
            return loop;
        }
        HashMap<IProgramVar, TermVariable> addVars = new HashMap<IProgramVar, TermVariable>();
        for (Map.Entry<IProgramVar, TermVariable> entry : stem.getOutVars().entrySet()) {
            if (loop.getInVars().containsKey(entry.getKey()) || loop.getOutVars().containsKey(entry.getKey())) continue;
            addVars.put(entry.getKey(), entry.getValue());
        }
        if (!addVars.isEmpty()) {
            HashMap<IProgramVar, TermVariable> inVars = new HashMap<IProgramVar, TermVariable>(loop.getInVars());
            HashMap<IProgramVar, TermVariable> outVars = new HashMap<IProgramVar, TermVariable>(loop.getOutVars());
            inVars.putAll(addVars);
            outVars.putAll(addVars);
            return new LinearTransition(loop.getPolyhedra(), inVars, outVars);
        }
        return loop;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Stem: ");
        sb.append(this.mStem);
        sb.append("\nLoop: ");
        sb.append(this.mLoop);
        return sb.toString();
    }
}

