/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lassoranker;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.AddSymbols;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.CommuHashPreprocessor;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.DNF;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.MatchInOutVars;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.RemoveNegation;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.RewriteBooleans;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.RewriteDivision;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.RewriteEquality;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.RewriteIte;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.RewriteStrictInequalities;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.RewriteTrueFalse;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.RewriteUserDefinedTypes;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.SimplifyPreprocessor;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.TermException;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.TransitionPreprocessor;
import de.uni_freiburg.informatik.ultimate.lassoranker.ILassoRankerPreferences;
import de.uni_freiburg.informatik.ultimate.lassoranker.Lasso;
import de.uni_freiburg.informatik.ultimate.lassoranker.LassoRankerPreferences;
import de.uni_freiburg.informatik.ultimate.lassoranker.LinearTransition;
import de.uni_freiburg.informatik.ultimate.lassoranker.nontermination.GeometricNonTerminationArgument;
import de.uni_freiburg.informatik.ultimate.lassoranker.nontermination.INonTerminationAnalysisSettings;
import de.uni_freiburg.informatik.ultimate.lassoranker.nontermination.NonTerminationAnalysisSettings;
import de.uni_freiburg.informatik.ultimate.lassoranker.nontermination.NonTerminationArgumentSynthesizer;
import de.uni_freiburg.informatik.ultimate.lassoranker.preprocessors.LassoPartitioneerPreprocessor;
import de.uni_freiburg.informatik.ultimate.lassoranker.preprocessors.LassoPreprocessor;
import de.uni_freiburg.informatik.ultimate.lassoranker.preprocessors.MapEliminationLassoPreprocessor;
import de.uni_freiburg.informatik.ultimate.lassoranker.preprocessors.RewriteArrays2;
import de.uni_freiburg.informatik.ultimate.lassoranker.preprocessors.StemAndLoopPreprocessor;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.NonterminationAnalysisBenchmark;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.TerminationAnalysisBenchmark;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.TerminationAnalysisSettings;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.TerminationArgument;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.TerminationArgumentSynthesizer;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.templates.RankingTemplate;
import de.uni_freiburg.informatik.ultimate.lassoranker.variables.LassoBuilder;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.SmtFunctionsAndAxioms;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramNonOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.SMTPrettyPrinter;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.util.DebugMessage;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class LassoAnalysis {
    private final ILogger mLogger;
    private final SmtUtils.SimplificationTechnique mSimplificationTechnique;
    private final SmtUtils.XnfConversionTechnique mXnfConversionTechnique;
    private final UnmodifiableTransFormula mStemTransition;
    private final UnmodifiableTransFormula mLoopTransition;
    private Collection<Lasso> mLassos;
    private final Set<IProgramNonOldVar> mModifiableGlobalsAtHonda;
    protected final SmtFunctionsAndAxioms mSmtSymbols;
    protected final ILassoRankerPreferences mPreferences;
    protected final Set<Term> mArrayIndexSupportingInvariants;
    private final IIcfgSymbolTable mSymbolTable;
    private final ManagedScript mMgdScript;
    private final IUltimateServiceProvider mServices;
    private final List<TerminationAnalysisBenchmark> mLassoTerminationAnalysisBenchmarks;
    private final List<NonterminationAnalysisBenchmark> mLassoNonterminationAnalysisBenchmarks;
    private PreprocessingBenchmark mPreprocessingBenchmark;
    private final CfgSmtToolkit mCfgSmtToolkit;

    public LassoAnalysis(CfgSmtToolkit csToolkit, UnmodifiableTransFormula stemTransition, UnmodifiableTransFormula loopTransition, Set<IProgramNonOldVar> modifiableGlobalsAtHonda, SmtFunctionsAndAxioms smtSymbols, ILassoRankerPreferences preferences, IUltimateServiceProvider services, SmtUtils.SimplificationTechnique simplificationTechnique, SmtUtils.XnfConversionTechnique xnfConversionTechnique) throws TermException {
        this.mServices = services;
        this.mSimplificationTechnique = simplificationTechnique;
        this.mXnfConversionTechnique = xnfConversionTechnique;
        this.mLogger = this.mServices.getLoggingService().getLogger("Library-LassoRanker");
        this.mPreferences = preferences;
        this.mLogger.info((Object)"Preferences:");
        this.mPreferences.feedSettingsString(arg_0 -> ((ILogger)this.mLogger).info(arg_0));
        this.mSmtSymbols = smtSymbols;
        this.mArrayIndexSupportingInvariants = new HashSet<Term>();
        this.mMgdScript = csToolkit.getManagedScript();
        this.mCfgSmtToolkit = csToolkit;
        this.mSymbolTable = csToolkit.getSymbolTable();
        this.mLassoTerminationAnalysisBenchmarks = new ArrayList<TerminationAnalysisBenchmark>();
        this.mLassoNonterminationAnalysisBenchmarks = new ArrayList<NonterminationAnalysisBenchmark>();
        this.mStemTransition = stemTransition;
        this.mLoopTransition = loopTransition;
        this.mModifiableGlobalsAtHonda = modifiableGlobalsAtHonda;
        assert (this.mLoopTransition != null);
        this.preprocess();
    }

    public LassoAnalysis(CfgSmtToolkit csToolkit, IIcfgSymbolTable symbolTable, UnmodifiableTransFormula loop, Set<IProgramNonOldVar> modifiableGlobalsAtHonda, SmtFunctionsAndAxioms symbols, LassoRankerPreferences preferences, IUltimateServiceProvider services, SmtUtils.XnfConversionTechnique xnfConversionTechnique, SmtUtils.SimplificationTechnique simplificationTechnique) throws TermException, FileNotFoundException {
        this(csToolkit, null, loop, modifiableGlobalsAtHonda, symbols, (ILassoRankerPreferences)preferences, services, simplificationTechnique, xnfConversionTechnique);
    }

    protected void preprocess() throws TermException {
        this.mLogger.info((Object)"Starting lasso preprocessing...");
        LassoBuilder lassoBuilder = new LassoBuilder(this.mLogger, this.mCfgSmtToolkit, this.mStemTransition, this.mLoopTransition, this.mPreferences.getNlaHandling());
        assert (lassoBuilder.isSane("initial lasso construction"));
        lassoBuilder.preprocess(this.getPreProcessors(lassoBuilder, this.mPreferences.isOverapproximateArrayIndexConnection()), this.getPreProcessors(lassoBuilder, false));
        this.mPreprocessingBenchmark = lassoBuilder.getPreprocessingBenchmark();
        lassoBuilder.constructPolyhedra();
        this.mLassos = lassoBuilder.getLassos();
        this.mLogger.debug((Object)new DebugMessage("Original stem:\n{0}", new Object[]{this.mStemTransition}));
        this.mLogger.debug((Object)new DebugMessage("Original loop:\n{0}", new Object[]{this.mLoopTransition}));
        this.mLogger.debug((Object)new DebugMessage("After preprocessing:\n{0}", new Object[]{lassoBuilder}));
        this.mLogger.debug((Object)("Guesses for Motzkin coefficients: " + LassoAnalysis.eigenvalueGuesses(this.mLassos)));
        this.mLogger.info((Object)"Preprocessing complete.");
    }

    protected LassoPreprocessor[] getPreProcessors(LassoBuilder lassoBuilder, boolean overapproximateArrayIndexConnection) {
        LassoPreprocessor mapElimination = this.mPreferences.isUseOldMapElimination() ? new RewriteArrays2(true, this.mStemTransition, this.mLoopTransition, this.mModifiableGlobalsAtHonda, this.mServices, this.mArrayIndexSupportingInvariants, this.mSymbolTable, this.mMgdScript, lassoBuilder.getReplacementVarFactory(), this.mSimplificationTechnique, this.mXnfConversionTechnique) : new MapEliminationLassoPreprocessor(this.mServices, this.mMgdScript, this.mSymbolTable, lassoBuilder.getReplacementVarFactory(), this.mStemTransition, this.mLoopTransition, this.mModifiableGlobalsAtHonda, this.mArrayIndexSupportingInvariants, this.mPreferences.getMapEliminationSettings(this.mSimplificationTechnique, this.mXnfConversionTechnique));
        return new LassoPreprocessor[]{new StemAndLoopPreprocessor(this.mMgdScript, (TransitionPreprocessor)new MatchInOutVars()), new StemAndLoopPreprocessor(this.mMgdScript, (TransitionPreprocessor)new AddSymbols(lassoBuilder.getReplacementVarFactory(), this.mSmtSymbols)), new StemAndLoopPreprocessor(this.mMgdScript, (TransitionPreprocessor)new CommuHashPreprocessor(this.mServices)), this.mPreferences.isEnablePartitioneer() ? new LassoPartitioneerPreprocessor(this.mMgdScript, this.mServices, this.mXnfConversionTechnique) : null, mapElimination, new StemAndLoopPreprocessor(this.mMgdScript, (TransitionPreprocessor)new MatchInOutVars()), this.mPreferences.isEnablePartitioneer() ? new LassoPartitioneerPreprocessor(this.mMgdScript, this.mServices, this.mXnfConversionTechnique) : null, new StemAndLoopPreprocessor(this.mMgdScript, (TransitionPreprocessor)new RewriteDivision(lassoBuilder.getReplacementVarFactory())), new StemAndLoopPreprocessor(this.mMgdScript, (TransitionPreprocessor)new RewriteBooleans(lassoBuilder.getReplacementVarFactory(), this.mMgdScript)), new StemAndLoopPreprocessor(this.mMgdScript, (TransitionPreprocessor)new RewriteIte()), new StemAndLoopPreprocessor(this.mMgdScript, (TransitionPreprocessor)new RewriteUserDefinedTypes(lassoBuilder.getReplacementVarFactory(), this.mMgdScript)), new StemAndLoopPreprocessor(this.mMgdScript, (TransitionPreprocessor)new RewriteEquality()), new StemAndLoopPreprocessor(this.mMgdScript, (TransitionPreprocessor)new CommuHashPreprocessor(this.mServices)), new StemAndLoopPreprocessor(this.mMgdScript, (TransitionPreprocessor)new SimplifyPreprocessor(this.mServices, this.mSimplificationTechnique)), new StemAndLoopPreprocessor(this.mMgdScript, (TransitionPreprocessor)new DNF(this.mServices, this.mXnfConversionTechnique)), new StemAndLoopPreprocessor(this.mMgdScript, (TransitionPreprocessor)new SimplifyPreprocessor(this.mServices, this.mSimplificationTechnique)), new StemAndLoopPreprocessor(this.mMgdScript, (TransitionPreprocessor)new RewriteTrueFalse()), new StemAndLoopPreprocessor(this.mMgdScript, (TransitionPreprocessor)new RemoveNegation()), new StemAndLoopPreprocessor(this.mMgdScript, (TransitionPreprocessor)new RewriteStrictInequalities())};
    }

    public Collection<Lasso> getLassos() {
        return this.mLassos;
    }

    public List<TerminationAnalysisBenchmark> getTerminationAnalysisBenchmarks() {
        return this.mLassoTerminationAnalysisBenchmarks;
    }

    public List<NonterminationAnalysisBenchmark> getNonterminationAnalysisBenchmarks() {
        return this.mLassoNonterminationAnalysisBenchmarks;
    }

    public PreprocessingBenchmark getPreprocessingBenchmark() {
        return this.mPreprocessingBenchmark;
    }

    protected String benchmarkScriptMessage(Script.LBool constraintSat, RankingTemplate template) {
        StringBuilder sb = new StringBuilder();
        sb.append("BenchmarkResult: ");
        sb.append(constraintSat);
        sb.append(" for template ");
        sb.append(template.getName());
        sb.append(" with degree ");
        sb.append(template.getDegree());
        sb.append(". ");
        sb.append(this.mLassoTerminationAnalysisBenchmarks.toString());
        return sb.toString();
    }

    protected static String eigenvalueGuesses(Collection<Lasso> lassos) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (Lasso lasso : lassos) {
            Rational[] eigenvalues = lasso.guessEigenvalues(true);
            int i = 0;
            while (i < eigenvalues.length) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(eigenvalues[i].toString());
                ++i;
            }
        }
        sb.append("]");
        return sb.toString();
    }

    public GeometricNonTerminationArgument checkNonTermination(NonTerminationAnalysisSettings settings) throws SMTLIBException, TermException, IOException {
        this.mLogger.info((Object)"Checking for nontermination...");
        ArrayList<GeometricNonTerminationArgument> ntas = new ArrayList<GeometricNonTerminationArgument>(this.mLassos.size());
        if (this.mLassos.isEmpty()) {
            this.mLassos.add(new Lasso(LinearTransition.getTranstionTrue(), LinearTransition.getTranstionTrue()));
        }
        for (Lasso lasso : this.mLassos) {
            long startTime = System.nanoTime();
            NonTerminationAnalysisSettings gev0settings = LassoAnalysis.constructGev0Copy(settings);
            NonTerminationArgumentSynthesizer nas = new NonTerminationArgumentSynthesizer(lasso, this.mPreferences, gev0settings, this.mServices);
            Script.LBool constraintSat = nas.synthesize();
            if (constraintSat == Script.LBool.UNSAT) {
                nas.close();
                nas = new NonTerminationArgumentSynthesizer(lasso, this.mPreferences, settings, this.mServices);
                constraintSat = nas.synthesize();
            }
            long endTime = System.nanoTime();
            boolean isFixpoint = constraintSat == Script.LBool.SAT ? nas.getArgument().getLambdas().isEmpty() || nas.getArgument().getGEVs().isEmpty() : false;
            NonterminationAnalysisBenchmark nab = new NonterminationAnalysisBenchmark(constraintSat, isFixpoint, lasso.getStemVarNum(), lasso.getLoopVarNum(), lasso.getStemDisjuncts(), lasso.getLoopDisjuncts(), endTime - startTime);
            this.mLassoNonterminationAnalysisBenchmarks.add(nab);
            if (constraintSat == Script.LBool.SAT) {
                this.mLogger.info((Object)"Proved nontermination for one component.");
                GeometricNonTerminationArgument nta = nas.getArgument();
                ntas.add(nta);
                this.mLogger.info((Object)nta);
            } else if (constraintSat == Script.LBool.UNKNOWN) {
                this.mLogger.info((Object)"Proving nontermination failed: SMT Solver returned 'unknown'.");
            } else if (constraintSat == Script.LBool.UNSAT) {
                this.mLogger.info((Object)"Proving nontermination failed: No geometric nontermination argument exists.");
            } else assert (false);
            nas.close();
            if (constraintSat == Script.LBool.SAT) continue;
            return null;
        }
        assert (!ntas.isEmpty());
        GeometricNonTerminationArgument nta = (GeometricNonTerminationArgument)ntas.get(0);
        int i = 1;
        while (i < ntas.size()) {
            nta = nta.join((GeometricNonTerminationArgument)ntas.get(i));
            ++i;
        }
        return nta;
    }

    private static NonTerminationAnalysisSettings constructGev0Copy(INonTerminationAnalysisSettings settings) {
        return new NonTerminationAnalysisSettings(new NonTerminationAnalysisSettings(settings){
            private static final long serialVersionUID = 1L;

            @Override
            public int getNumberOfGevs() {
                return 0;
            }
        });
    }

    public TerminationArgument tryTemplate(RankingTemplate template, TerminationAnalysisSettings settings) throws SMTLIBException, TermException, IOException {
        this.mLogger.info((Object)("Using template '" + template.getName() + "'."));
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)template);
        }
        for (Lasso lasso : this.mLassos) {
            long startTime = System.nanoTime();
            TerminationArgumentSynthesizer tas = new TerminationArgumentSynthesizer(lasso, template, this.mPreferences, settings, this.mArrayIndexSupportingInvariants, this.mServices);
            Script.LBool constraintSat = tas.synthesize();
            long endTime = System.nanoTime();
            TerminationAnalysisBenchmark tab = new TerminationAnalysisBenchmark(constraintSat, lasso.getStemVarNum(), lasso.getLoopVarNum(), lasso.getStemDisjuncts(), lasso.getLoopDisjuncts(), template.getName(), template.getDegree(), tas.getNumSIs(), tas.getNumMotzkin(), endTime - startTime);
            this.mLassoTerminationAnalysisBenchmarks.add(tab);
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug((Object)this.benchmarkScriptMessage(constraintSat, template));
            }
            if (constraintSat == Script.LBool.SAT) {
                this.mLogger.info((Object)"Proved termination.");
                TerminationArgument ta = tas.getArgument();
                this.mLogger.info((Object)ta);
                if (this.mLogger.isDebugEnabled()) {
                    Term[] lexTerm;
                    Term[] termArray = lexTerm = ta.getRankingFunction().asLexTerm(this.mMgdScript.getScript());
                    int n = lexTerm.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Term t = termArray[n2];
                        this.mLogger.debug((Object)new DebugMessage("{0}", new Object[]{new SMTPrettyPrinter(t)}));
                        ++n2;
                    }
                }
                tas.close();
                return ta;
            }
            if (constraintSat == Script.LBool.UNKNOWN) {
                this.mLogger.info((Object)"Proving termination failed: SMT Solver returned 'unknown'.");
            } else if (constraintSat == Script.LBool.UNSAT) {
                this.mLogger.info((Object)"Proving termination failed for this template and these settings.");
            } else assert (false);
            tas.close();
        }
        return null;
    }

    public static enum AnalysisTechnique {
        RANKING_FUNCTIONS_SUPPORTING_INVARIANTS,
        GEOMETRIC_NONTERMINATION_ARGUMENTS;

    }

    public static class PreprocessingBenchmark {
        private final int mIntialMaxDagSizeLassos;
        private final List<String> mPreprocessors = new ArrayList<String>();
        private final List<Integer> mMaxDagSizeLassosAbsolut = new ArrayList<Integer>();
        private final List<Float> mMaxDagSizeLassosRelative = new ArrayList<Float>();

        public PreprocessingBenchmark(long l) {
            this.mIntialMaxDagSizeLassos = Math.toIntExact(l);
        }

        public void addPreprocessingData(String description, int maxDagSizeNontermination, int maxDagSizeLassos) {
            this.mPreprocessors.add(description);
            this.mMaxDagSizeLassosAbsolut.add(maxDagSizeLassos);
            this.mMaxDagSizeLassosRelative.add(Float.valueOf(this.computeQuotiontOfLastTwoEntries(this.mMaxDagSizeLassosAbsolut, this.mIntialMaxDagSizeLassos)));
        }

        public void addPreprocessingData(String description, long l) {
            this.mPreprocessors.add(description);
            this.mMaxDagSizeLassosAbsolut.add(Math.toIntExact(l));
            this.mMaxDagSizeLassosRelative.add(Float.valueOf(this.computeQuotiontOfLastTwoEntries(this.mMaxDagSizeLassosAbsolut, this.mIntialMaxDagSizeLassos)));
        }

        public float computeQuotiontOfLastTwoEntries(List<Integer> list, int initialValue) {
            if (list.isEmpty()) {
                throw new IllegalArgumentException();
            }
            double lastEntry = list.get(list.size() - 1).intValue();
            double secondLastEntry = list.size() == 1 ? (double)initialValue : (double)list.get(list.size() - 2).intValue();
            return (float)(lastEntry / secondLastEntry);
        }

        public int getIntialMaxDagSizeLassos() {
            return this.mIntialMaxDagSizeLassos;
        }

        public List<String> getPreprocessors() {
            return this.mPreprocessors;
        }

        public List<String> getPreprocessorsNon() {
            return this.mPreprocessors;
        }

        public List<Float> getMaxDagSizeLassosRelative() {
            return this.mMaxDagSizeLassosRelative;
        }

        public static String prettyprint(List<PreprocessingBenchmark> benchmarks) {
            if (benchmarks.isEmpty()) {
                return "";
            }
            List<String> preprocessors = benchmarks.get(0).getPreprocessors();
            List<String> preprocessorAbbreviations = PreprocessingBenchmark.computeAbbrev(preprocessors);
            float[] lassosData = new float[preprocessors.size()];
            int lassosAverageInitial = 0;
            for (PreprocessingBenchmark pb : benchmarks) {
                PreprocessingBenchmark.addListElements(lassosData, pb.getMaxDagSizeLassosRelative());
                lassosAverageInitial += pb.getIntialMaxDagSizeLassos();
            }
            PreprocessingBenchmark.divideAllEntries(lassosData, benchmarks.size());
            lassosAverageInitial /= benchmarks.size();
            StringBuilder sb = new StringBuilder();
            sb.append("  ");
            sb.append("Lassos: ");
            sb.append("inital");
            sb.append(lassosAverageInitial);
            sb.append(" ");
            sb.append(PreprocessingBenchmark.ppOne(lassosData, preprocessorAbbreviations));
            return sb.toString();
        }

        private static List<String> computeAbbrev(List<String> preprocessors) {
            ArrayList<String> result = new ArrayList<String>();
            for (String description : preprocessors) {
                result.add(PreprocessingBenchmark.computeAbbrev(description));
            }
            return result;
        }

        private static String computeAbbrev(String ppId) {
            switch (ppId) {
                case "Transform into disjunctive normal form": {
                    return "dnf";
                }
                case "Simplify formula using some simplification technique": {
                    return "smp";
                }
                case "Removes arrays by introducing new variables for each relevant array cell": {
                    return "arr";
                }
                case "Replaces a = b with (a <= b /\\ a >= b) and a != b with (a > b \\/ a < b)": {
                    return "eq";
                }
                case "Replace strict inequalities by non-strict inequalities": {
                    return "sie";
                }
                case "LassoPartitioneer": {
                    return "lsp";
                }
                case "Remove negation before atoms": {
                    return "neg";
                }
                case "Replace integer division by equivalent linear constraints": {
                    return "div";
                }
                case "Replace boolean variables by integer variables": {
                    return "bol";
                }
                case "Add a corresponding inVars and outVars": {
                    return "mio";
                }
                case "Replace 'true' with '0 >= 0' and 'false' with '0 >= 1'": {
                    return "tf";
                }
                case "Remove if-then-else terms.": {
                    return "ite";
                }
                case "Add axioms to the transition": {
                    return "ax";
                }
                case "Simplify formula using CommuhashNormalForm": {
                    return "hnf";
                }
            }
            return "ukn";
        }

        private static String ppOne(float[] relativeEqualizedData, List<String> preprocessorAbbreviations) {
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < relativeEqualizedData.length) {
                sb.append(preprocessorAbbreviations.get(i));
                sb.append(String.valueOf(PreprocessingBenchmark.makePercent(relativeEqualizedData[i])));
                sb.append(" ");
                ++i;
            }
            return sb.toString();
        }

        private static int makePercent(float f) {
            return (int)Math.floor((double)f * 100.0);
        }

        private static void addListElements(float[] modifiedArray, List<Float> incrementList) {
            assert (modifiedArray.length == incrementList.size());
            int i = 0;
            while (i < modifiedArray.length) {
                int n = i;
                modifiedArray[n] = modifiedArray[n] + incrementList.get(i).floatValue();
                ++i;
            }
        }

        private static void divideAllEntries(float[] modifiedArray, int divisor) {
            int i = 0;
            while (i < modifiedArray.length) {
                int n = i++;
                modifiedArray[n] = modifiedArray[n] / (float)divisor;
            }
        }
    }
}

