/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lassoranker;

import de.uni_freiburg.informatik.ultimate.lassoranker.ILassoRankerPreferences;
import de.uni_freiburg.informatik.ultimate.lassoranker.variables.InequalityConverter;
import java.io.File;
import java.io.Serializable;

public class LassoRankerPreferences
implements Serializable,
ILassoRankerPreferences {
    private static final long serialVersionUID = 3253589986886574198L;
    private final boolean mComputeIntegralHull;
    private final boolean mEnablePartitioneer;
    private final boolean mAnnotateTerms;
    private final boolean mExternalSolver;
    private final String mExternalSolverCommand;
    private final boolean mDumpSmtSolverScript;
    private final String mPathOfDumpedScript;
    private final String mBaseNameOfDumpedScript;
    private final boolean mOverapproximateArrayIndexConnection;
    private final InequalityConverter.NlaHandling mNlaHandling;
    private final boolean mUseOldMapElimination;
    private final boolean mMapElimAddInequalities;
    private final boolean mMapElimOnlyTrivialImplicationsIndexAssignment;
    private final boolean mMapElimOnlyTrivialImplicationsArrayWrite;
    private final boolean mMapElimOnlyIndicesInFormula;
    private final boolean mFakeNonIncrementalScript;

    public LassoRankerPreferences(ILassoRankerPreferences prefs) {
        this(prefs.isComputeIntegralHull(), prefs.isEnablePartitioneer(), prefs.isAnnotateTerms(), prefs.isExternalSolver(), prefs.getExternalSolverCommand(), prefs.isDumpSmtSolverScript(), prefs.getPathOfDumpedScript(), prefs.getBaseNameOfDumpedScript(), prefs.isOverapproximateArrayIndexConnection(), prefs.getNlaHandling(), prefs.isUseOldMapElimination(), prefs.isMapElimAddInequalities(), prefs.isMapElimOnlyTrivialImplicationsIndexAssignment(), prefs.isMapElimOnlyTrivialImplicationsArrayWrite(), prefs.isMapElimOnlyIndicesInFormula(), prefs.isFakeNonIncrementalScript());
    }

    private LassoRankerPreferences(boolean computeIntegralHull, boolean enablePartitioneer, boolean annotateTerms, boolean externalSolver, String externalSolverCommand, boolean dumpSmtSolverScript, String pathOfDumpedScript, String baseNameOfDumpedScript, boolean overapproximateArrayIndexConnection, InequalityConverter.NlaHandling nlaHandling, boolean useOldMapElimination, boolean mapElimAddInequalities, boolean mapElimOnlyTrivialImplicationsIndexAssignment, boolean mapElimOnlyTrivialImplicationsArrayWrite, boolean mapElimOnlyIndicesInFormula, boolean fakeNonIncrementalScript) {
        this.mComputeIntegralHull = computeIntegralHull;
        this.mEnablePartitioneer = enablePartitioneer;
        this.mAnnotateTerms = annotateTerms;
        this.mExternalSolver = externalSolver;
        this.mExternalSolverCommand = externalSolverCommand;
        this.mDumpSmtSolverScript = dumpSmtSolverScript;
        this.mPathOfDumpedScript = pathOfDumpedScript;
        this.mBaseNameOfDumpedScript = baseNameOfDumpedScript;
        this.mOverapproximateArrayIndexConnection = overapproximateArrayIndexConnection;
        this.mNlaHandling = nlaHandling;
        this.mUseOldMapElimination = useOldMapElimination;
        this.mMapElimAddInequalities = mapElimAddInequalities;
        this.mMapElimOnlyTrivialImplicationsIndexAssignment = mapElimOnlyTrivialImplicationsIndexAssignment;
        this.mMapElimOnlyTrivialImplicationsArrayWrite = mapElimOnlyTrivialImplicationsArrayWrite;
        this.mMapElimOnlyIndicesInFormula = mapElimOnlyIndicesInFormula;
        this.mFakeNonIncrementalScript = fakeNonIncrementalScript;
        assert (this.isSane()) : "Settings are invalid";
    }

    private boolean isSane() {
        if (this.mExternalSolverCommand != null && this.mPathOfDumpedScript != null) {
            if (this.mDumpSmtSolverScript) {
                File f = new File(this.mPathOfDumpedScript);
                return f.exists() && f.isDirectory() && this.mBaseNameOfDumpedScript != null;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isComputeIntegralHull() {
        return this.mComputeIntegralHull;
    }

    @Override
    public boolean isEnablePartitioneer() {
        return this.mEnablePartitioneer;
    }

    @Override
    public boolean isAnnotateTerms() {
        return this.mAnnotateTerms;
    }

    @Override
    public boolean isExternalSolver() {
        return this.mExternalSolver;
    }

    @Override
    public String getExternalSolverCommand() {
        return this.mExternalSolverCommand;
    }

    @Override
    public boolean isDumpSmtSolverScript() {
        return this.mDumpSmtSolverScript;
    }

    @Override
    public String getPathOfDumpedScript() {
        return this.mPathOfDumpedScript;
    }

    @Override
    public String getBaseNameOfDumpedScript() {
        return this.mBaseNameOfDumpedScript;
    }

    @Override
    public boolean isOverapproximateArrayIndexConnection() {
        return this.mOverapproximateArrayIndexConnection;
    }

    @Override
    public InequalityConverter.NlaHandling getNlaHandling() {
        return this.mNlaHandling;
    }

    @Override
    public boolean isUseOldMapElimination() {
        return this.mUseOldMapElimination;
    }

    @Override
    public boolean isMapElimAddInequalities() {
        return this.mMapElimAddInequalities;
    }

    @Override
    public boolean isMapElimOnlyTrivialImplicationsIndexAssignment() {
        return this.mMapElimOnlyTrivialImplicationsIndexAssignment;
    }

    @Override
    public boolean isMapElimOnlyTrivialImplicationsArrayWrite() {
        return this.mMapElimOnlyTrivialImplicationsArrayWrite;
    }

    @Override
    public boolean isMapElimOnlyIndicesInFormula() {
        return this.mMapElimOnlyIndicesInFormula;
    }

    @Override
    public boolean isFakeNonIncrementalScript() {
        return this.mFakeNonIncrementalScript;
    }
}

