/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lassoranker;

import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.TermException;
import de.uni_freiburg.informatik.ultimate.lassoranker.AffineTerm;
import de.uni_freiburg.informatik.ultimate.lassoranker.exceptions.TermIsNotAffineException;
import de.uni_freiburg.informatik.ultimate.lassoranker.exceptions.UnknownFunctionException;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class LinearInequality
implements Serializable {
    private static final long serialVersionUID = 5640678756293667730L;
    private boolean mStrict = false;
    public PossibleMotzkinCoefficients mMotzkinCoefficient = PossibleMotzkinCoefficients.ANYTHING;
    private final Map<Term, AffineTerm> mCoefficients;
    private AffineTerm mConstant;

    public LinearInequality() {
        this.mCoefficients = new LinkedHashMap<Term, AffineTerm>();
        this.mConstant = new AffineTerm();
    }

    public LinearInequality(LinearInequality other) {
        this.mConstant = new AffineTerm(other.mConstant);
        this.mStrict = other.mStrict;
        this.mMotzkinCoefficient = other.mMotzkinCoefficient;
        this.mCoefficients = new LinkedHashMap<Term, AffineTerm>();
        for (Map.Entry<Term, AffineTerm> entry : other.mCoefficients.entrySet()) {
            this.mCoefficients.put(entry.getKey(), new AffineTerm(entry.getValue()));
        }
    }

    public static LinearInequality constructFalse() {
        LinearInequality result = new LinearInequality();
        result.setStrict(true);
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LinearInequality fromTerm(Term term) throws TermException {
        LinearInequality li;
        if (term instanceof ConstantTerm) {
            li = new LinearInequality();
            li.add(new AffineTerm(SmtUtils.toRational((ConstantTerm)((ConstantTerm)term))));
            return li;
        } else if (term instanceof TermVariable) {
            li = new LinearInequality();
            li.add(term, Rational.ONE);
            return li;
        } else {
            if (!(term instanceof ApplicationTerm)) throw new TermException("Stumbled upon a Term of unknown subclass", term);
            ApplicationTerm appt = (ApplicationTerm)term;
            if ("+".equals(appt.getFunction().getName())) {
                li = LinearInequality.fromTerm(appt.getParameters()[0]);
                int i = 1;
                while (i < appt.getParameters().length) {
                    li.add(LinearInequality.fromTerm(appt.getParameters()[i]));
                    ++i;
                }
                return li;
            } else if ("-".equals(appt.getFunction().getName())) {
                if (appt.getFunction().getParameterSorts().length == 1) {
                    li = LinearInequality.fromTerm(appt.getParameters()[0]);
                    li.mult(Rational.MONE);
                    return li;
                } else {
                    li = LinearInequality.fromTerm(appt.getParameters()[0]);
                    li.mult(Rational.MONE);
                    int i = 1;
                    while (i < appt.getParameters().length) {
                        li.add(LinearInequality.fromTerm(appt.getParameters()[i]));
                        ++i;
                    }
                    li.mult(Rational.MONE);
                }
                return li;
            } else if ("*".equals(appt.getFunction().getName())) {
                li = new LinearInequality();
                li.mConstant = new AffineTerm(Rational.ONE);
                Term[] termArray = appt.getParameters();
                int n = termArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Term u = termArray[n2];
                    LinearInequality liu = LinearInequality.fromTerm(u);
                    if (li.isConstant() && li.mConstant.isConstant()) {
                        liu.mult(li.mConstant.getConstant());
                        li = liu;
                    } else {
                        if (!liu.isConstant() || !liu.mConstant.isConstant()) throw new TermIsNotAffineException("Product with more than one non-constant factors found", (Term)appt);
                        li.mult(liu.mConstant.getConstant());
                    }
                    ++n2;
                }
                return li;
            } else if ("/".equals(appt.getFunction().getName())) {
                assert (appt.getParameters().length == 2);
                LinearInequality divident = LinearInequality.fromTerm(appt.getParameters()[0]);
                LinearInequality divisor = LinearInequality.fromTerm(appt.getParameters()[1]);
                if (!divisor.isConstant() || !divisor.mConstant.isConstant()) {
                    throw new TermIsNotAffineException("Non-constant divisor", (Term)appt);
                }
                if (divisor.mConstant.getConstant().equals((Object)Rational.ZERO)) {
                    throw new TermIsNotAffineException("Division by zero", (Term)appt);
                }
                li = divident;
                li.mult(divisor.mConstant.getConstant().inverse());
                return li;
            } else {
                if (appt.getParameters().length != 0) throw new UnknownFunctionException(appt);
                li = new LinearInequality();
                li.add((Term)appt, Rational.ONE);
            }
        }
        return li;
    }

    public boolean isConstant() {
        return this.mCoefficients.isEmpty() && this.mConstant.isConstant();
    }

    public boolean allAffineTermsAreConstant() {
        boolean result = true;
        result &= this.mConstant.isConstant();
        for (AffineTerm coeff : this.mCoefficients.values()) {
            result &= coeff.isConstant();
        }
        return result;
    }

    public AffineTerm getConstant() {
        return this.mConstant;
    }

    public boolean isStrict() {
        return this.mStrict;
    }

    public void setStrict(boolean strict) {
        this.mStrict = strict;
    }

    public String getInequalitySymbol() {
        return this.mStrict ? ">" : ">=";
    }

    public String getInequalitySymbolReverse() {
        return this.mStrict ? "<" : "<=";
    }

    public AffineTerm getCoefficient(Term var) {
        AffineTerm p = this.mCoefficients.get(var);
        if (p == null) {
            return new AffineTerm();
        }
        return p;
    }

    public Collection<Term> getVariables() {
        return this.mCoefficients.keySet();
    }

    public void add(LinearInequality li) {
        this.add(li.mConstant);
        for (Map.Entry<Term, AffineTerm> entry : li.mCoefficients.entrySet()) {
            this.add(entry.getKey(), entry.getValue());
        }
    }

    public void add(Term var, AffineTerm a) {
        AffineTerm a2 = this.mCoefficients.get(var);
        if (a2 != null) {
            a2.add(a);
            if (!a2.isZero()) {
                this.mCoefficients.put(var, a2);
            } else {
                this.mCoefficients.remove(var);
            }
        } else if (!a.isZero()) {
            this.mCoefficients.put(var, a);
        }
    }

    public void add(Term var, Rational r) {
        this.add(var, new AffineTerm(r));
    }

    public void add(AffineTerm p) {
        this.mConstant.add(p);
    }

    public void mult(Rational r) {
        this.mConstant.mult(r);
        for (Map.Entry<Term, AffineTerm> entry : this.mCoefficients.entrySet()) {
            entry.getValue().mult(r);
        }
    }

    public void negate() {
        this.mult(Rational.MONE);
        this.mStrict = !this.mStrict;
    }

    public String getSortName() {
        if (this.mCoefficients.isEmpty()) {
            return "Real";
        }
        Term firstVar = this.mCoefficients.keySet().iterator().next();
        Sort result = firstVar.getSort();
        for (Term var : this.mCoefficients.keySet()) {
            assert (var.getSort() == result);
        }
        return result.getName();
    }

    public Term asTerm(Script script) {
        String sortName = this.getSortName();
        boolean real = sortName.equals("Real");
        Term[] summands = new Term[this.mCoefficients.size() + 1];
        Term zero = real ? script.decimal(BigDecimal.ZERO) : SmtUtils.constructIntValue((Script)script, (BigInteger)BigInteger.ZERO);
        int i = 0;
        for (Map.Entry<Term, AffineTerm> entry : this.mCoefficients.entrySet()) {
            Term coeff;
            Term var = entry.getKey();
            if (real) {
                assert (SmtSortUtils.isRealSort((Sort)var.getSort()));
                coeff = entry.getValue().asRealTerm(script);
            } else {
                assert (SmtSortUtils.isIntSort((Sort)var.getSort()));
                coeff = entry.getValue().asIntTerm(script);
            }
            summands[i] = script.term("*", new Term[]{coeff, entry.getKey()});
            ++i;
        }
        summands[i] = real ? this.mConstant.asRealTerm(script) : this.mConstant.asIntTerm(script);
        Term sum = SmtUtils.sum((Script)script, (Sort)script.sort(sortName, new Sort[0]), (Term[])summands);
        return script.term(this.getInequalitySymbol(), new Term[]{sum, zero});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("0 ");
        sb.append(this.getInequalitySymbolReverse());
        sb.append(" ");
        boolean first = true;
        for (Map.Entry<Term, AffineTerm> entry : this.mCoefficients.entrySet()) {
            if (entry.getValue().isZero()) continue;
            String param = entry.getValue().toString();
            if (param.length() > 2 && param.substring(2).contains(" ")) {
                if (!first) {
                    sb.append(" + ");
                }
                sb.append("(");
                sb.append(param);
                sb.append(")");
            } else if (param.startsWith("-")) {
                if (!first) {
                    sb.append(" -");
                    sb.append(param.substring(1));
                } else {
                    sb.append(param);
                }
            } else {
                if (!first) {
                    sb.append(" + ");
                }
                sb.append(param);
            }
            sb.append("*");
            sb.append(entry.getKey());
            first = false;
        }
        if (!this.mConstant.isZero() || first) {
            String s = this.mConstant.toString();
            if (s.startsWith("-")) {
                if (!first) {
                    sb.append(" -");
                    sb.append(s.substring(1));
                } else {
                    sb.append(s);
                }
            } else {
                if (!first) {
                    sb.append(" + ");
                }
                sb.append(s);
            }
        }
        return sb.toString();
    }

    public static enum PossibleMotzkinCoefficients {
        ONE,
        ZERO_AND_ONE,
        ANYTHING;


        public boolean multipleValues() {
            return this == ZERO_AND_ONE || this == ANYTHING;
        }

        public boolean isFixed() {
            return this == ONE || this == ZERO_AND_ONE;
        }
    }
}

