/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lassoranker;

import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.TermException;
import de.uni_freiburg.informatik.ultimate.lassoranker.IntegralHull;
import de.uni_freiburg.informatik.ultimate.lassoranker.LinearInequality;
import de.uni_freiburg.informatik.ultimate.lassoranker.variables.InequalityConverter;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.ReplacementVarUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.ModifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LinearTransition
implements Serializable {
    private static final long serialVersionUID = 8925538198614759883L;
    private final Map<IProgramVar, TermVariable> minVars;
    private final Map<IProgramVar, TermVariable> moutVars;
    private final List<List<LinearInequality>> mpolyhedra;
    private final boolean mcontains_integers;

    public LinearTransition(List<List<LinearInequality>> polyhedra, Map<IProgramVar, TermVariable> inVars, Map<IProgramVar, TermVariable> outVars) {
        assert (polyhedra != null);
        assert (inVars != null);
        assert (outVars != null);
        for (List<LinearInequality> polyhedron : polyhedra) {
            assert (polyhedron != null);
        }
        this.mpolyhedra = polyhedra;
        this.minVars = Collections.unmodifiableMap(inVars);
        this.moutVars = Collections.unmodifiableMap(outVars);
        this.mcontains_integers = this.checkIfContainsSort(this.minVars.keySet(), "Int") || this.checkIfContainsSort(this.moutVars.keySet(), "Int");
    }

    private boolean checkIfContainsSort(Set<IProgramVar> varSet, String sortname) {
        for (IProgramVar rv : varSet) {
            Sort sort = ReplacementVarUtils.getDefinition((IProgramVar)rv).getSort();
            if (!sort.getName().equals(sortname)) continue;
            return true;
        }
        return false;
    }

    private boolean checkIfContainsIntegers() {
        for (List<LinearInequality> polyhedron : this.mpolyhedra) {
            for (LinearInequality ieq : polyhedron) {
                for (Term var : ieq.getVariables()) {
                    if (!SmtSortUtils.isIntSort((Sort)var.getSort())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static LinearTransition getTranstionTrue() {
        LinearInequality eqTrue = new LinearInequality();
        return new LinearTransition(Collections.singletonList(Collections.singletonList(eqTrue)), Collections.emptyMap(), Collections.emptyMap());
    }

    public static LinearTransition getTranstionFalse() {
        LinearInequality eqFalse = new LinearInequality();
        eqFalse.setStrict(true);
        return new LinearTransition(Collections.singletonList(Collections.singletonList(eqFalse)), Collections.emptyMap(), Collections.emptyMap());
    }

    private static List<Term> toClauses(Term term) {
        ArrayList<Term> l = new ArrayList<Term>();
        if (!(term instanceof ApplicationTerm)) {
            l.add(term);
            return l;
        }
        ApplicationTerm appt = (ApplicationTerm)term;
        if (!appt.getFunction().getName().equals("or")) {
            l.add(term);
            return l;
        }
        Term[] termArray = appt.getParameters();
        int n = termArray.length;
        int n2 = 0;
        while (n2 < n) {
            Term t = termArray[n2];
            l.addAll(LinearTransition.toClauses(t));
            ++n2;
        }
        return l;
    }

    public static LinearTransition fromTransFormulaLR(ModifiableTransFormula tf, InequalityConverter.NlaHandling nlaHandling) throws TermException {
        ArrayList<List<LinearInequality>> polyhedra = new ArrayList<List<LinearInequality>>();
        for (Term disjunct : LinearTransition.toClauses(tf.getFormula())) {
            polyhedra.add(InequalityConverter.convert(disjunct, nlaHandling));
        }
        return new LinearTransition(polyhedra, tf.getInVars(), tf.getOutVars());
    }

    public Map<IProgramVar, TermVariable> getInVars() {
        return this.minVars;
    }

    public Map<IProgramVar, TermVariable> getOutVars() {
        return this.moutVars;
    }

    public boolean containsIntegers() {
        return this.mcontains_integers;
    }

    public void integralHull() {
        for (List<LinearInequality> polyhedron : this.mpolyhedra) {
            polyhedron.addAll(IntegralHull.compute(polyhedron));
        }
    }

    public boolean isConjunctive() {
        return this.mpolyhedra.size() <= 1;
    }

    public boolean isTrue() {
        for (List<LinearInequality> polyhedron : this.mpolyhedra) {
            boolean istrue = true;
            for (LinearInequality li : polyhedron) {
                boolean bl = istrue = istrue && li.isConstant() && li.getConstant().isZero() && !li.isStrict();
            }
            if (!istrue) continue;
            return true;
        }
        return false;
    }

    public boolean isFalse() {
        for (List<LinearInequality> polyhedron : this.mpolyhedra) {
            boolean isfalse = false;
            for (LinearInequality li : polyhedron) {
                if (!li.isConstant() || !li.getConstant().isZero() || !li.isStrict()) continue;
                isfalse = true;
                break;
            }
            if (isfalse) continue;
            return false;
        }
        return true;
    }

    public int getNumPolyhedra() {
        return this.mpolyhedra.size();
    }

    public int getNumInequalities() {
        int num = 0;
        for (List<LinearInequality> polyhedron : this.mpolyhedra) {
            num += polyhedron.size();
        }
        return num;
    }

    public Set<Term> getVariables() {
        LinkedHashSet<Term> vars = new LinkedHashSet<Term>();
        for (List<LinearInequality> polyhedron : this.mpolyhedra) {
            for (LinearInequality li : polyhedron) {
                vars.addAll(li.getVariables());
            }
        }
        return vars;
    }

    public List<List<LinearInequality>> getPolyhedra() {
        return Collections.unmodifiableList(this.mpolyhedra);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("InVars: ");
        sb.append(this.minVars.toString());
        sb.append("\nOutVars: ");
        sb.append(this.moutVars.toString());
        sb.append("\n(OR\n");
        for (List<LinearInequality> polyhedron : this.mpolyhedra) {
            sb.append("    (AND\n");
            for (LinearInequality ieq : polyhedron) {
                sb.append("        ");
                sb.append(ieq);
                sb.append("\n");
            }
            sb.append("    )\n");
        }
        sb.append(")");
        return sb.toString();
    }
}

