/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lassoranker;

import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainCanceledException;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.TermException;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public class ModelExtractionUtils {
    public static final long s_randomSeed = 80085L;
    protected static final int s_numof_simultaneous_simplification_tests = 4;

    public static Rational const2Rational(Term t) throws TermException {
        if (t instanceof ApplicationTerm) {
            ApplicationTerm appt = (ApplicationTerm)t;
            if (appt.getFunction().getName().equals("+")) {
                return ModelExtractionUtils.const2Rational(appt.getParameters()[0]).add(ModelExtractionUtils.const2Rational(appt.getParameters()[1]));
            }
            if (appt.getFunction().getName().equals("-")) {
                if (appt.getParameters().length == 1) {
                    return ModelExtractionUtils.const2Rational(appt.getParameters()[0]).mul(Rational.MONE);
                }
                return ModelExtractionUtils.const2Rational(appt.getParameters()[0]).sub(ModelExtractionUtils.const2Rational(appt.getParameters()[1]));
            }
            if (appt.getFunction().getName().equals("*")) {
                return ModelExtractionUtils.const2Rational(appt.getParameters()[0]).mul(ModelExtractionUtils.const2Rational(appt.getParameters()[1]));
            }
            if (appt.getFunction().getName().equals("/")) {
                return ModelExtractionUtils.const2Rational(appt.getParameters()[0]).div(ModelExtractionUtils.const2Rational(appt.getParameters()[1]));
            }
        }
        if (t instanceof ConstantTerm) {
            Object o = ((ConstantTerm)t).getValue();
            if (o instanceof BigInteger) {
                return Rational.valueOf((BigInteger)((BigInteger)o), (BigInteger)BigInteger.ONE);
            }
            if (o instanceof BigDecimal) {
                Rational rat;
                BigDecimal decimal = (BigDecimal)o;
                if (decimal.scale() <= 0) {
                    BigInteger num = decimal.toBigInteger();
                    rat = Rational.valueOf((BigInteger)num, (BigInteger)BigInteger.ONE);
                } else {
                    BigInteger num = decimal.unscaledValue();
                    BigInteger denom = BigInteger.TEN.pow(decimal.scale());
                    rat = Rational.valueOf((BigInteger)num, (BigInteger)denom);
                }
                return rat;
            }
            if (o instanceof Rational) {
                return (Rational)o;
            }
            throw new TermException("Unknown value class", t);
        }
        throw new TermException("Unknown term structure", t);
    }

    public static Map<Term, Rational> getValuation(Script script, Collection<Term> coefficients) throws TermException {
        LinkedHashMap<Term, Rational> result = new LinkedHashMap<Term, Rational>();
        if (!coefficients.isEmpty()) {
            Map val = script.getValue(coefficients.toArray(new Term[coefficients.size()]));
            for (Map.Entry entry : val.entrySet()) {
                result.put((Term)entry.getKey(), ModelExtractionUtils.const2Rational((Term)entry.getValue()));
            }
        }
        return result;
    }

    @Deprecated
    protected int simplifyAssignment(Script script, ArrayList<Term> variables, ILogger logger) {
        Random rnd = new Random(80085L);
        Collections.shuffle(variables, rnd);
        int pops = 0;
        int checkSat_calls = 0;
        int i = 0;
        while (i < variables.size()) {
            Term var = variables.get(i);
            script.push(1);
            script.assertTerm(script.term("=", new Term[]{var, SmtUtils.constructIntValue((Script)script, (BigInteger)BigInteger.ZERO)}));
            Script.LBool sat = script.checkSat();
            ++checkSat_calls;
            if (sat != Script.LBool.SAT) {
                script.pop(1);
                if (i == variables.size() - 1) {
                    sat = script.checkSat();
                    ++checkSat_calls;
                    assert (sat == Script.LBool.SAT);
                }
            } else {
                ++pops;
            }
            ++i;
        }
        logger.info((Object)("Simplification made " + checkSat_calls + " calls to the SMT solver."));
        return pops;
    }

    public static Map<Term, Rational> getSimplifiedAssignment(Script script, Collection<Term> variables, ILogger logger, IUltimateServiceProvider services) throws TermException {
        Random rnd = new Random(80085L);
        Map<Term, Rational> val = ModelExtractionUtils.getValuation(script, variables);
        HashSet<Term> zero_vars = new HashSet<Term>();
        HashSet<Term> not_zero_vars = new HashSet<Term>(variables);
        int checkSat_calls = 0;
        int unsat_calls = 0;
        while (true) {
            for (Map.Entry<Term, Rational> entry : val.entrySet()) {
                if (!entry.getValue().equals((Object)Rational.ZERO)) continue;
                zero_vars.add(entry.getKey());
                not_zero_vars.remove(entry.getKey());
            }
            if (not_zero_vars.size() <= 4) break;
            if (!services.getProgressMonitorService().continueProcessing()) {
                throw new ToolchainCanceledException(ModelExtractionUtils.class, "simplifying assignment for " + variables.size() + "variables");
            }
            script.push(1);
            for (Term var : zero_vars) {
                script.assertTerm(script.term("=", new Term[]{var, Rational.ZERO.toTerm(var.getSort())}));
            }
            int i = 0;
            while (i < 10) {
                ArrayList<Term> vars = new ArrayList<Term>(not_zero_vars);
                Collections.shuffle(vars, rnd);
                Term[] disj = new Term[4];
                int j = 0;
                while (j < 4) {
                    disj[j] = script.term("=", new Term[]{(Term)vars.get(j), Rational.ZERO.toTerm(((Term)vars.get(j)).getSort())});
                    ++j;
                }
                script.assertTerm(SmtUtils.or((Script)script, (Term[])disj));
                ++i;
            }
            ++checkSat_calls;
            Script.LBool sat = script.checkSat();
            if (sat == Script.LBool.SAT) {
                val = ModelExtractionUtils.getValuation(script, not_zero_vars);
            } else if (++unsat_calls > 1) {
                script.pop(1);
                break;
            }
            script.pop(1);
        }
        for (Term var : zero_vars) {
            val.put(var, Rational.ZERO);
        }
        logger.info((Object)("Simplification made " + checkSat_calls + " calls to the SMT solver."));
        int numzero_vars = 0;
        for (Map.Entry<Term, Rational> entry : val.entrySet()) {
            if (!entry.getValue().equals((Object)Rational.ZERO)) continue;
            ++numzero_vars;
        }
        logger.info((Object)("Setting " + numzero_vars + " variables to zero."));
        return val;
    }

    /*
     * Unable to fully structure code
     */
    public static Map<Term, Rational> getSimplifiedAssignment_TwoMode(Script script, Collection<Term> coefficients, ILogger logger, IUltimateServiceProvider services) throws TermException {
        alreadyZero = new HashSet<Term>();
        zeroCandidates = new HashSet<Term>(coefficients);
        neverZero = new HashSet<Term>();
        finalValuation = new HashMap<Term, Rational>(ModelExtractionUtils.getValuation(script, coefficients));
        notYetAssertedZeros = ModelExtractionUtils.findNewZeros(finalValuation, alreadyZero, zeroCandidates);
        for (Term var : notYetAssertedZeros) {
            script.assertTerm(script.term("=", new Term[]{var, Rational.ZERO.toTerm(var.getSort())}));
        }
        variablesInitiallySetToZero = alreadyZero.size();
        conjunctiveMode = false;
        subsetSizeBonusFactor = 1.0;
        pushWithoutPop = 0;
        checkSatCalls = 0;
        newPartialValuation = null;
        while (!zeroCandidates.isEmpty()) {
            block25: {
                block23: {
                    block26: {
                        block24: {
                            if (!services.getProgressMonitorService().continueProcessing()) {
                                throw new ToolchainCanceledException(ModelExtractionUtils.class, "simplifying assignment for " + coefficients.size() + "variables");
                            }
                            subsetSize = ModelExtractionUtils.computeSubsetSize(zeroCandidates.size(), subsetSizeBonusFactor);
                            subset = ModelExtractionUtils.getSubset(subsetSize, zeroCandidates);
                            equalsZeroTerms = ModelExtractionUtils.constructEqualsZeroTerms(script, subset);
                            script.push(1);
                            ++pushWithoutPop;
                            if (!ModelExtractionUtils.$assertionsDisabled && subset.isEmpty()) {
                                throw new AssertionError((Object)"subset too small");
                            }
                            if (subset.size() != 1) break block23;
                            if (!ModelExtractionUtils.$assertionsDisabled && equalsZeroTerms.length != 1) {
                                throw new AssertionError();
                            }
                            script.assertTerm(equalsZeroTerms[0]);
                            sat = script.checkSat();
                            ++checkSatCalls;
                            if (sat != Script.LBool.SAT) break block24;
                            newPartialValuation = ModelExtractionUtils.getValuation2(script, zeroCandidates, neverZero);
                            finalValuation.putAll(newPartialValuation);
                            for (Term var : subset) {
                                zeroCandidates.remove(var);
                                alreadyZero.add(var);
                            }
                            conjunctiveMode = true;
                            subsetSizeBonusFactor = 2.0;
                            break block25;
                        }
                        if (sat != Script.LBool.UNSAT) break block26;
                        for (Term var : subset) {
                            zeroCandidates.remove(var);
                            neverZero.add(var);
                        }
                        script.pop(1);
                        --pushWithoutPop;
                        newPartialValuation = null;
                        conjunctiveMode = false;
                        subsetSizeBonusFactor = 2.0;
                        break block25;
                    }
                    if (sat == Script.LBool.UNKNOWN) {
                        throw new AssertionError((Object)"not yet implemented");
                    }
                    throw new AssertionError((Object)"unknown LBool");
                }
                if (!conjunctiveMode) ** GOTO lbl90
                conjunction = SmtUtils.and((Script)script, (Term[])equalsZeroTerms);
                script.assertTerm(conjunction);
                sat = script.checkSat();
                ++checkSatCalls;
                if (sat == Script.LBool.SAT) {
                    newPartialValuation = ModelExtractionUtils.getValuation2(script, zeroCandidates, neverZero);
                    finalValuation.putAll(newPartialValuation);
                    for (Term var : subset) {
                        zeroCandidates.remove(var);
                        alreadyZero.add(var);
                    }
                    subsetSizeBonusFactor = 2.0;
                } else if (sat == Script.LBool.UNSAT) {
                    script.pop(1);
                    --pushWithoutPop;
                    newPartialValuation = null;
                    conjunctiveMode = false;
                } else {
                    if (sat == Script.LBool.UNKNOWN) {
                        throw new AssertionError((Object)"not yet implemented");
                    }
                    throw new AssertionError((Object)"unknown LBool");
lbl90:
                    // 1 sources

                    disjunction = SmtUtils.or((Script)script, (Term[])equalsZeroTerms);
                    script.assertTerm(disjunction);
                    sat = script.checkSat();
                    ++checkSatCalls;
                    if (sat == Script.LBool.SAT) {
                        newPartialValuation = ModelExtractionUtils.getValuation2(script, zeroCandidates, neverZero);
                        finalValuation.putAll(newPartialValuation);
                        script.pop(1);
                        --pushWithoutPop;
                        conjunctiveMode = true;
                    } else if (sat == Script.LBool.UNSAT) {
                        for (Term var : subset) {
                            zeroCandidates.remove(var);
                            neverZero.add(var);
                        }
                        script.pop(1);
                        --pushWithoutPop;
                        newPartialValuation = null;
                        subsetSizeBonusFactor = 2.0;
                    } else {
                        if (sat == Script.LBool.UNKNOWN) {
                            throw new AssertionError((Object)"not yet implemented");
                        }
                        throw new AssertionError((Object)"unknown LBool");
                    }
                }
            }
            if (newPartialValuation == null) continue;
            notYetAssertedZeros = ModelExtractionUtils.findNewZeros(finalValuation, alreadyZero, zeroCandidates);
            for (Term var : notYetAssertedZeros) {
                script.assertTerm(script.term("=", new Term[]{var, Rational.ZERO.toTerm(var.getSort())}));
            }
        }
        i = 0;
        while (i < pushWithoutPop) {
            script.push(1);
            ++i;
        }
        logger.info((Object)("Simplification made " + checkSatCalls + " calls to the SMT solver."));
        logger.info((Object)(String.valueOf(variablesInitiallySetToZero) + " out of " + finalValuation.size() + " variables were initially zero. Simplification set additionally " + (alreadyZero.size() - variablesInitiallySetToZero) + " variables to zero."));
        if (!ModelExtractionUtils.$assertionsDisabled && alreadyZero.size() + neverZero.size() != finalValuation.size()) {
            throw new AssertionError((Object)"wrong number of variables");
        }
        return finalValuation;
    }

    private static Map<Term, Rational> getValuation2(Script script, Set<Term> zeroCandidates, Set<Term> neverZero) throws TermException {
        ArrayList<Term> vars = new ArrayList<Term>(zeroCandidates.size() + neverZero.size());
        vars.addAll(zeroCandidates);
        vars.addAll(neverZero);
        return ModelExtractionUtils.getValuation(script, vars);
    }

    private static int computeSubsetSize(int zeroCandidates, double subsetSizeBonusFactor) {
        return (int)Math.ceil((double)zeroCandidates * subsetSizeBonusFactor / 4.0);
    }

    private static <E> List<E> getSubset(int n, Set<E> set) {
        ArrayList<E> result = new ArrayList<E>();
        int subsetSize = Math.min(n, set.size());
        Iterator<E> it = set.iterator();
        int i = 0;
        while (i < subsetSize) {
            result.add(it.next());
            ++i;
        }
        return result;
    }

    private static Term[] constructEqualsZeroTerms(Script script, List<Term> set) {
        Term[] result = new Term[set.size()];
        Iterator<Term> it = set.iterator();
        int i = 0;
        while (i < set.size()) {
            Term term = it.next();
            result[i] = script.term("=", new Term[]{term, Rational.ZERO.toTerm(term.getSort())});
            ++i;
        }
        return result;
    }

    private static List<Term> findNewZeros(Map<Term, Rational> val, Set<Term> alreadyZero, Set<Term> zeroCandidates) {
        ArrayList<Term> newlyBecomeZero = new ArrayList<Term>();
        Iterator<Term> it = zeroCandidates.iterator();
        while (it.hasNext()) {
            Term var = it.next();
            assert (val.containsKey(var));
            if (!val.get(var).equals((Object)Rational.ZERO)) continue;
            newlyBecomeZero.add(var);
            alreadyZero.add(var);
            it.remove();
        }
        return newlyBecomeZero;
    }
}

