/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lassoranker;

import de.uni_freiburg.informatik.ultimate.lassoranker.nontermination.GeometricNonTerminationArgument;
import de.uni_freiburg.informatik.ultimate.lassoranker.nontermination.InfiniteFixpointRepetition;
import de.uni_freiburg.informatik.ultimate.lassoranker.nontermination.NonTerminationArgument;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.util.csv.ICsvProvider;
import de.uni_freiburg.informatik.ultimate.util.csv.ICsvProviderProvider;
import de.uni_freiburg.informatik.ultimate.util.csv.SimpleCsvProvider;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class NonterminationArgumentStatistics
implements ICsvProviderProvider<String> {
    private final String mNtar;
    private final boolean mLambdaZero;
    private final boolean mGEVZero;
    private final int mNumberOfGevs;

    public NonterminationArgumentStatistics(NonTerminationArgument nta) {
        if (nta instanceof GeometricNonTerminationArgument) {
            GeometricNonTerminationArgument gnta = (GeometricNonTerminationArgument)nta;
            this.mNumberOfGevs = this.computeNumberOfGevs(((GeometricNonTerminationArgument)nta).getGEVs());
            boolean lambdaZero = true;
            boolean gevZero = true;
            List<Rational> lambdas = gnta.getLambdas();
            int i = 0;
            while (i < gnta.getNumberOfGEVs()) {
                lambdaZero &= gnta.getLambdas().get(i).numerator().equals(BigInteger.ZERO);
                gevZero &= this.isZero(gnta.getGEVs().get(i));
                ++i;
            }
            this.mLambdaZero = lambdaZero;
            this.mGEVZero = gevZero;
            this.mNtar = String.valueOf(this.isFixpoint() ? "Fixpoint " : "Unbounded Execution ") + this.mNumberOfGevs + "GEVs " + "Lambdas: " + lambdas + " Mus: " + gnta.getNus();
        } else if (nta instanceof InfiniteFixpointRepetition) {
            this.mNtar = "Fixpoint";
            this.mLambdaZero = true;
            this.mGEVZero = true;
            this.mNumberOfGevs = 0;
        } else {
            throw new IllegalArgumentException("unknown NonTerminationArgument");
        }
    }

    private int computeNumberOfGevs(List<Map<IProgramVar, Rational>> gevs) {
        return (int)gevs.stream().filter(x -> x.entrySet().stream().anyMatch(y -> !((Rational)y.getValue()).equals((Object)Rational.ZERO))).count();
    }

    private boolean isFixpoint() {
        return this.mLambdaZero || this.mGEVZero;
    }

    private boolean isZero(Map<IProgramVar, Rational> gev) {
        for (Map.Entry<IProgramVar, Rational> entry : gev.entrySet()) {
            if (entry.getValue().numerator().equals(BigInteger.ZERO)) continue;
            return false;
        }
        return true;
    }

    public ICsvProvider<String> createCsvProvider() {
        return new SimpleCsvProvider(Arrays.asList("nta"));
    }

    public String toString() {
        return this.mNtar;
    }
}

