/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lassoranker.nontermination;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lassoranker.nontermination.InfiniteFixpointRepetition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramNonOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.ProgramVarUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.logic.QuotedObject;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class FixpointCheck {
    private final IUltimateServiceProvider mServices;
    private final ILogger mLogger;
    private final ManagedScript mManagedScript;
    private final Set<IProgramNonOldVar> mModifiableGlobalsAtHonda;
    private final TransFormula mStem;
    private final TransFormula mLoop;
    private final HasFixpoint mResult;
    private InfiniteFixpointRepetition mTerminationArgument;

    public FixpointCheck(IUltimateServiceProvider services, ILogger logger, ManagedScript managedScript, Set<IProgramNonOldVar> modifiableGlobalsAtHonda, TransFormula stem, TransFormula loop) {
        this.mServices = services;
        this.mLogger = logger;
        this.mManagedScript = managedScript;
        this.mModifiableGlobalsAtHonda = modifiableGlobalsAtHonda;
        this.mStem = stem;
        this.mLoop = loop;
        this.mManagedScript.lock((Object)this);
        this.mResult = this.checkForFixpoint();
        this.mManagedScript.unlock((Object)this);
    }

    private HasFixpoint checkForFixpoint() {
        HasFixpoint result;
        Map<Term, Term> substitutionMappingStem = this.constructSubtitutionMapping(this.mStem, this::getConstantAtInit, this::getConstantAtHonda);
        Map<Term, Term> substitutionMappingLoop = this.constructSubtitutionMapping(this.mLoop, this::getConstantAtHonda, this::getConstantAtHonda);
        Term renamedStem = Substitution.apply((ManagedScript)this.mManagedScript, substitutionMappingStem, (Term)this.mStem.getFormula());
        Term renamedLoop = Substitution.apply((ManagedScript)this.mManagedScript, substitutionMappingLoop, (Term)this.mLoop.getFormula());
        this.mManagedScript.echo((Object)this, new QuotedObject("Start fixpoint check"));
        this.mManagedScript.push((Object)this, 1);
        this.mManagedScript.assertTerm((Object)this, renamedStem);
        this.mManagedScript.assertTerm((Object)this, renamedLoop);
        Script.LBool lbool = this.mManagedScript.checkSat((Object)this);
        switch (lbool) {
            case SAT: {
                result = HasFixpoint.YES;
                Set<Term> wantValues = FixpointCheck.computeTermsForWhichWeWantValues(substitutionMappingStem, substitutionMappingLoop);
                Map valueMap = SmtUtils.getValues((Script)this.mManagedScript.getScript(), wantValues);
                Map<Term, Term> valuesAtInit = this.computeValuesAtInit(valueMap);
                Map<Term, Term> valuesAtHonda = this.computeValuesAtHonda(valueMap);
                this.mTerminationArgument = new InfiniteFixpointRepetition(valuesAtInit, valuesAtHonda);
                break;
            }
            case UNKNOWN: {
                result = HasFixpoint.UNKNOWN;
                break;
            }
            case UNSAT: {
                result = HasFixpoint.NO;
                break;
            }
            default: {
                throw new AssertionError(lbool);
            }
        }
        this.mManagedScript.pop((Object)this, 1);
        this.mManagedScript.echo((Object)this, new QuotedObject("Finished fixpoint check"));
        return result;
    }

    private Map<Term, Term> computeValuesAtHonda(Map<Term, Term> valueMap) {
        Term value;
        HashMap<Term, Term> valuesAtHonda = new HashMap<Term, Term>();
        for (IProgramVar pv : this.mStem.getOutVars().keySet()) {
            if (!SmtUtils.isSortForWhichWeCanGetValues((Sort)pv.getTermVariable().getSort())) continue;
            value = valueMap.get(this.getConstantAtHonda(pv));
            assert (value != null);
            valuesAtHonda.put((Term)pv.getTermVariable(), value);
        }
        for (IProgramVar pv : this.mLoop.getInVars().keySet()) {
            if (!SmtUtils.isSortForWhichWeCanGetValues((Sort)pv.getTermVariable().getSort())) continue;
            value = valueMap.get(this.getConstantAtHonda(pv));
            assert (value != null);
            valuesAtHonda.put((Term)pv.getTermVariable(), value);
        }
        for (IProgramVar pv : this.mLoop.getOutVars().keySet()) {
            if (!SmtUtils.isSortForWhichWeCanGetValues((Sort)pv.getTermVariable().getSort())) continue;
            value = valueMap.get(this.getConstantAtHonda(pv));
            assert (value != null);
            valuesAtHonda.put((Term)pv.getTermVariable(), value);
        }
        return valuesAtHonda;
    }

    private Map<Term, Term> computeValuesAtInit(Map<Term, Term> valueMap) {
        HashMap<Term, Term> valuesAtInit = new HashMap<Term, Term>();
        for (IProgramVar pv : this.mStem.getInVars().keySet()) {
            if (!SmtUtils.isSortForWhichWeCanGetValues((Sort)pv.getTermVariable().getSort())) continue;
            Term value = valueMap.get(this.getConstantAtInit(pv));
            assert (value != null);
            valuesAtInit.put((Term)pv.getTermVariable(), value);
        }
        return valuesAtInit;
    }

    private static Set<Term> computeTermsForWhichWeWantValues(Map<Term, Term> substitutionMappingStem, Map<Term, Term> substitutionMappingLoop) {
        HashSet<Term> result = new HashSet<Term>();
        Predicate<Term> predicate = x -> SmtUtils.isSortForWhichWeCanGetValues((Sort)x.getSort());
        result.addAll(substitutionMappingStem.values().stream().filter(predicate).collect(Collectors.toList()));
        result.addAll(substitutionMappingLoop.values().stream().filter(predicate).collect(Collectors.toList()));
        return result;
    }

    private static IProgramVar replaceOldByNonOld(IProgramVar pv) {
        if (pv.isOldvar()) {
            return ((IProgramOldVar)pv).getNonOldVar();
        }
        return pv;
    }

    private Map<Term, Term> constructSubtitutionMapping(TransFormula tf, IConstantMapper inVarMapping, IConstantMapper outVarMapping) {
        HashMap<Term, Term> substitutionMapping = new HashMap<Term, Term>();
        for (Map.Entry entry : tf.getInVars().entrySet()) {
            substitutionMapping.put((Term)entry.getValue(), inVarMapping.getConstant((IProgramVar)entry.getKey()));
        }
        for (Map.Entry entry : tf.getOutVars().entrySet()) {
            substitutionMapping.put((Term)entry.getValue(), outVarMapping.getConstant((IProgramVar)entry.getKey()));
        }
        for (TermVariable auxVar : tf.getAuxVars()) {
            substitutionMapping.put((Term)auxVar, (Term)ProgramVarUtils.getAuxVarConstant((ManagedScript)this.mManagedScript, (TermVariable)auxVar));
        }
        return substitutionMapping;
    }

    private Term getConstantAtInit(IProgramVar pv) {
        IProgramVar updated = FixpointCheck.replaceOldByNonOld(pv);
        return updated.getDefaultConstant();
    }

    private Term getConstantAtHonda(IProgramVar pv) {
        IProgramNonOldVar nonOld;
        boolean wasModifiedByStem = this.mStem.getAssignedVars().contains(pv);
        Object updated = pv.isOldvar() ? (this.mModifiableGlobalsAtHonda.contains(nonOld = ((IProgramOldVar)pv).getNonOldVar()) ? pv : nonOld) : pv;
        if (wasModifiedByStem) {
            return updated.getPrimedConstant();
        }
        return updated.getDefaultConstant();
    }

    public HasFixpoint getResult() {
        return this.mResult;
    }

    public InfiniteFixpointRepetition getTerminationArgument() {
        return this.mTerminationArgument;
    }

    public static enum HasFixpoint {
        YES,
        NO,
        UNKNOWN;

    }

    @FunctionalInterface
    private static interface IConstantMapper {
        public Term getConstant(IProgramVar var1);
    }
}

